/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.inspector;

import java.awt.Color;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.MSTabbedPaneUI;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.CollapsibleInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.Inspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.ClinvarSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.DetailedVariantSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneManiaSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.HGMDSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OntologySubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OtherIndividualsGeneSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.OtherIndividualsVariantSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SimpleVariant;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SimpleVariantSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SocialVariantSubInspector;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.appapi.MedSavantApp;
import org.ut.biolab.medsavant.shared.appapi.MedSavantGeneInspectorApp;
import org.ut.biolab.medsavant.shared.appapi.MedSavantVariantInspectorApp;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class ComprehensiveInspector
extends JTabbedPane
implements Listener<Object> {
    public static final int INSPECTOR_WIDTH = 380;
    public static final int INSPECTOR_INNER_WIDTH = 300;
    private GeneSubInspector geneSubInspector;
    private DetailedVariantSubInspector detailedVariantSubInspector;
    private SimpleVariantSubInspector simpleVariantInspector;
    private CollapsibleInspector variantCollapsibleInspector;
    private CollapsibleInspector geneCollapsibleInspector;
    private OntologySubInspector ontologySubInspector;
    private GeneManiaSubInspector geneManiaInspector;
    private MedSavantVariantInspectorApp[] appVariantInspectors;
    private SocialVariantSubInspector socialSubInspector;
    private OtherIndividualsVariantSubInspector otherIndividualsVariantSubInspector;
    private OtherIndividualsGeneSubInspector otherIndividualsDetailedSubInspector;
    private List<Listener<Object>> selectionListeners = new LinkedList<Listener<Object>>();
    private MedSavantGeneInspectorApp[] appGeneInspectors;
    private ClinvarSubInspector clinvarSubInspector = null;
    private HGMDSubInspector hgmdSubInspector = null;
    private MedSavantWorker<Object> variantRecordSetterThread;
    private VariantRecord currentVariantRecord;
    private MedSavantWorker<Object> variantSetterThread;
    private SimpleVariant currentSimpleVariant;
    private Object[] currentVariantLine;
    private List<String> currentHeader;
    String VARIANT_HELP_TITLE = "How to use the Variant Inspector";
    String VARIANT_HELP_TEXT = "The Variant Inspector shows detailed information about the variant selected from the Spreadsheet.";
    String GENE_HELP_TITLE = "How to use the Gene Inspector";
    String GENE_HELP_TEXT = "The Gene Inspector shows detailed information about the gene intersecting the variant selected from the Spreadsheet. If multiple genes intersect a variant, you can change which gene is being inspected via the Variant Inspector.";
    private MedSavantWorker<Void> eventHandlerThread;
    private Object currentEvent;
    private EnumMap<InspectorEnum, Integer> inspectorsToTabIndexMap = new EnumMap(InspectorEnum.class);

    public void refresh() {
        if (this.inspectorsToTabIndexMap != null) {
            if (this.currentSimpleVariant != null) {
                this.setSimpleVariant(this.currentSimpleVariant);
            } else if (this.currentVariantRecord != null) {
                this.setVariantRecord(this.currentVariantRecord);
            }
            if (this.currentVariantLine != null) {
                this.setVariantLine(this.currentVariantLine, this.currentHeader);
            }
        }
    }

    public void addSelectionListener(Listener<Object> selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public DetailedVariantSubInspector getDetailedVariantSubInspector() {
        return this.detailedVariantSubInspector;
    }

    public SocialVariantSubInspector getSocialSubInspector() {
        return this.socialSubInspector;
    }

    private void createSubInspectors(boolean createSimpleVariantInspector, boolean createDetailedVariantInspector, boolean createSocialVariantInspector, boolean createGeneSubInspector, boolean createOntologySubInspector, boolean createGeneManiaInspector, boolean createOtherIndividualsInspector, boolean createAppVariantInspectors, boolean createAppGeneInspectors, SplitScreenPanel splitScreenPanel) {
        this.variantCollapsibleInspector = new CollapsibleInspector(){

            @Override
            public String getName() {
                return "Variant";
            }
        };
        this.variantCollapsibleInspector.setMessage("No variant selected", this.VARIANT_HELP_TITLE, this.VARIANT_HELP_TEXT);
        this.variantCollapsibleInspector.switchToMessage();
        this.geneCollapsibleInspector = new CollapsibleInspector(){

            @Override
            public String getName() {
                return "Gene";
            }
        };
        this.geneCollapsibleInspector.setMessage("No gene selected", this.GENE_HELP_TITLE, this.GENE_HELP_TEXT);
        this.variantCollapsibleInspector.addComponent(ViewUtil.getHelpButton(this.VARIANT_HELP_TITLE, this.VARIANT_HELP_TEXT));
        if (createSimpleVariantInspector) {
            this.simpleVariantInspector = new SimpleVariantSubInspector();
            this.variantCollapsibleInspector.addSubInspector(this.simpleVariantInspector);
        }
        if (createDetailedVariantInspector) {
            this.detailedVariantSubInspector = new DetailedVariantSubInspector();
            this.variantCollapsibleInspector.addSubInspector(this.detailedVariantSubInspector);
        }
        if (createSocialVariantInspector) {
            this.socialSubInspector = new SocialVariantSubInspector();
            this.variantCollapsibleInspector.addSubInspector(this.socialSubInspector);
        }
        if (createOtherIndividualsInspector) {
            this.otherIndividualsVariantSubInspector = new OtherIndividualsVariantSubInspector(splitScreenPanel);
            this.otherIndividualsVariantSubInspector.setVariantSelectionListener(this);
            this.variantCollapsibleInspector.addSubInspector(this.otherIndividualsVariantSubInspector);
        }
        if (createAppVariantInspectors) {
            this.loadVariantInspectorApps();
            for (final MedSavantVariantInspectorApp medSavantVariantInspectorApp : this.appVariantInspectors) {
                this.variantCollapsibleInspector.addSubInspector(new SubInspector(){

                    @Override
                    public String getName() {
                        return medSavantVariantInspectorApp.getName();
                    }

                    @Override
                    public JPanel getInfoPanel() {
                        return medSavantVariantInspectorApp.getInfoPanel();
                    }
                });
            }
        }
        this.geneCollapsibleInspector.addComponent(ViewUtil.getHelpButton(this.GENE_HELP_TITLE, this.GENE_HELP_TEXT));
        if (createGeneSubInspector) {
            this.geneSubInspector = new GeneSubInspector();
            this.geneCollapsibleInspector.addSubInspector(this.geneSubInspector);
        }
        if (createOtherIndividualsInspector) {
            this.otherIndividualsDetailedSubInspector = new OtherIndividualsGeneSubInspector(splitScreenPanel);
            this.otherIndividualsDetailedSubInspector.setVariantSelectionListener(this);
            this.geneCollapsibleInspector.addSubInspector(this.otherIndividualsDetailedSubInspector);
        }
        if (createOntologySubInspector) {
            this.ontologySubInspector = new OntologySubInspector();
            this.geneCollapsibleInspector.addSubInspector(this.ontologySubInspector);
        }
        if (createGeneManiaInspector) {
            this.geneManiaInspector = new GeneManiaSubInspector();
            this.geneCollapsibleInspector.addSubInspector(this.geneManiaInspector);
            this.geneManiaInspector.setGeneListener(this);
        }
        if (createAppGeneInspectors) {
            this.loadGeneInspectorApps();
            for (MedSavantApp medSavantApp : this.appGeneInspectors) {
                this.geneCollapsibleInspector.addSubInspector(new SubInspector((MedSavantGeneInspectorApp)medSavantApp){
                    final /* synthetic */ MedSavantGeneInspectorApp val$app;
                    {
                        this.val$app = medSavantGeneInspectorApp;
                    }

                    @Override
                    public String getName() {
                        return this.val$app.getName();
                    }

                    @Override
                    public JPanel getInfoPanel() {
                        return this.val$app.getInfoPanel();
                    }
                });
            }
        }
        this.addTabPanel(InspectorEnum.VARIANT, this.variantCollapsibleInspector);
        this.addTabPanel(InspectorEnum.GENE, this.geneCollapsibleInspector);
    }

    private void loadVariantInspectorApps() {
        LinkedList<MedSavantVariantInspectorApp> results = new LinkedList<MedSavantVariantInspectorApp>();
        for (AppDescriptor ad : AppController.getInstance().getDescriptors()) {
            MedSavantApp ap = AppController.getInstance().getPlugin(ad.getID());
            if (!(ap instanceof MedSavantVariantInspectorApp)) continue;
            results.add((MedSavantVariantInspectorApp)ap);
        }
        this.appVariantInspectors = results.toArray(new MedSavantVariantInspectorApp[results.size()]);
    }

    private void loadGeneInspectorApps() {
        LinkedList<MedSavantGeneInspectorApp> results = new LinkedList<MedSavantGeneInspectorApp>();
        for (AppDescriptor ad : AppController.getInstance().getDescriptors()) {
            MedSavantApp ap = AppController.getInstance().getPlugin(ad.getID());
            if (!(ap instanceof MedSavantGeneInspectorApp)) continue;
            results.add((MedSavantGeneInspectorApp)ap);
        }
        this.appGeneInspectors = results.toArray(new MedSavantGeneInspectorApp[results.size()]);
    }

    public CollapsibleInspector getVariantInspector() {
        return this.variantCollapsibleInspector;
    }

    public CollapsibleInspector getGeneInspector() {
        return this.geneCollapsibleInspector;
    }

    public void setVariantRecord(VariantRecord r) {
        this.currentVariantRecord = r;
        if (r == null) {
            this.getVariantInspector().setMessage("No variant selected", this.VARIANT_HELP_TITLE, this.VARIANT_HELP_TEXT);
            this.getVariantInspector().switchToMessage();
            return;
        }
        if (this.variantRecordSetterThread == null || this.variantRecordSetterThread.isDone()) {
            this.switchToVariantInspector();
            final SimpleVariant sv = new SimpleVariant(r.getChrom(), r.getStartPosition(), r.getEndPosition(), r.getRef(), r.getAlt(), r.getType().toString());
            final ComprehensiveInspector instance = this;
            instance.getVariantInspector().setMessage(new WaitPanel("Getting detailed variant information..."));
            instance.getVariantInspector().switchToMessage();
            this.variantRecordSetterThread = new MedSavantWorker<Object>("SubInspector"){

                @Override
                protected void showProgress(double fract) {
                }

                @Override
                protected void showSuccess(Object result) {
                    instance.getVariantInspector().switchToPanes();
                }

                @Override
                protected Object doInBackground() throws Exception {
                    VariantRecord r;
                    do {
                        r = ComprehensiveInspector.this.currentVariantRecord;
                        instance.simpleVariantInspector.setSimpleVariant(sv);
                        if (ComprehensiveInspector.this.detailedVariantSubInspector != null) {
                            instance.detailedVariantSubInspector.setVariantRecord(r);
                        }
                        if (instance.otherIndividualsVariantSubInspector != null) {
                            instance.otherIndividualsVariantSubInspector.handleEvent(sv);
                        }
                        if (instance.socialSubInspector != null) {
                            instance.socialSubInspector.handleEvent(r);
                        }
                        if (ComprehensiveInspector.this.appVariantInspectors == null) continue;
                        for (MedSavantVariantInspectorApp app : ComprehensiveInspector.this.appVariantInspectors) {
                            app.setVariantRecord(r);
                        }
                    } while (ComprehensiveInspector.this.currentVariantRecord != r);
                    return null;
                }
            };
            this.variantRecordSetterThread.execute();
        }
    }

    public void setGene(final Gene gene) {
        if (gene == null) {
            this.getGeneInspector().setMessage("No gene selected", this.GENE_HELP_TITLE, this.GENE_HELP_TEXT);
            this.getGeneInspector().switchToMessage();
            return;
        }
        this.switchToGeneInspector();
        this.getGeneInspector().setMessage(new WaitPanel("Getting detailed gene information..."));
        this.getGeneInspector().switchToMessage();
        new MedSavantWorker<Object>("SubInspector"){

            @Override
            protected void showProgress(double fract) {
            }

            @Override
            protected void showSuccess(Object result) {
                ComprehensiveInspector.this.getGeneInspector().switchToPanes();
            }

            @Override
            protected Object doInBackground() throws Exception {
                if (ComprehensiveInspector.this.geneSubInspector != null) {
                    ComprehensiveInspector.this.geneSubInspector.handleEvent(gene);
                }
                if (ComprehensiveInspector.this.ontologySubInspector != null) {
                    ComprehensiveInspector.this.ontologySubInspector.handleEvent(gene);
                }
                if (ComprehensiveInspector.this.geneManiaInspector != null) {
                    ComprehensiveInspector.this.geneManiaInspector.handleEvent(gene);
                }
                if (ComprehensiveInspector.this.otherIndividualsDetailedSubInspector != null) {
                    ComprehensiveInspector.this.otherIndividualsDetailedSubInspector.handleEvent(gene);
                }
                if (ComprehensiveInspector.this.appGeneInspectors != null) {
                    for (MedSavantGeneInspectorApp app : ComprehensiveInspector.this.appGeneInspectors) {
                        app.setGene(gene);
                    }
                }
                return null;
            }
        }.execute();
    }

    public synchronized void setSimpleVariant(SimpleVariant sv) {
        this.currentSimpleVariant = sv;
        if (this.variantSetterThread == null || this.variantSetterThread.isDone()) {
            final ComprehensiveInspector instance = this;
            instance.getVariantInspector().setMessage(new WaitPanel("Getting detailed variant information..."));
            instance.getVariantInspector().switchToMessage();
            this.variantSetterThread = new MedSavantWorker<Object>("SubInspector"){

                @Override
                protected void showProgress(double fract) {
                }

                @Override
                protected void showSuccess(Object result) {
                    instance.getVariantInspector().switchToPanes();
                }

                @Override
                protected Object doInBackground() throws Exception {
                    SimpleVariant sv;
                    do {
                        if ((sv = ComprehensiveInspector.this.currentSimpleVariant) == null) continue;
                        if (instance.simpleVariantInspector != null) {
                            instance.simpleVariantInspector.setSimpleVariant(sv);
                        }
                        if (instance.otherIndividualsVariantSubInspector == null) continue;
                        instance.otherIndividualsVariantSubInspector.handleEvent(sv);
                    } while (ComprehensiveInspector.this.currentSimpleVariant != sv);
                    return null;
                }
            };
            this.variantSetterThread.execute();
        }
    }

    @Override
    public synchronized void handleEvent(final Object event) {
        this.currentEvent = event;
        if (this.eventHandlerThread == null || this.eventHandlerThread.isDone()) {
            this.eventHandlerThread = new MedSavantWorker<Void>("SubInspector"){

                @Override
                protected Void doInBackground() throws Exception {
                    do {
                        if (event instanceof Gene) {
                            ComprehensiveInspector.this.setGene((Gene)event);
                        } else if (event instanceof SimpleVariant) {
                            ComprehensiveInspector.this.setSimpleVariant((SimpleVariant)event);
                        } else if (event instanceof VariantRecord) {
                            ComprehensiveInspector.this.setVariantRecord((VariantRecord)event);
                        }
                        for (Listener l : ComprehensiveInspector.this.selectionListeners) {
                            l.handleEvent(event);
                        }
                    } while (ComprehensiveInspector.this.currentEvent != event);
                    return null;
                }

                @Override
                protected void showSuccess(Void result) {
                }
            };
            this.eventHandlerThread.execute();
        }
    }

    public ComprehensiveInspector(boolean createSimpleVariantInspector, boolean createDetailedVariantInspector, boolean createSocialVariantInspector, boolean createGeneSubInspector, boolean createOntologySubInspector, boolean createGeneManiaInspector, boolean createOtherIndividualsInspector, boolean createVariantAppInspectors, boolean createAppGeneInspectors, SplitScreenPanel splitScreenPanel) {
        this.setTabPlacement(1);
        this.setBorder(ViewUtil.getBigBorder());
        this.createSubInspectors(createSimpleVariantInspector, createDetailedVariantInspector, createSocialVariantInspector, createGeneSubInspector, createOntologySubInspector, createGeneManiaInspector, createOtherIndividualsInspector, createVariantAppInspectors, createAppGeneInspectors, splitScreenPanel);
        if (createSimpleVariantInspector) {
            this.simpleVariantInspector.setGeneListener(this);
        }
    }

    @Override
    public Color getForegroundAt(int index) {
        if (this.getSelectedIndex() == index) {
            return Color.BLACK;
        }
        return new Color(40, 40, 40);
    }

    public ComprehensiveInspector() {
        this.variantCollapsibleInspector = new CollapsibleInspector(){

            @Override
            public String getName() {
                return "Variant";
            }
        };
        this.variantCollapsibleInspector.setMessage("No variant selected", this.VARIANT_HELP_TITLE, this.VARIANT_HELP_TEXT);
        this.variantCollapsibleInspector.switchToMessage();
        this.geneCollapsibleInspector = new CollapsibleInspector(){

            @Override
            public String getName() {
                return "Gene";
            }
        };
        this.geneCollapsibleInspector.setMessage("No gene selected", this.GENE_HELP_TITLE, this.GENE_HELP_TEXT);
        this.addTabPanel(InspectorEnum.VARIANT, this.variantCollapsibleInspector);
        this.addTabPanel(InspectorEnum.GENE, this.geneCollapsibleInspector);
        this.setUI(new MSTabbedPaneUI());
        this.setFocusable(false);
    }

    public void switchToGeneInspector() {
        this.switchToInspector(InspectorEnum.GENE);
    }

    public void switchToVariantInspector() {
        this.switchToInspector(InspectorEnum.VARIANT);
    }

    private void switchToInspector(InspectorEnum i) {
        this.setSelectedIndex(this.inspectorsToTabIndexMap.get((Object)i));
    }

    private void addTabPanel(InspectorEnum i, Inspector inspector) {
        this.inspectorsToTabIndexMap.put(i, this.getTabCount());
        JScrollPane jsp = ViewUtil.getClearBorderlessScrollPane(inspector.getContent());
        jsp.setHorizontalScrollBarPolicy(31);
        this.addTab(inspector.getName(), null, jsp, inspector.getName());
    }

    public void addSimpleVariantInspector() {
        this.simpleVariantInspector = new SimpleVariantSubInspector();
        this.simpleVariantInspector.setGeneListener(this);
        this.variantCollapsibleInspector.addSubInspector(this.simpleVariantInspector);
    }

    public void addDetailedVariantInspector() {
        this.detailedVariantSubInspector = new DetailedVariantSubInspector();
        this.variantCollapsibleInspector.addSubInspector(this.detailedVariantSubInspector);
    }

    public void addSocialSubInspector() {
        this.socialSubInspector = new SocialVariantSubInspector();
        this.variantCollapsibleInspector.addSubInspector(this.socialSubInspector);
    }

    public void addOtherIndividualsVariantSubInspector(SplitScreenPanel splitScreenPanel) {
        this.otherIndividualsVariantSubInspector = new OtherIndividualsVariantSubInspector(splitScreenPanel);
        this.otherIndividualsVariantSubInspector.setVariantSelectionListener(this);
        this.variantCollapsibleInspector.addSubInspector(this.otherIndividualsVariantSubInspector);
    }

    public void addClinvarSubInspector() {
        this.clinvarSubInspector = new ClinvarSubInspector();
        this.variantCollapsibleInspector.addSubInspector(this.clinvarSubInspector);
    }

    public void addHGMDSubInspector() {
        this.hgmdSubInspector = new HGMDSubInspector();
        this.variantCollapsibleInspector.addSubInspector(this.hgmdSubInspector);
    }

    public void setVariantLine(Object[] line, List<String> header) {
        this.currentVariantLine = line;
        if (line != null) {
            if (this.clinvarSubInspector != null) {
                this.clinvarSubInspector.setVariantLine(line, header);
            }
            if (this.hgmdSubInspector != null) {
                this.hgmdSubInspector.setVariantLine(line, header);
            }
        }
    }

    private static enum InspectorEnum {
        VARIANT,
        GENE;

    }
}

