/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import java.awt.Color;
import java.awt.Shape;
import java.util.Vector;
import org.ut.biolab.medsavant.client.view.genetics.charts.ArcSegment;

public class Ring {
    private Vector<String> Labels = new Vector();
    private Vector<Double> Values = new Vector();
    private Vector<Color> Colors = new Vector();
    private double x;
    private double y;
    private double radius;
    private double ringwidth;
    private double start = 0.0;
    private double end = 360.0;
    private Shape[] segments = null;

    public void setStart(double start) {
        this.start = start;
    }

    public void setEnd(double end) {
        this.end = end;
    }

    public double getValue(int i) {
        if (this.segments == null) {
            this.createSegments();
        }
        return this.Values.get(i);
    }

    public int count() {
        if (this.segments == null) {
            this.createSegments();
        }
        return this.Values.size();
    }

    public String getLabel(int index) {
        return this.Labels.get(index);
    }

    public Color getColor(int index) {
        return this.Colors.get(index);
    }

    public void setCenter(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setRingWidth(double width) {
        this.ringwidth = width;
    }

    public void addItem(String label, double val, Color color) {
        this.Labels.add(label);
        this.Values.add(val);
        this.Colors.add(color);
    }

    public Shape getSegment(int index) {
        if (this.segments == null) {
            this.createSegments();
        }
        return this.segments[index];
    }

    public void createSegments() {
        Shape[] shapes = new Shape[this.Values.size()];
        double sum = 0.0;
        double span = this.end - this.start;
        for (int i = 0; i < this.Values.size(); ++i) {
            sum += this.Values.get(i).doubleValue();
        }
        double strt = this.start;
        for (int i = 0; i < this.Values.size(); ++i) {
            double extent = this.Values.get(i) / sum * span;
            ArcSegment arc = new ArcSegment();
            shapes[i] = arc.Create(this.x, this.y, this.radius, this.ringwidth, strt, extent);
            strt += extent;
        }
        this.segments = shapes;
    }
}

