/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartMapGenerator;
import org.ut.biolab.medsavant.client.view.genetics.charts.SummaryChart;
import org.ut.biolab.medsavant.client.view.genetics.charts.VariantFieldChartMapGenerator;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.db.ColumnDef;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;

public class ChartView
extends JPanel
implements BasicPatientColumns,
BasicVariantColumns {
    private SummaryChart sc;
    private JComboBox chartChooser1;
    private JComboBox chartChooser2;
    private Map<String, ChartMapGenerator> mapGenerators;
    private JCheckBox bPie;
    private JCheckBox bSort;
    private JCheckBox bLogY;
    private JCheckBox bLogX;
    private JCheckBox bScatter;
    private String pageName;
    private boolean init = false;
    private JCheckBox bOriginal;
    private JPanel bottomToolbar;

    public ChartView(String pageName) throws RemoteException, SQLException {
        this.pageName = pageName;
        this.mapGenerators = new HashMap<String, ChartMapGenerator>();
        this.setLayout(new BorderLayout());
        this.initToolBar();
        this.initCards();
        this.initBottomBar();
        this.init = true;
        this.chartChooser1.setSelectedItem(DNA_ID.getAlias());
    }

    private void initToolBar() {
        JPanel toolbar = ViewUtil.getSubBannerPanel("Chart");
        toolbar.setLayout(new BoxLayout(toolbar, 0));
        this.chartChooser1 = new JComboBox(){

            public void addItem(Object anObject) {
                int size = ((DefaultComboBoxModel)this.dataModel).getSize();
                boolean added = false;
                for (int i = 0; i < size; ++i) {
                    Object obj = this.dataModel.getElementAt(i);
                    int compare = anObject.toString().compareToIgnoreCase(obj.toString());
                    if (compare > 0) continue;
                    super.insertItemAt(anObject, i);
                    added = true;
                    break;
                }
                if (!added) {
                    super.addItem(anObject);
                }
            }
        };
        toolbar.add(this.chartChooser1);
        this.chartChooser1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChartView.this.init) {
                    return;
                }
                String alias = (String)ChartView.this.chartChooser1.getSelectedItem();
                ChartMapGenerator cmg = (ChartMapGenerator)ChartView.this.mapGenerators.get(alias);
                if (alias.equals(BasicVariantColumns.CHROM.getAlias())) {
                    ChartView.this.bSort.setEnabled(false);
                    ChartView.this.sc.setIsSortedKaryotypically(true);
                } else if (cmg.isNumeric()) {
                    ChartView.this.bSort.setEnabled(false);
                    ChartView.this.sc.setIsSortedKaryotypically(false);
                } else {
                    ChartView.this.bSort.setEnabled(true);
                    ChartView.this.sc.setIsSortedKaryotypically(false);
                }
                ChartView.this.sc.setChartMapGenerator(cmg);
                ChartView.this.sc.setChartName(alias);
                ChartView.this.sc.setScatterChartMapGenerator((ChartMapGenerator)ChartView.this.mapGenerators.get((String)ChartView.this.chartChooser2.getSelectedItem()));
                ChartView.this.bLogX.setEnabled(cmg.isNumeric());
                ChartView.this.sc.setUpdateRequired(true);
                ChartView.this.sc.updateIfRequired();
            }
        });
        toolbar.add(Box.createHorizontalGlue());
        this.bScatter = new JCheckBox("Group By");
        this.bScatter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.chartChooser2.setEnabled(ChartView.this.bScatter.isSelected());
                ChartView.this.sc.setIsScatterChart(ChartView.this.bScatter.isSelected());
                ChartView.this.bottomToolbar.setVisible(!ChartView.this.bScatter.isSelected());
                ChartView.this.sc.setUpdateRequired(true);
                ChartView.this.sc.updateIfRequired();
            }
        });
        toolbar.add(this.bScatter);
        this.chartChooser2 = new JComboBox(){

            public void addItem(Object anObject) {
                int size = ((DefaultComboBoxModel)this.dataModel).getSize();
                boolean added = false;
                for (int i = 0; i < size; ++i) {
                    Object obj = this.dataModel.getElementAt(i);
                    int compare = anObject.toString().compareToIgnoreCase(obj.toString());
                    if (compare > 0) continue;
                    super.insertItemAt(anObject, i);
                    added = true;
                    break;
                }
                if (!added) {
                    super.addItem(anObject);
                }
            }
        };
        this.chartChooser2.setEnabled(false);
        toolbar.add(this.chartChooser2);
        this.chartChooser2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ChartView.this.init) {
                    return;
                }
                ChartView.this.sc.setScatterChartMapGenerator((ChartMapGenerator)ChartView.this.mapGenerators.get((String)ChartView.this.chartChooser2.getSelectedItem()));
                ChartView.this.sc.setUpdateRequired(true);
                ChartView.this.sc.updateIfRequired();
            }
        });
        ButtonGroup rg = new ButtonGroup();
        JRadioButton b1 = new JRadioButton("All");
        JRadioButton b2 = new JRadioButton("Cohort");
        rg.add(b1);
        rg.add(b2);
        b1.setSelected(true);
        this.add((Component)toolbar, "North");
    }

    private void initCards() throws RemoteException, SQLException {
        this.initAllCard();
        this.addCMGs();
    }

    private void initAllCard() {
        JPanel h1 = new JPanel();
        h1.setLayout(new GridLayout(1, 1));
        this.sc = new SummaryChart(this.pageName);
        h1.add((Component)this.sc, "Center");
        this.add((Component)h1, "Center");
    }

    private void addCMG(String key, ChartMapGenerator cmg) {
        this.mapGenerators.put(key, cmg);
        this.chartChooser1.addItem(key);
        this.chartChooser2.addItem(key);
    }

    private void addCMG(ChartMapGenerator cmg) {
        this.addCMG(cmg.getName(), cmg);
    }

    private void addCMGs() throws RemoteException, SQLException {
        AnnotationFormat[] afs = ProjectController.getInstance().getCurrentAnnotationFormats();
        for (AnnotationFormat annotationFormat : afs) {
            for (CustomField field : annotationFormat.getCustomFields()) {
                ColumnType type = field.getColumnType();
                if ((!field.isFilterable() || !type.equals((Object)ColumnType.VARCHAR) && !type.equals((Object)ColumnType.BOOLEAN) && !type.equals((Object)ColumnType.DECIMAL) && !type.equals((Object)ColumnType.FLOAT) && !type.equals((Object)ColumnType.INTEGER) || field.getColumnName().equals(FILE_ID.getColumnName())) && !field.getColumnName().equals(UPLOAD_ID.getColumnName()) && !field.getColumnName().equals(DBSNP_ID.getColumnName()) && !field.getColumnName().equals(VARIANT_ID.getColumnName())) continue;
                String program = annotationFormat.getProgram();
                String name = field.getAlias() + " (" + program + ")";
                this.addCMG(name, VariantFieldChartMapGenerator.createVariantChart(field));
            }
        }
        for (Serializable serializable : ProjectController.getInstance().getCurrentPatientFormat()) {
            ColumnType type = ((ColumnDef)serializable).getColumnType();
            if (!((CustomField)serializable).isFilterable() || !type.equals((Object)ColumnType.VARCHAR) && !type.equals((Object)ColumnType.BOOLEAN) && !type.equals((Object)ColumnType.DECIMAL) && !type.equals((Object)ColumnType.FLOAT) && !type.equals((Object)ColumnType.INTEGER) || ((ColumnDef)serializable).getColumnName().equals(PATIENT_ID.getColumnName()) || ((ColumnDef)serializable).getColumnName().equals(FAMILY_ID.getColumnName()) || ((ColumnDef)serializable).getColumnName().equals(IDBIOMOM.getColumnName()) || ((ColumnDef)serializable).getColumnName().equals(IDBIODAD.getColumnName())) continue;
            this.addCMG(VariantFieldChartMapGenerator.createPatientChart((CustomField)serializable));
        }
    }

    private void initBottomBar() {
        this.bottomToolbar = ViewUtil.getSecondaryBannerPanel();
        this.bottomToolbar.setBorder(ViewUtil.getTopLineBorder());
        this.bottomToolbar.setLayout(new BoxLayout(this.bottomToolbar, 0));
        this.bottomToolbar.add(Box.createHorizontalGlue());
        this.bPie = new JCheckBox("Pie chart");
        this.bOriginal = new JCheckBox("Show original frequencies");
        this.bSort = new JCheckBox("Sort by frequency");
        this.bLogY = new JCheckBox("Log scale Y axis");
        this.bLogX = new JCheckBox("Log scale X axis");
        this.bPie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.setIsPie(!ChartView.this.sc.isPie());
            }
        });
        this.bOriginal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.setDoesCompareToOriginal(!ChartView.this.sc.doesCompareToOriginal());
            }
        });
        this.bSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.setIsSorted(!ChartView.this.sc.isSorted());
            }
        });
        this.bLogY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.setIsLogScale(!ChartView.this.sc.isLogScaleY(), SummaryChart.ChartAxis.Y);
            }
        });
        this.bLogX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartView.this.setIsLogScale(!ChartView.this.sc.isLogScaleX(), SummaryChart.ChartAxis.X);
            }
        });
        this.bottomToolbar.add(ViewUtil.getMediumSeparator());
        this.bottomToolbar.add(ViewUtil.clear(this.bPie));
        this.bottomToolbar.add(ViewUtil.clear(this.bOriginal));
        this.bottomToolbar.add(ViewUtil.clear(this.bSort));
        this.bottomToolbar.add(ViewUtil.clear(this.bLogY));
        this.bottomToolbar.add(ViewUtil.clear(this.bLogX));
        this.bottomToolbar.add(Box.createHorizontalGlue());
        this.add((Component)this.bottomToolbar, "South");
    }

    public void setIsPie(boolean b) {
        if (this.bPie.isEnabled()) {
            this.sc.setIsPie(!this.sc.isPie());
            this.bPie.setSelected(this.sc.isPie());
            if (b) {
                this.bOriginal.setEnabled(false);
            } else {
                this.bOriginal.setEnabled(true);
            }
        }
    }

    public void setDoesCompareToOriginal(boolean b) {
        if (this.bOriginal.isEnabled()) {
            this.sc.setDoesCompareToOriginal(!this.sc.doesCompareToOriginal());
            this.bOriginal.setSelected(this.sc.doesCompareToOriginal());
        }
    }

    public void setIsSorted(boolean b) {
        if (this.bSort.isEnabled()) {
            this.sc.setIsSorted(b);
        }
    }

    public void setIsLogScale(boolean b, SummaryChart.ChartAxis axis) {
        if (axis == SummaryChart.ChartAxis.Y && !this.bLogY.isEnabled() || axis == SummaryChart.ChartAxis.X && !this.bLogX.isEnabled()) {
            return;
        }
        this.sc.setIsLogScale(b, axis);
        this.bLogY.setSelected(this.sc.isLogScaleY());
        this.bLogX.setSelected(this.sc.isLogScaleX());
    }

    public void updateIfRequired() {
        if (this.sc != null) {
            this.sc.updateIfRequired();
        }
    }

    public void setUpdateRequired(boolean required) {
        if (this.sc != null) {
            this.sc.setUpdateRequired(required);
        }
    }
}

