/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.filter.FilterEffectivenessPanel;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.component.SearchableTablePanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.genetics.charts.Ring;
import org.ut.biolab.medsavant.client.view.genetics.charts.RingChart;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.VariantComment;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class TablePanel
extends JLayeredPane
implements BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(TablePanel.class);
    private WaitPanel waitPanel;
    private boolean updateRequired = true;
    private String pageName;
    private Map<Integer, List<VariantComment>> starMap = new HashMap<Integer, List<VariantComment>>();
    private static List<Listener<VariantRecord>> listeners = new ArrayList<Listener<VariantRecord>>();
    private final JPanel activePanel;
    private final JPanel summaryContainer;
    private final JPanel tableContainer;
    private SearchableTablePanel searchableTablePanel;
    private boolean tableShowing;
    private RingChart ringChart;

    public void clearSelection() {
        if (this.searchableTablePanel != null) {
            this.searchableTablePanel.getTable().clearSelection();
        }
    }

    public TablePanel(String page) {
        this.pageName = page;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.summaryContainer = new JPanel();
        this.summaryContainer.setLayout(new BorderLayout());
        this.tableContainer = new JPanel();
        this.tableContainer.setLayout(new BorderLayout());
        this.activePanel = new JPanel();
        this.activePanel.setLayout(new BorderLayout());
        this.add(this.activePanel, gbc, JLayeredPane.DEFAULT_LAYER);
        this.waitPanel = new WaitPanel("Retrieving variants");
        this.add(this.waitPanel, gbc, JLayeredPane.MODAL_LAYER);
    }

    private void showWaitCard() {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                TablePanel.this.waitPanel.setVisible(true);
                TablePanel.this.setLayer(TablePanel.this.waitPanel, JLayeredPane.MODAL_LAYER);
                TablePanel.this.waitPanel.repaint();
            }
        });
    }

    private void showShowCard() {
        MiscUtils.invokeLaterIfNecessary(new Runnable(){

            @Override
            public void run() {
                TablePanel.this.waitPanel.setVisible(false);
                TablePanel.this.activePanel.repaint();
            }
        });
    }

    void queueUpdate() {
        this.updateRequired = true;
        if (this.tableShowing) {
            this.forceTableRefresh();
        }
    }

    void setTableShowing(boolean b) {
        this.tableShowing = b;
        if (b && this.updateRequired) {
            this.forceTableRefresh();
        }
    }

    public static void addVariantSelectionChangedListener(Listener<VariantRecord> l) {
        listeners.add(l);
    }

    private void updateSummary() {
        try {
            int numPassingVariants = ResultController.getInstance().getFilteredVariantCount();
            System.out.println("Num passing " + numPassingVariants + " " + new Date().toLocaleString());
            JPanel blockPanel = new JPanel();
            ViewUtil.applyVerticalBoxLayout(blockPanel);
            this.ringChart = new RingChart();
            int ringDiameter = 200;
            this.ringChart.setMinimumSize(new Dimension(ringDiameter, ringDiameter));
            this.ringChart.setMaximumSize(new Dimension(ringDiameter, ringDiameter));
            this.ringChart.setPreferredSize(new Dimension(ringDiameter, ringDiameter));
            Ring r1 = new Ring();
            r1.addItem("Pass all filters", numPassingVariants, new Color(72, 181, 249));
            r1.addItem("Don't pass filters", ResultController.getInstance().getTotalVariantCount() - numPassingVariants, Color.gray);
            r1.setRingWidth(4.0);
            this.ringChart.setRings(Arrays.asList(r1));
            JButton b = ViewUtil.getSoftButton("Load Spreadsheet");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TablePanel.this.updateRequired = true;
                    TablePanel.this.showWaitCard();
                    TablePanel.this.setActivePanel(true);
                    if (TablePanel.this.searchableTablePanel == null) {
                        new TableInitializer().execute();
                    } else {
                        TablePanel.this.updateTableIfRequired();
                    }
                }
            });
            FilterEffectivenessPanel fep = new FilterEffectivenessPanel();
            blockPanel.add(ViewUtil.centerHorizontally(this.ringChart));
            blockPanel.add(Box.createVerticalStrut(5));
            blockPanel.add(fep);
            blockPanel.add(Box.createVerticalStrut(5));
            blockPanel.add(ViewUtil.centerHorizontally(b));
            JPanel centered = ViewUtil.getClearPanel();
            ViewUtil.applyVerticalBoxLayout(centered);
            centered.add(Box.createVerticalGlue());
            centered.add(blockPanel);
            centered.add(Box.createVerticalGlue());
            this.summaryContainer.removeAll();
            this.summaryContainer.add((Component)ViewUtil.centerHorizontally(centered), "Center");
        }
        catch (Exception ex) {
            LOG.error(TablePanel.class, (Throwable)ex);
        }
    }

    public void updateTableIfRequired() {
        if (this.searchableTablePanel == null) {
            return;
        }
        if (this.updateRequired) {
            this.searchableTablePanel.forceRefreshData();
        }
    }

    private JPopupMenu createPopupSingle() {
        JPopupMenu menu = new JPopupMenu();
        TableModel model = this.searchableTablePanel.getTable().getModel();
        int r = TableModelWrapperUtils.getActualRowAt((TableModel)model, (int)this.searchableTablePanel.getTable().getSelectedRow());
        final String chrom = (String)model.getValueAt(r, 4);
        final int startpos = (Integer)model.getValueAt(r, 5);
        final int endpos = (Integer)model.getValueAt(r, 6);
        final String alt = (String)model.getValueAt(r, 9);
        JMenuItem posItem = new JMenuItem("Filter by Position");
        posItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ArrayList<GenomicRegion> gr = new ArrayList<GenomicRegion>(1);
                gr.add(new GenomicRegion(null, chrom, startpos, endpos));
                QueryUtils.addQueryOnRegions(gr, null);
            }
        });
        menu.add(posItem);
        JMenuItem posAndAltItem = new JMenuItem("Filter by Position and Alt");
        posAndAltItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryUtils.addQueryOnRegionWithAlt(new GenomicRegion(null, chrom, startpos, endpos), alt);
            }
        });
        menu.add(posAndAltItem);
        return menu;
    }

    private void setActivePanel(boolean showTable) {
        JPanel p = showTable ? this.tableContainer : this.summaryContainer;
        this.activePanel.removeAll();
        this.activePanel.add((Component)p, "Center");
    }

    private void forceTableRefresh() {
        this.showWaitCard();
        this.updateSummary();
        this.setActivePanel(false);
        this.showShowCard();
    }

    private JPopupMenu createPopupMultiple() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem posItem = new JMenuItem("Filter by Selected Positions");
        posItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ThreadController.getInstance().cancelWorkers(TablePanel.this.pageName);
                ArrayList<GenomicRegion> regions = new ArrayList<GenomicRegion>();
                TableModel model = TablePanel.this.searchableTablePanel.getTable().getModel();
                int[] selRows = TableModelWrapperUtils.getActualRowsAt((TableModel)model, (int[])TablePanel.this.searchableTablePanel.getTable().getSelectedRows(), (boolean)false);
                ArrayList sciList = new ArrayList(selRows.length);
                for (int r : selRows) {
                    String chrom = (String)model.getValueAt(r, 4);
                    int startpos = (Integer)model.getValueAt(r, 5);
                    int endpos = (Integer)model.getValueAt(r, 6);
                    regions.add(new GenomicRegion(null, chrom, startpos, endpos));
                }
                QueryUtils.addQueryOnRegions(regions, null);
            }
        });
        menu.add(posItem);
        return menu;
    }

    private boolean isStarredByUser(int row) {
        if (!this.starMap.containsKey(row)) {
            return false;
        }
        List<VariantComment> starred = this.starMap.get(row);
        for (VariantComment current : starred) {
            if (!current.getUser().equals(LoginController.getInstance().getUserName())) continue;
            return true;
        }
        return false;
    }

    private void removeStarForUser(int row) {
        List<VariantComment> list = this.starMap.get(row);
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            VariantComment current = list.get(i);
            if (!current.getUser().equals(LoginController.getInstance().getUserName())) continue;
            index = i;
        }
        if (index != -1) {
            list.remove(index);
        }
    }

    private void selectItem() {
        block5: {
            try {
                SortableTable t = this.searchableTablePanel.getTable();
                int[] selRows = t.getSelectedRows();
                if (selRows.length <= 0) break block5;
                int rowToFetch = selRows[0];
                int uploadID = (Integer)t.getModel().getValueAt(rowToFetch, 0);
                int fileID = (Integer)t.getModel().getValueAt(rowToFetch, 1);
                int variantID = (Integer)t.getModel().getValueAt(rowToFetch, 2);
                DbColumn uIDcol = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(UPLOAD_ID);
                DbColumn fIDcol = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(FILE_ID);
                DbColumn vIDcol = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(VARIANT_ID);
                Condition[][] conditions = new Condition[1][3];
                conditions[0][0] = BinaryConditionMS.equalTo(uIDcol, uploadID);
                conditions[0][1] = BinaryConditionMS.equalTo(fIDcol, fileID);
                conditions[0][2] = BinaryConditionMS.equalTo(vIDcol, variantID);
                List<Object[]> rows = MedSavantClient.VariantManager.getVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditions, 0, 1);
                Object[] row = rows.get(0);
                VariantRecord r = new VariantRecord((Integer)row[0], (Integer)row[1], (Integer)row[2], ReferenceController.getInstance().getCurrentReferenceID(), 0, (String)row[3], (String)row[4], ((Integer)row[5]).intValue(), ((Integer)row[6]).intValue(), (String)row[7], (String)row[8], (String)row[9], (Integer)row[10], ((Float)row[11]).floatValue(), (String)row[12], (String)row[16], new Object[0]);
                String type = (String)row[13];
                String zygosity = (String)row[14];
                String genotype = (String)row[15];
                r.setType(VariantRecord.VariantType.valueOf(type));
                try {
                    r.setZygosity(VariantRecord.Zygosity.valueOf(zygosity));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                r.setGenotype(genotype);
                for (Listener<VariantRecord> l : listeners) {
                    l.handleEvent(r);
                }
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("There was a problem retrieving variant results: %s", ex);
            }
        }
    }

    private class TableDataRetriever
    extends DataRetriever<Object[]> {
        private TableDataRetriever() {
        }

        @Override
        public List<Object[]> retrieve(int start, int limit) {
            try {
                List<Object[]> result = ResultController.getInstance().getFilteredVariantRecords(start, limit, null);
                return result;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error retrieving data.", (Throwable)ex);
                TablePanel.this.setActivePanel(true);
                return null;
            }
        }

        @Override
        public int getTotalNum() {
            TablePanel.this.showWaitCard();
            int result = 0;
            try {
                result = ResultController.getInstance().getFilteredVariantCount();
            }
            catch (Exception ex) {
                LOG.error((Object)"Error getting total number.", (Throwable)ex);
            }
            return result;
        }

        @Override
        public void retrievalComplete() {
            TablePanel.this.showShowCard();
            TablePanel.this.updateRequired = false;
        }
    }

    private class TableInitializer
    extends MedSavantWorker<AnnotationFormat[]> {
        private TableInitializer() {
            super(TablePanel.this.pageName);
        }

        @Override
        protected AnnotationFormat[] doInBackground() throws SQLException, RemoteException {
            return ProjectController.getInstance().getCurrentAnnotationFormats();
        }

        @Override
        protected void showProgress(double fraction) {
        }

        @Override
        protected void showSuccess(AnnotationFormat[] result) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            ArrayList<Class<String>> fieldClasses = new ArrayList<Class<String>>();
            ArrayList<Integer> hiddenColumns = new ArrayList<Integer>();
            for (AnnotationFormat af : result) {
                for (CustomField field : af.getCustomFields()) {
                    fieldNames.add(field.getAlias());
                    switch (field.getColumnType()) {
                        case INTEGER: 
                        case BOOLEAN: {
                            fieldClasses.add(Integer.class);
                            break;
                        }
                        case FLOAT: 
                        case DECIMAL: {
                            fieldClasses.add(Double.class);
                            break;
                        }
                        default: {
                            fieldClasses.add(String.class);
                        }
                    }
                    if (af.getProgram().equals("VCF") && field.getColumnName().equals(BasicVariantColumns.CHROM.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.START_POSITION.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.END_POSITION.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.DNA_ID.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.ZYGOSITY.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.REF.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.ALT.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.QUAL.getColumnName()) || field.getColumnName().equals(BasicVariantColumns.DBSNP_ID.getColumnName()) | field.getColumnName().equals(BasicVariantColumns.VARIANT_TYPE.getColumnName())) continue;
                    hiddenColumns.add(fieldNames.size() - 1);
                }
            }
            TablePanel.this.searchableTablePanel = new SearchableTablePanel(TablePanel.this.pageName, fieldNames.toArray(new String[0]), fieldClasses.toArray(new Class[0]), MiscUtils.toIntArray(hiddenColumns), 1000, new TableDataRetriever()){

                @Override
                public String getToolTip(int actualRow) {
                    if (TablePanel.this.starMap.get(actualRow) != null && !((List)TablePanel.this.starMap.get(actualRow)).isEmpty()) {
                        String s = "<HTML>";
                        List starred = (List)TablePanel.this.starMap.get(actualRow);
                        for (int i = 0; i < starred.size(); ++i) {
                            VariantComment current = (VariantComment)starred.get(i);
                            s = s + "\"" + ClientMiscUtils.addBreaksToString(current.getDescription(), 100) + "\"<BR>";
                            s = s + "- " + current.getUser() + ", " + current.getTimestamp().toString();
                            if (i == starred.size() - 1) continue;
                            s = s + "<BR>----------<BR>";
                        }
                        s = s + "</HTML>";
                        return s;
                    }
                    return null;
                }

                @Override
                public void paintComponent(Graphics g) {
                    if (TablePanel.this.waitPanel.isVisible()) {
                        TablePanel.this.waitPanel.repaint();
                    } else {
                        super.paintComponent(g);
                    }
                }
            };
            TablePanel.this.searchableTablePanel.scrollSafeSelectAction(new Runnable(){

                @Override
                public void run() {
                    TablePanel.this.selectItem();
                }
            });
            TablePanel.this.searchableTablePanel.setExportButtonVisible(false);
            TablePanel.this.searchableTablePanel.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!SwingUtilities.isRightMouseButton(e)) {
                        return;
                    }
                    SortableTable table = TablePanel.this.searchableTablePanel.getTable();
                    int numSelected = table.getSelectedRows().length;
                    if (numSelected == 1) {
                        int r = table.rowAtPoint(e.getPoint());
                        if (r < 0 || r >= table.getRowCount()) {
                            return;
                        }
                        JPopupMenu popup = TablePanel.this.createPopupSingle();
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    } else if (numSelected > 1) {
                        JPopupMenu popup = TablePanel.this.createPopupMultiple();
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            TablePanel.this.tableContainer.removeAll();
            TablePanel.this.tableContainer.add((Component)TablePanel.this.searchableTablePanel, "Center");
            TablePanel.this.updateRequired = true;
            TablePanel.this.updateTableIfRequired();
        }
    }
}

