/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.layout.GroupLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.ExtensionsFileFilter;

public class SavantExportForm
extends JDialog {
    private static final Log LOG = LogFactory.getLog(SavantExportForm.class);
    private JPanel checkBoxPane;
    private List<String> dnaIDs;
    private File outputFile;
    private List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private JDialog progressDialog;
    private JButton chooseFileButton;
    private JButton exportButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextField outputFileField;
    private JLabel progressLabel;
    private JScrollPane scrollPane;

    public SavantExportForm() throws InterruptedException, SQLException, RemoteException {
        List<String> temp;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        JPanel container = new JPanel(new BorderLayout());
        this.scrollPane.getViewport().add(container);
        this.checkBoxPane = new JPanel();
        this.checkBoxPane.setLayout(new BoxLayout(this.checkBoxPane, 1));
        container.add((Component)this.checkBoxPane, "Center");
        this.exportButton.setEnabled(false);
        try {
            temp = MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), ProjectController.getInstance().getCurrentPatientTableName(), BasicPatientColumns.DNA_IDS.getColumnName(), false, false);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.dnaIDs = new ArrayList<String>();
        for (String s : temp) {
            for (String s1 : s.split(",")) {
                if (s1 == null || s1.equals("") || this.dnaIDs.contains(s1)) continue;
                this.dnaIDs.add(s1);
            }
        }
        for (String id : this.dnaIDs) {
            this.addID(id);
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void addID(String id) {
        JCheckBox box = new JCheckBox(id);
        this.checkBoxPane.add(box);
        this.checkBoxes.add(box);
    }

    private void export() throws InterruptedException, IOException, SQLException, RemoteException {
        try {
            Object[] keys;
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (JCheckBox box : this.checkBoxes) {
                if (!box.isSelected()) continue;
                selectedIds.add(box.getText());
            }
            if (selectedIds.isEmpty()) {
                this.progressLabel.setText("No individuals selected");
                this.progressDialog.setVisible(false);
                this.setVisible(true);
                return;
            }
            Map<String, List<String>> map = MedSavantClient.VariantManager.getSavantBookmarkPositionsForDNAIDs(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions(), selectedIds, -1);
            Collection<String> bamFiles = MedSavantClient.PatientManager.getValuesFromDNAIDs(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), BasicPatientColumns.BAM_URL.getColumnName(), selectedIds).values();
            String genomeName = ReferenceController.getInstance().getCurrentReferenceName();
            String genomeUrl = ReferenceController.getInstance().getCurrentReferenceUrl();
            BufferedWriter out = new BufferedWriter(new FileWriter(this.outputFile));
            out.write("<?xml version=\"1.0\" ?>\n<savant version=\"1\" range=\"chr1:1-1000\">\n");
            if (genomeUrl != null) {
                out.write(" <genome name=\"" + genomeName + "\" uri=\"" + genomeUrl + "\" />\n");
            } else {
                out.write(" <genome name=\"" + genomeName + "\" >\n");
                for (Chromosome c : ReferenceController.getInstance().getChromosomes()) {
                    out.write("   <reference name=\"" + c.getName() + "\" length=\"" + c.getLength() + "\" />\n");
                }
                out.write(" </genome>\n");
            }
            for (String path : bamFiles) {
                out.write("  <track uri=\"" + path + "\"/>\n");
            }
            for (Object keyObject : keys = map.keySet().toArray()) {
                String key = (String)keyObject;
                List<String> positions = map.get(key);
                for (String p : positions) {
                    out.write("  <bookmark range=\"" + p + "\">" + key + "</bookmark>\n");
                }
            }
            out.write("</savant>\n");
            out.close();
            this.progressDialog.setVisible(false);
            this.setVisible(false);
            this.progressDialog.dispose();
            this.dispose();
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.exportButton = new JButton();
        this.chooseFileButton = new JButton();
        this.outputFileField = new JTextField();
        this.scrollPane = new JScrollPane();
        this.jLabel1 = new JLabel();
        this.progressLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Show in Savant");
        this.jLabel3.setText("Output Project File: ");
        this.exportButton.setText("Export");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavantExportForm.this.exportButtonActionPerformed(evt);
            }
        });
        this.chooseFileButton.setText("...");
        this.chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavantExportForm.this.chooseFileButtonActionPerformed(evt);
            }
        });
        this.outputFileField.setEditable(false);
        this.outputFileField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SavantExportForm.this.outputFileFieldActionPerformed(evt);
            }
        });
        this.scrollPane.setMaximumSize(new Dimension(380, 254));
        this.scrollPane.setMinimumSize(new Dimension(380, 254));
        this.scrollPane.setPreferredSize(new Dimension(380, 254));
        this.jLabel1.setText("Choose Individuals to Export:");
        this.progressLabel.setHorizontalAlignment(4);
        this.progressLabel.setText(" ");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.scrollPane, -1, 383, Short.MAX_VALUE).add((Component)this.jLabel3).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.outputFileField, -1, 322, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chooseFileButton, -2, 55, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.progressLabel, -1, 256, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.exportButton, -2, 117, -2)).add((Component)this.jLabel1, -2, 231, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.scrollPane, -1, 260, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel3).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.outputFileField, -2, -1, -2).add((Component)this.chooseFileButton)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.progressLabel).add((Component)this.exportButton)).addContainerGap()));
        this.pack();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        this.progressDialog = new JDialog();
        this.progressDialog.setTitle("Show in Savant");
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(300, 100));
        p.setLayout(new BorderLayout());
        p.add(new WaitPanel("Exporting Savant Project"));
        this.progressDialog.getContentPane().add(p);
        this.progressDialog.pack();
        this.progressDialog.setLocationRelativeTo(null);
        this.setVisible(false);
        this.progressDialog.setVisible(true);
        new MedSavantWorker<Void>("SavantExportForm"){

            @Override
            protected void showProgress(double fraction) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected void showSuccess(Void result) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            protected Void doInBackground() throws Exception {
                SavantExportForm.this.export();
                return null;
            }
        }.execute();
    }

    private void chooseFileButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save Savant Project");
        fc.setDialogType(1);
        fc.addChoosableFileFilter(new ExtensionsFileFilter(new String[]{"svp"}));
        fc.setMultiSelectionEnabled(false);
        int result = fc.showDialog(null, null);
        if (result == 1 || result == -1) {
            return;
        }
        this.outputFile = fc.getSelectedFile();
        String path = this.outputFile.getAbsolutePath();
        this.outputFileField.setText(path);
        this.exportButton.setEnabled(true);
    }

    private void outputFileFieldActionPerformed(ActionEvent evt) {
    }
}

