/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.SearchableTablePanel;
import org.ut.biolab.medsavant.client.view.dialog.IndividualSelector;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class FamilySelector
extends JDialog
implements BasicPatientColumns {
    int INDEX_OF_KEY = 0;
    Set<String> selectedFamilies;
    private static final Log LOG = LogFactory.getLog(IndividualSelector.class);
    private JPanel middlePanel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private static final String[] COLUMN_NAMES = new String[]{"Family ID"};
    private static final Class[] COLUMN_CLASSES = new Class[]{String.class};
    private static final int[] HIDDEN_COLUMNS = new int[0];
    private SearchableTablePanel stp;
    private JLabel numselections;
    private FamilyReceiver retriever;
    private HashSet<Integer> selectedRows;
    private JButton ok;
    private boolean hasMadeSelections;

    public FamilySelector() {
        super((Frame)MedSavantFrame.getInstance(), true);
        this.setTitle("Select Families");
        this.setPreferredSize(new Dimension(700, 600));
        this.setMinimumSize(new Dimension(700, 600));
        this.selectedFamilies = new HashSet<String>();
        this.selectedRows = new HashSet();
        this.initUI();
        this.refresh();
    }

    private void refresh() {
        this.stp.forceRefreshData();
    }

    private void initUI() {
        JPanel p = new JPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        this.add(p);
        this.topPanel = ViewUtil.getClearPanel();
        this.middlePanel = ViewUtil.getClearPanel();
        this.bottomPanel = ViewUtil.getClearPanel();
        p.add(this.topPanel);
        p.add(this.middlePanel);
        p.add(this.bottomPanel);
        this.middlePanel.setLayout(new BorderLayout());
        this.retriever = new FamilyReceiver();
        this.stp = new SearchableTablePanel("Individuals", COLUMN_NAMES, COLUMN_CLASSES, HIDDEN_COLUMNS, true, true, Integer.MAX_VALUE, false, SearchableTablePanel.TableSelectionType.ROW, Integer.MAX_VALUE, this.retriever);
        this.stp.setExportButtonVisible(false);
        this.middlePanel.add((Component)this.stp, "Center");
        ViewUtil.applyVerticalBoxLayout(this.bottomPanel);
        this.numselections = ViewUtil.getTitleLabel("0 families selected");
        JPanel text = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(text);
        JButton clearIndividuals = ViewUtil.getIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLOSE));
        clearIndividuals.setToolTipText("Clear selections");
        clearIndividuals.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FamilySelector.this.clearSelections();
            }
        });
        text.add(this.numselections);
        text.add(Box.createHorizontalStrut(5));
        text.add(clearIndividuals);
        this.bottomPanel.add(ViewUtil.centerHorizontally(text));
        JButton addAllIndividuals = ViewUtil.getSoftButton("Add All");
        this.bottomPanel.add(addAllIndividuals);
        final JButton addIndividuals = ViewUtil.getSoftButton("Add Selected");
        this.bottomPanel.add(addIndividuals);
        final JButton removeIndividuals = ViewUtil.getSoftButton("Remove Selected");
        this.bottomPanel.add(removeIndividuals);
        JButton removeAllIndividuals = ViewUtil.getSoftButton("Remove All");
        this.bottomPanel.add(removeAllIndividuals);
        JPanel buttons = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(buttons);
        buttons.add(addAllIndividuals);
        buttons.add(addIndividuals);
        buttons.add(removeIndividuals);
        buttons.add(removeAllIndividuals);
        JPanel windowControlPanel = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(windowControlPanel);
        windowControlPanel.add(Box.createHorizontalGlue());
        JButton cancel = new JButton("Cancel");
        this.bottomPanel.add(ViewUtil.centerHorizontally(buttons));
        this.ok = new JButton("OK");
        this.bottomPanel.add(ViewUtil.alignRight(this.ok));
        this.ok.setEnabled(false);
        windowControlPanel.add(cancel);
        windowControlPanel.add(this.ok);
        this.bottomPanel.add(windowControlPanel);
        final FamilySelector instance = this;
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                instance.setVisible(false);
                FamilySelector.this.setIndividualsChosen(true);
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                instance.setVisible(false);
                FamilySelector.this.setIndividualsChosen(FamilySelector.this.hasMadeSelections);
            }
        });
        addIndividuals.setEnabled(false);
        removeIndividuals.setEnabled(false);
        this.stp.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (!lse.getValueIsAdjusting()) {
                    int[] rows = FamilySelector.this.stp.getTable().getSelectedRows();
                    boolean someSelection = rows.length > 0;
                    addIndividuals.setEnabled(someSelection);
                    removeIndividuals.setEnabled(someSelection);
                    if (someSelection) {
                        addIndividuals.setText("Add Selected (" + rows.length + ")");
                        removeIndividuals.setText("Remove Selected (" + rows.length + ")");
                    } else {
                        addIndividuals.setText("Add Selected");
                        removeIndividuals.setText("Remove Selected");
                    }
                }
            }
        });
        this.stp.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tme) {
            }
        });
        ActionListener addAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FamilySelector.this.addSelections(false);
            }
        };
        ActionListener addAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FamilySelector.this.addSelections(true);
            }
        };
        ActionListener removeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FamilySelector.this.removeSelections(false);
            }
        };
        ActionListener removeAllAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FamilySelector.this.removeSelections(true);
            }
        };
        addIndividuals.addActionListener(addAction);
        addAllIndividuals.addActionListener(addAllAction);
        removeIndividuals.addActionListener(removeAction);
        removeAllIndividuals.addActionListener(removeAllAction);
        this.pack();
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
    }

    private void setIndividualsChosen(boolean b) {
        this.hasMadeSelections = b;
    }

    private void refreshSelectionIndicator() {
        String tooltipText = "<html>";
        for (String o : this.selectedFamilies) {
            tooltipText = tooltipText + o + "<br>";
        }
        tooltipText = tooltipText + "</html>";
        this.numselections.setToolTipText(tooltipText);
        this.stp.setToggledRows(this.selectedRows);
        this.numselections.setText(this.selectedFamilies.size() + " " + MiscUtils.pluralize(this.selectedFamilies.size(), "family", "families") + " selected");
        this.ok.setEnabled(this.selectedFamilies.size() > 0);
    }

    private void clearSelections() {
        this.selectedFamilies.removeAll(this.selectedFamilies);
        this.selectedRows.removeAll(this.selectedRows);
        this.stp.setToggledRows(null);
        this.refreshSelectionIndicator();
    }

    private void removeSelections(boolean all) {
        int[] rows;
        ArrayList<Object[]> toUnselect = new ArrayList<Object[]>();
        if (all) {
            int rowCount = this.stp.getTable().getModel().getRowCount();
            rows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
        } else {
            rows = this.stp.getTable().getSelectedRows();
        }
        for (int r : rows) {
            int realRow = this.stp.getActualRowAt(r);
            Object[] o = this.retriever.getFamilies().get(realRow);
            toUnselect.add(o);
        }
        for (int i : rows) {
            this.selectedRows.remove(this.stp.getActualRowAt(i));
        }
        for (Object[] s : toUnselect) {
            this.selectedFamilies.remove(s[this.INDEX_OF_KEY].toString());
        }
        this.refreshSelectionIndicator();
    }

    private void addSelections(boolean all) {
        int[] rows;
        ArrayList<Object[]> selected = new ArrayList<Object[]>();
        if (all) {
            int rowCount = this.stp.getTable().getModel().getRowCount();
            rows = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                rows[i] = i;
            }
        } else {
            rows = this.stp.getTable().getSelectedRows();
        }
        for (int r : rows) {
            int realRow = this.stp.getActualRowAt(r);
            Object[] o = this.retriever.getFamilies().get(realRow);
            selected.add(o);
        }
        for (int i : rows) {
            this.selectedRows.add(this.stp.getActualRowAt(i));
        }
        for (Object[] s : selected) {
            this.selectedFamilies.add(s[this.INDEX_OF_KEY].toString());
        }
        this.refreshSelectionIndicator();
    }

    public Set<String> getSelectedFamilies() {
        return this.selectedFamilies;
    }

    public void setSelectedFamilies(Set<String> s) {
        this.selectedRows.removeAll(this.selectedRows);
        this.selectedFamilies = s;
        this.hasMadeSelections = true;
        for (String arbitraryHostpitalID : s) {
            int rowNumber = 0;
            List<Object[]> individuals = this.retriever.getFamilies();
            for (Object[] inOrderRow : individuals) {
                if (inOrderRow[this.INDEX_OF_KEY].equals(arbitraryHostpitalID)) {
                    this.selectedRows.add(rowNumber);
                }
                ++rowNumber;
            }
        }
        this.refreshSelectionIndicator();
    }

    public boolean hasMadeSelection() {
        return this.hasMadeSelections;
    }

    public void resetSelections() {
        this.setSelectedFamilies(new HashSet<String>());
        this.hasMadeSelections = false;
    }

    public static class FamilyReceiver
    extends DataRetriever<Object[]> {
        private List<Object[]> families;

        public List<Object[]> getFamilies() {
            return this.families;
        }

        @Override
        public List<Object[]> retrieve(int start, int limit) throws Exception {
            if (this.families == null) {
                this.setFamilies();
            }
            return this.families;
        }

        @Override
        public int getTotalNum() {
            if (this.families == null) {
                try {
                    this.setFamilies();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
            return this.families.size();
        }

        @Override
        public void retrievalComplete() {
        }

        private void setFamilies() throws SQLException, RemoteException {
            try {
                List<String> fams = MedSavantClient.PatientManager.getFamilyIDs(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
                this.families = new ArrayList<Object[]>(fams.size());
                for (String fam : fams) {
                    this.families.add(new Object[]{fam});
                }
            }
            catch (SessionExpiredException e) {
                MedSavantExceptionHandler.handleSessionExpiredException(e);
            }
        }
    }
}

