/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.dashboard;

import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.TriAreaComponent;
import com.explodingpixels.painter.MacWidgetsPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mfiume.component.transition.JTransitionPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.StackableJPanelContainer;
import org.ut.biolab.medsavant.client.view.dashboard.DashboardSection;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchHistory;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.images.ImagePanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.util.WebResources;
import org.ut.biolab.savant.analytics.savantanalytics.AnalyticsAgent;

public class Dashboard
extends StackableJPanelContainer
implements Listener<DashboardSection> {
    private static Log LOG = LogFactory.getLog(Dashboard.class);
    int appIconWidth = 128;
    private final ArrayList<DashboardSection> dashboardSections;
    private final JTransitionPanel transitionCanvas;
    private final JPanel dashLayer;
    private LaunchableApp previousApp;
    private final JPanel appLayer;
    private final HashSet<LaunchableApp> appHistoryBlackList;
    private Image backgroundImage;
    private boolean transparentBackground = true;
    private TriAreaComponent homeToolbar;
    private TriAreaComponent appToolbar;
    private LaunchHistory history = new LaunchHistory();

    public Dashboard() {
        this.appHistoryBlackList = new HashSet();
        this.setDoubleBuffered(true);
        this.setBackground(ViewUtil.getDefaultBackgroundColor());
        this.dashboardSections = new ArrayList();
        this.appLayer = new JPanel();
        this.appLayer.setBackground(this.getBackground());
        this.appLayer.setLayout(new BorderLayout());
        this.dashLayer = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (Dashboard.this.backgroundImage != null) {
                    int width = this.getWidth();
                    int height = this.getHeight();
                    int imageW = Dashboard.this.backgroundImage.getWidth(this);
                    int imageH = Dashboard.this.backgroundImage.getHeight(this);
                    for (int x = 0; x < width; x += imageW) {
                        for (int y = 0; y < height; y += imageH) {
                            g.drawImage(Dashboard.this.backgroundImage, x, y, this);
                        }
                    }
                    return;
                }
            }
        };
        this.dashLayer.setBackground(this.getBackground());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dashboard.this.relayout();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.transitionCanvas = new JTransitionPanel();
        this.transitionCanvas.push(this.dashLayer, JTransitionPanel.TransitionType.NONE, null);
        this.push((JPanel)this.transitionCanvas);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.dashLayer != null) {
            this.dashLayer.setBackground(c);
            this.dashLayer.repaint();
        }
    }

    public void setBackgroundImage(Image im) {
        this.backgroundImage = im;
        this.dashLayer.repaint();
    }

    public void addDashboardSection(DashboardSection s) {
        this.dashboardSections.add(s);
    }

    private void relayout() {
        int gapHorizontal;
        this.dashLayer.removeAll();
        JPanel middlePane = ViewUtil.getClearPanel();
        int gapVertical = gapHorizontal = 30;
        int topInset = 100;
        int bottomInsets = 20;
        int widthOfContainer = this.getParent().getSize().width;
        int centralWidth = Math.min((int)Math.round((double)widthOfContainer * 0.75), 1200);
        int numIconsPerRow = (centralWidth + gapHorizontal) / (this.appIconWidth + gapHorizontal);
        int leftInset = widthOfContainer / 2 - numIconsPerRow * (this.appIconWidth + gapHorizontal) / 2;
        int rightInset = 0;
        middlePane.setLayout((LayoutManager)new MigLayout(String.format("gapy %d, insets %d %d %d %d", 0, topInset, leftInset, bottomInsets, rightInset)));
        this.dashLayer.setOpaque(true);
        this.dashLayer.setLayout(new BorderLayout());
        for (DashboardSection s : this.dashboardSections) {
            if (!s.isEnabled() || s.getApps().isEmpty()) continue;
            if (!s.getName().equals("Apps")) {
                JLabel l = ViewUtil.getSubtleHeaderLabel(s.getName().toUpperCase());
                middlePane.add((Component)l, "wrap, center");
            }
            JPanel appPlaceholder = ViewUtil.getClearPanel();
            MigLayout layout = new MigLayout(String.format("gapx %d, gapy %d, wrap %d, insets 0", gapHorizontal, gapVertical, numIconsPerRow));
            appPlaceholder.setLayout((LayoutManager)layout);
            for (LaunchableApp launcher : s.getApps()) {
                try {
                    appPlaceholder.add(Dashboard.getRepresentationForLauncher(this, launcher, this.appIconWidth));
                }
                catch (Exception e) {
                    LOG.error((Object)("Error creating launcher for app " + launcher.toString()), (Throwable)e);
                    e.printStackTrace();
                }
            }
            middlePane.add((Component)appPlaceholder, String.format("wrap, gapy 5 %d", gapVertical));
        }
        JScrollPane p = ViewUtil.getClearBorderlessScrollPane(middlePane);
        p.setHorizontalScrollBarPolicy(31);
        JPanel bottomDisclaimer = ViewUtil.getClearPanel();
        bottomDisclaimer.setLayout((LayoutManager)new MigLayout("fillx, insets 2"));
        TriAreaComponent bottombar = new TriAreaComponent(10);
        bottombar.getComponent().setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ImagePanel logo = new ImagePanel("icon/logo/medsavant-icon-mini.png");
        bottombar.addComponentToLeft((JComponent)logo);
        JButton feedback = ViewUtil.createHyperlinkButton("Send Feedback", ViewUtil.getMedSavantBlueColor(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    Desktop.getDesktop().mail(WebResources.FEEDBACK_URL.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        bottombar.addComponentToRight((JComponent)feedback);
        JButton userguide = ViewUtil.createHyperlinkButton("User Guide", ViewUtil.getMedSavantBlueColor(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    Desktop.getDesktop().browse(WebResources.USERGUIDE_URL.toURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        bottombar.addComponentToRight((JComponent)userguide);
        bottomDisclaimer.add((Component)bottombar.getComponent(), "width 100%");
        this.homeToolbar = this.getToolBar();
        this.homeToolbar.addComponentToRight((JComponent)Box.createHorizontalStrut(5));
        this.dashLayer.add((Component)this.homeToolbar.getComponent(), "North");
        this.dashLayer.add((Component)p, "Center");
        this.dashLayer.add((Component)bottomDisclaimer, "South");
        this.dashLayer.updateUI();
    }

    public BufferedImage createBlurredImage(JPanel panel) {
        System.out.println("Blurring image");
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage sourceImage = new BufferedImage(w, h, 1);
        Graphics2D g = sourceImage.createGraphics();
        panel.paint(g);
        return this.createBlurredImage(sourceImage);
    }

    public BufferedImage createBlurredImage(BufferedImage sourceImage) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage(sourceImage.getWidth(null), sourceImage.getHeight(null), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage((Image)sourceImage, 0, 0, null);
        graphics.dispose();
        float[] matrix = new float[]{0.0625f, 0.125f, 0.0625f, 0.125f, 0.25f, 0.125f, 0.0625f, 0.125f, 0.0625f};
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, matrix));
        return op.filter(image, null);
    }

    public void goHome() {
        if (this.previousApp != null) {
            this.previousApp.viewWillUnload();
        }
        if (this.previousApp != null) {
            this.previousApp.viewDidUnload();
        }
        this.previousApp = null;
        this.transitionCanvas.push(this.dashLayer, JTransitionPanel.TransitionType.NONE, null);
        this.updateUI();
    }

    public void launchApp(String appName) {
        for (DashboardSection ds : this.dashboardSections) {
            for (LaunchableApp app : ds.getApps()) {
                if (!appName.equals(app.getName())) continue;
                this.launchApp(app);
                return;
            }
        }
    }

    public void launchApp(LaunchableApp app) {
        this.history.add(app);
        if (this.previousApp != null) {
            this.previousApp.viewWillUnload();
        }
        app.viewWillLoad();
        this.appLayer.removeAll();
        JPanel p = app.getView();
        this.appToolbar = this.getToolBar();
        this.appToolbar.addComponentToLeft((JComponent)Box.createHorizontalStrut(5));
        this.appToolbar.addComponentToLeft(this.getHomeButton());
        this.appToolbar.addComponentToRight((JComponent)Box.createHorizontalStrut(5));
        this.addTitleToBar(this.appToolbar, app.getName());
        this.appLayer.add((Component)this.appToolbar.getComponent(), "North");
        this.appLayer.add((Component)p, "Center");
        if (this.previousApp != null) {
            this.previousApp.viewDidUnload();
        }
        app.viewDidLoad();
        AnalyticsAgent.log((NameValuePair)new NameValuePair("app-launched", app.getName()));
        this.previousApp = app;
        this.appLayer.updateUI();
        this.transitionCanvas.push(this.appLayer, JTransitionPanel.TransitionType.NONE, null);
    }

    public static JPanel getRepresentationForLauncher(String name, ImageIcon icon, int iconWidth, ActionListener actionListener) {
        return Dashboard.getRepresentationForLauncher(name, icon, iconWidth, actionListener, false);
    }

    public static JPanel getRepresentationForLauncher(String name, ImageIcon icon, int iconWidth, ActionListener actionListener, boolean disableButton) {
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        JButton button = ViewUtil.getIconButton(new ImageIcon(ViewUtil.getScaledInstance(icon.getImage(), iconWidth, iconWidth, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true)));
        button.addActionListener(actionListener);
        p.add(ViewUtil.centerHorizontally(button));
        p.add(Box.createVerticalStrut(3));
        if (iconWidth <= 64) {
            JLabel title = ViewUtil.getGrayLabel(name);
            title.setFont(new Font(ViewUtil.getDefaultFontFamily(), disableButton ? 1 : 0, 12));
            ViewUtil.ellipsizeLabel(title, iconWidth);
            p.add(ViewUtil.centerHorizontally(title));
        } else {
            JLabel title = ViewUtil.getGrayLabel(name);
            ViewUtil.ellipsizeLabel(title, iconWidth);
            title.setFont(new Font(ViewUtil.getDefaultFontFamily(), disableButton ? 1 : 0, 15));
            p.add(ViewUtil.centerHorizontally(title));
        }
        return p;
    }

    public static JPanel getRepresentationForLauncher(final Dashboard d, final LaunchableApp launcher, int iconWidth) {
        return Dashboard.getRepresentationForLauncher(launcher.getName(), launcher.getIcon(), iconWidth, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                d.launchApp(launcher);
            }
        });
    }

    public List<LaunchableApp> getLaunchHistory() {
        return this.history.getRecentHistory();
    }

    public LaunchableApp getCurrentApp() {
        return this.previousApp;
    }

    @Override
    public void handleEvent(DashboardSection event) {
        this.relayout();
    }

    private JComponent getHomeButton() {
        final ActionListener goHomeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Dashboard.this.goHome();
            }
        };
        JButton goHome = new JButton(IconFactory.getInstance().getIcon("/org/ut/biolab/medsavant/client/view/images/icon/home-20.png"));
        goHome.setFocusable(false);
        goHome.putClientProperty("JButton.buttonType", "textured");
        goHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                goHomeActionListener.actionPerformed(null);
            }
        });
        return goHome;
    }

    private JComponent getLogoutButton() {
        final ActionListener signOutActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MedSavantFrame.getInstance().requestLogoutAndRestart();
            }
        };
        JButton signOut = new JButton(IconFactory.getInstance().getIcon("/org/ut/biolab/medsavant/client/view/images/icon/exit-20.png"));
        signOut.setFocusable(false);
        signOut.putClientProperty("JButton.buttonType", "textured");
        signOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                signOutActionListener.actionPerformed(null);
            }
        });
        return signOut;
    }

    private TriAreaComponent getToolBar() {
        TriAreaComponent bar = new TriAreaComponent(5);
        bar.setBackgroundPainter((MacWidgetsPainter)new MacWidgetsPainter<Component>(){

            public void paint(Graphics2D gd, Component t, int i, int i1) {
                gd.setColor(ViewUtil.getPrimaryMenuColor());
                gd.fillRect(0, 0, t.getWidth(), t.getHeight());
            }
        });
        bar.getComponent().setBorder(ViewUtil.getBottomLineBorder());
        return bar;
    }

    private void addTitleToBar(TriAreaComponent bar, String name) {
        JLabel title = MacWidgetFactory.makeEmphasizedLabel((JLabel)new JLabel(name), (Color)new Color(64, 64, 64), (Color)new Color(64, 64, 64), (Color)new Color(230, 230, 230));
        title.setFont(title.getFont().deriveFont(1, 14.0f));
        bar.addComponentToLeft((JComponent)title);
    }

    private class LimitedQueue<E>
    extends LinkedList<E> {
        private int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            super.add(o);
            while (this.size() > this.limit) {
                super.remove();
            }
            return true;
        }
    }
}

