/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class TiledJPanel
extends JPanel {
    BufferedImage tileImage;

    public TiledJPanel(Image image) {
        this.tileImage = ViewUtil.getBufferedImage(image);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int imageW = this.tileImage.getWidth(this);
        int imageH = this.tileImage.getHeight(this);
        for (int x = 0; x < width; x += imageW) {
            for (int y = 0; y < height; y += imageH) {
                g.drawImage(this.tileImage, x, y, this);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(240, 240);
    }

    public static void main(String[] args) throws IOException {
        BufferedImage image = ImageIO.read(new File("/img/bg/bg1.jpg"));
        TiledJPanel test = new TiledJPanel(image);
        JOptionPane.showMessageDialog(null, test, "", -1);
    }
}

