/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import com.jidesoft.list.FilterableCheckBoxList;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.text.Position;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SelectableListView<T>
extends JPanel {
    private static final Log LOG = LogFactory.getLog(SelectableListView.class);
    private static final int FIELD_WIDTH = 260;
    private List<Listener<SelectionEvent>> listeners = new ArrayList<Listener<SelectionEvent>>();
    private List<T> availableValues;
    protected List<T> appliedValues;
    private QuickListFilterField field;
    protected FilterableCheckBoxList filterableList;
    private JButton selectAll;

    protected SelectableListView() {
    }

    public void setAvailableValues(List<T> v) {
        this.availableValues = v;
        this.setAppliedValues(v);
    }

    public void setAppliedValues(List<T> v) {
        this.appliedValues = v;
        this.fireSelectionsChangedEvent();
    }

    protected final void initContentPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.availableValues == null) {
            JTextArea label = new JTextArea("There are too many values to display.");
            label.setOpaque(false);
            label.setLineWrap(true);
            label.setWrapStyleWord(true);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(3, 3, 3, 3);
            this.add((Component)label, gbc);
            return;
        }
        SimpleListModel model = new SimpleListModel();
        this.field = new QuickListFilterField((ListModel)model);
        this.field.setHintText("Type here to filter options");
        this.field.setPreferredSize(new Dimension(260, 22));
        this.filterableList = new FilterableCheckBoxList((ListModel)this.field.getDisplayListModel()){

            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                return -1;
            }

            public boolean isCheckBoxEnabled(int index) {
                return true;
            }
        };
        this.filterableList.getCheckBoxListSelectionModel().setSelectionMode(2);
        if (model.getSize() > 0) {
            this.filterableList.setPrototypeCellValue(model.getElementAt(0));
        }
        SearchableUtils.installSearchable((JList)this.filterableList);
        this.setAllSelected(true);
        JScrollPane jsp = new JScrollPane((Component)this.filterableList){

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result = new Dimension(Math.min(result.width, SelectableListView.this.getWidth() - 20), result.height);
                return result;
            }
        };
        this.selectAll = ViewUtil.createHyperLinkButton("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectableListView.this.setAllSelected(true);
            }
        });
        JButton selectNone = ViewUtil.createHyperLinkButton("Select None");
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectableListView.this.setAllSelected(false);
            }
        });
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 15, 3, 15);
        this.add((Component)this.field, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jsp, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JPanel bottom = new JPanel();
        ViewUtil.applyHorizontalBoxLayout(bottom);
        bottom.add(this.selectAll);
        bottom.add(selectNone);
        bottom.add(Box.createHorizontalGlue());
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SelectableListView.this.saveSelections();
            }
        });
        bottom.add(applyButton);
        this.add((Component)bottom, gbc);
    }

    private void saveSelections() {
        int[] selectedIndices = this.filterableList.getCheckBoxListSelectedIndices();
        ArrayList<T> selections = new ArrayList<T>();
        for (int i : selectedIndices) {
            selections.add(this.availableValues.get(i));
        }
        this.appliedValues = selections;
        this.fireSelectionsChangedEvent();
    }

    public List<T> getSelections() {
        return this.appliedValues;
    }

    public boolean areAllSelected() {
        return this.appliedValues.size() == this.availableValues.size();
    }

    public boolean areNoneSelected() {
        return this.appliedValues.isEmpty();
    }

    public final void setFilterValues(Collection<String> list) {
        int[] selectedIndices = new int[list.size()];
        int i = 0;
        for (String s : list) {
            int j = 0;
            for (T t : this.availableValues) {
                if (t.toString().equals(s)) break;
                ++j;
            }
            selectedIndices[i++] = j;
        }
        ClientMiscUtils.selectOnlyTheseIndicies(this.filterableList, selectedIndices);
    }

    protected void preapplyFilter() {
        int[] indices;
        this.appliedValues = new ArrayList<T>();
        for (int i : indices = this.filterableList.getCheckBoxListSelectedIndices()) {
            this.appliedValues.add(this.filterableList.getModel().getElementAt(i));
        }
    }

    private void setAllSelected(boolean b) {
        if (b) {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.addCheckBoxListSelectedIndex(i);
            }
        } else {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.removeCheckBoxListSelectedIndex(i);
            }
        }
    }

    protected void updateModel() {
        this.field.setListModel((ListModel)new SimpleListModel());
        this.filterableList.setModel((ListModel)this.field.getDisplayListModel());
        LOG.info((Object)("Model updated, " + this.field.getDisplayListModel().getSize() + " of " + this.field.getListModel().getSize() + "(" + this.availableValues.size() + ") rows visible."));
    }

    public void addListener(Listener<SelectionEvent> l) {
        this.listeners.add(l);
    }

    private void fireSelectionsChangedEvent() {
        SelectionEvent e = new SelectionEvent(SelectionEvent.Type.CHANGED, this.getSelections());
        for (Listener<SelectionEvent> l : this.listeners) {
            l.handleEvent(e);
        }
    }

    public class SimpleListModel
    extends AbstractListModel {
        @Override
        public int getSize() {
            return SelectableListView.this.availableValues.size();
        }

        @Override
        public Object getElementAt(int i) {
            return SelectableListView.this.availableValues.get(i);
        }
    }

    public static class SelectionEvent {
        private final Type type;
        private final List selections;

        public SelectionEvent(Type type, List selections) {
            this.type = type;
            this.selections = selections;
        }

        public Type getType() {
            return this.type;
        }

        public List getSelections() {
            return this.selections;
        }

        public static enum Type {
            CHANGED;

        }
    }
}

