/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.AutoResizePopupMenuCustomizer;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.DataRetriever;
import org.ut.biolab.medsavant.client.util.ExportTable;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.component.ColumnChooser;
import org.ut.biolab.medsavant.client.view.component.GenericTableModel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SearchableTablePanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(SearchableTablePanel.class);
    private static final int ROWSPERPAGE_1 = 100;
    private static final int ROWSPERPAGE_2 = 500;
    private static final int ROWSPERPAGE_3 = 1000;
    private static int KEY_PRESS_TIMER_INTERVAL = 200;
    private static final int KEY_PRESS_TIMER_INTERVAL_LONG = 1000;
    private static final int KEY_PRESS_TIMER_INTERVAL_AUTOADJUST_RUNS = 5;
    private static final int KEY_PRESS_INTERVAL_EPSILON = 5;
    private static final int KEY_PRESS_TIMER_INTERVAL_AUTOADJUST_PADDING = 20;
    private static final int[] SCROLLING_KEYS = new int[]{40, 38, 34, 33, 225, 224};
    private String pageName;
    private QuickTableFilterField filterField;
    private GenericTableModel model;
    private SortableTable table;
    private JPanel fieldPanel;
    private JLabel amountLabel;
    private int rowsPerPageX;
    private int pageNum = 1;
    private int numRowsPerPage = 500;
    private final JComboBox rowsPerPageDropdown;
    private JTextField rowsRetrievedBox;
    private int defaultRowsRetrieved = 1000;
    private static final int MAX_ROWS_RETRIEVED = 100000;
    private List<Object[]> data;
    private String[] columnNames;
    private Class[] columnClasses;
    private final JLabel pageLabel1;
    private final JLabel pageLabel2;
    private final JTextField pageText;
    private final JButton gotoFirst;
    private final JButton gotoPrevious;
    private final JButton gotoNext;
    private final JButton gotoLast;
    private ColumnChooser columnChooser;
    private int[] hiddenColumns;
    private DataRetriever<Object[]> retriever;
    private int totalNumRows;
    private GetDataWorker worker;
    private JButton exportButton;
    private JButton helpButton;
    private List<Integer> selectedRows;
    private Set<Integer> toggledRows;
    private static Color SELECTED_COLOUR = ViewUtil.getMedSavantBlueColor();
    private static Color DARK_COLOUR = ViewUtil.getAlternateRowColor();
    private final JPanel bottomPanel;
    private final JButton chooseColumnButton;
    private long lastTime;
    private boolean waitlong = false;
    private boolean keydown = false;
    private SelectionChangedWorker selectionChangedWorker;

    public SearchableTablePanel(String pageName, String[] columnNames, Class[] columnClasses, int[] hiddenColumns, int defaultRowsRetrieved, DataRetriever<Object[]> retriever) {
        this(pageName, columnNames, columnClasses, hiddenColumns, true, true, 500, true, TableSelectionType.ROW, defaultRowsRetrieved, retriever);
    }

    public SearchableTablePanel(String pageName, String[] columnNames, Class[] columnClasses, int[] hiddenColumns, boolean allowSearch, boolean allowSort, int defaultRows, boolean allowPages, TableSelectionType selectionType, int defaultRowsRetrieved, DataRetriever<Object[]> retriever) {
        this.pageName = pageName;
        this.rowsPerPageX = defaultRows;
        this.defaultRowsRetrieved = defaultRowsRetrieved;
        this.retriever = retriever;
        this.hiddenColumns = hiddenColumns;
        this.table = new SortableTable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                SearchableTablePanel searchableTablePanel = SearchableTablePanel.this;
                synchronized (searchableTablePanel) {
                    JComponent comp = (JComponent)super.prepareRenderer(renderer, row, col);
                    if (SearchableTablePanel.this.isRowToggled(TableModelWrapperUtils.getActualRowAt((TableModel)this.getSortableTableModel(), (int)row))) {
                        comp.setBackground(new Color(178, 225, 92));
                    } else if (this.isCellSelected(row, col)) {
                        comp.setBackground(SELECTED_COLOUR);
                    } else if (SearchableTablePanel.this.selectedRows == null || !SearchableTablePanel.this.selectedRows.contains(TableModelWrapperUtils.getActualRowAt((TableModel)this.getModel(), (int)row))) {
                        if (row % 2 == 0 && !this.isCellSelected(row, col)) {
                            comp.setBackground(Color.WHITE);
                        } else {
                            comp.setBackground(DARK_COLOUR);
                        }
                    }
                    comp.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
                    return comp;
                }
            }

            public String getToolTipText(MouseEvent e) {
                return SearchableTablePanel.this.getToolTip(TableModelWrapperUtils.getActualRowAt((TableModel)SearchableTablePanel.this.table.getModel(), (int)SearchableTablePanel.this.table.rowAtPoint(e.getPoint())));
            }
        };
        this.table.setToolTipText("");
        this.table.setClearSelectionOnTableDataChanges(true);
        this.table.setOptimized(true);
        this.table.setColumnAutoResizable(true);
        this.table.setAutoResort(false);
        this.table.setRowHeight(20);
        this.table.setSortable(allowSort);
        this.table.setSortingEnabled(allowSort);
        this.table.setFocusable(selectionType != TableSelectionType.DISABLED);
        this.table.setCellSelectionEnabled(selectionType == TableSelectionType.CELL);
        this.table.setRowSelectionAllowed(selectionType == TableSelectionType.ROW);
        this.table.setAutoResizeMode(2);
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)this.table);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AutoResizePopupMenuCustomizer());
        this.columnChooser = new ColumnChooser((JTable)this.table);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)this.columnChooser);
        AutoFilterTableHeader header = new AutoFilterTableHeader((JTable)this.table);
        header.setAutoFilterEnabled(true);
        header.setShowFilterIcon(true);
        header.setShowFilterName(true);
        this.table.setTableHeader((JTableHeader)header);
        this.filterField = new QuickTableFilterField((TableModel)((Object)this.model));
        if (allowPages) {
            this.filterField.setHintText("Search for anything on the page");
        } else {
            this.filterField.setHintText("Search for anything");
        }
        this.setLayout(new BorderLayout(3, 3));
        this.fieldPanel = ViewUtil.getClearPanel();
        if (allowSearch) {
            this.fieldPanel.add((Component)this.filterField);
        }
        this.chooseColumnButton = new JButton("Columns");
        this.chooseColumnButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SearchableTablePanel.this.columnChooser.showDialog();
            }
        });
        this.helpButton = ViewUtil.getHelpButton("About Variant List", "Variants are sorted first by DNA ID, then by position.  The list of variants within each page can be sorted by various fields by clicking the corresponding column name, but note that this will only sort the current page.");
        this.exportButton = new JButton("Export");
        this.exportButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                try {
                    ExportTable.exportTable((JTable)SearchableTablePanel.this.table);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while exporting.", (Throwable)ex);
                    DialogUtils.displayException("MedSavant", "<HTML>A problem occurred while exporting.<BR>Make sure the output file is not already in use.</HTML>", ex);
                }
            }
        });
        this.fieldPanel.add(this.helpButton);
        this.fieldPanel.add(this.chooseColumnButton);
        this.fieldPanel.add(this.exportButton);
        this.bottomPanel = ViewUtil.getClearPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.gotoFirst = this.niceButton();
        this.gotoPrevious = this.niceButton();
        this.gotoNext = this.niceButton();
        this.gotoLast = this.niceButton();
        this.gotoFirst.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FIRST));
        this.gotoPrevious.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.PREVIOUS));
        this.gotoNext.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.NEXT));
        this.gotoLast.setIcon(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LAST));
        this.gotoFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchableTablePanel.this.goToFirstPage();
            }
        });
        this.gotoPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchableTablePanel.this.goToPreviousPage();
            }
        });
        this.gotoNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchableTablePanel.this.goToNextPage();
            }
        });
        this.gotoLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchableTablePanel.this.goToLastPage();
            }
        });
        this.pageText = new JTextField();
        ViewUtil.makeSmall(this.pageText);
        this.pageText.setColumns(5);
        this.pageText.setMaximumSize(new Dimension(50, 20));
        this.pageText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    try {
                        SearchableTablePanel.this.setPageNumber(Integer.parseInt(SearchableTablePanel.this.pageText.getText()));
                    }
                    catch (NumberFormatException ex) {
                        SearchableTablePanel.this.setPageNumber(0);
                    }
                }
            }
        });
        this.amountLabel = new JLabel();
        ViewUtil.makeSmall(this.amountLabel);
        this.bottomPanel.add(this.amountLabel);
        this.pageLabel1 = new JLabel("Page ");
        ViewUtil.makeSmall(this.pageLabel1);
        this.pageLabel2 = new JLabel();
        ViewUtil.makeSmall(this.pageLabel2);
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.bottomPanel.add(this.gotoFirst);
        this.bottomPanel.add(this.gotoPrevious);
        this.strut(this.bottomPanel);
        this.bottomPanel.add(this.pageLabel1);
        this.bottomPanel.add(this.pageText);
        this.bottomPanel.add(this.pageLabel2);
        this.strut(this.bottomPanel);
        this.bottomPanel.add(this.gotoNext);
        this.bottomPanel.add(this.gotoLast);
        this.bottomPanel.add(Box.createHorizontalGlue());
        this.strut(this.bottomPanel);
        JLabel perpageL = new JLabel("Per page:");
        ViewUtil.makeSmall(perpageL);
        this.bottomPanel.add(perpageL);
        this.strut(this.bottomPanel);
        boolean hasDefaultRowsPerPage = true;
        if (this.rowsPerPageX == 100 || this.rowsPerPageX == 500 || this.rowsPerPageX == 1000) {
            hasDefaultRowsPerPage = false;
        }
        ArrayList<Integer> rowsList = new ArrayList<Integer>();
        rowsList.add(100);
        rowsList.add(500);
        rowsList.add(1000);
        Integer[] finalList = new Integer[3];
        if (hasDefaultRowsPerPage) {
            rowsList.add(this.rowsPerPageX);
            Collections.sort(rowsList);
        }
        finalList = rowsList.toArray(finalList);
        this.rowsPerPageDropdown = new JComboBox<Integer>(finalList);
        ViewUtil.makeSmall(this.rowsPerPageDropdown);
        this.rowsPerPageDropdown.setPrototypeDisplayValue(1000);
        if (hasDefaultRowsPerPage) {
            this.rowsPerPageDropdown.setSelectedIndex(rowsList.indexOf(this.rowsPerPageX));
        } else {
            this.rowsPerPageDropdown.setSelectedIndex(1);
        }
        this.rowsPerPageDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int rowsPerPage = (Integer)cb.getSelectedItem();
                SearchableTablePanel.this.setNumRowsPerPage(rowsPerPage);
            }
        });
        this.rowsPerPageDropdown.setPreferredSize(new Dimension(100, 25));
        this.rowsPerPageDropdown.setMaximumSize(new Dimension(100, 25));
        this.bottomPanel.add(this.rowsPerPageDropdown);
        this.setTableModel(this.data, columnNames, columnClasses);
        JPanel tablePanel = new JPanel(new BorderLayout(3, 3));
        JScrollPane jsp = new JScrollPane((Component)this.table);
        jsp.setBorder(null);
        tablePanel.add(jsp);
        if (allowSort) {
            this.add((Component)this.fieldPanel, "North");
        }
        if (allowPages) {
            this.add((Component)this.bottomPanel, "South");
        }
        this.add((Component)tablePanel, "Center");
        this.initEmpty();
    }

    public SortableTable getTable() {
        return this.table;
    }

    public boolean isUpdating() {
        return this.worker != null && this.worker.getState() != SwingWorker.StateValue.DONE;
    }

    private synchronized void updateView(boolean newData) {
        if (this.worker != null) {
            this.worker.cancel(true);
        }
        this.worker = new GetDataWorker(this.pageName, newData);
        this.worker.execute();
    }

    public void setBottomBarVisible(boolean b) {
        this.bottomPanel.setVisible(b);
    }

    public void setChooseColumnsButtonVisible(boolean b) {
        this.chooseColumnButton.setVisible(b);
    }

    public void setExportButtonVisible(boolean b) {
        this.exportButton.setVisible(b);
    }

    private void initEmpty() {
        this.model = new GenericTableModel(new Object[0][0], this.columnNames, this.columnClasses);
        this.gotoFirst.setEnabled(false);
        this.gotoPrevious.setEnabled(false);
        this.gotoNext.setEnabled(false);
        this.gotoLast.setEnabled(false);
        this.pageText.setText("0");
        this.pageLabel2.setText(" of 0");
        this.amountLabel.setText("  Showing 0 - 0 of 0");
        int[] columns = new int[this.columnNames.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = i;
        }
        this.filterField.setTableModel((TableModel)((Object)this.model));
        this.filterField.setColumnIndices(columns);
        this.filterField.setObjectConverterManagerEnabled(true);
        this.table.setModel((TableModel)new FilterableTableModel((TableModel)this.filterField.getDisplayTableModel()));
        this.columnChooser.hideColumns(this.hiddenColumns);
        int[] favColumns = new int[this.columnNames.length - this.hiddenColumns.length];
        int pos = 0;
        for (int i = 0; i < this.columnNames.length; ++i) {
            boolean hidden = false;
            for (int j = 0; j < this.hiddenColumns.length; ++j) {
                if (this.hiddenColumns[j] != i) continue;
                hidden = true;
                break;
            }
            if (hidden) continue;
            favColumns[pos] = i;
            ++pos;
        }
        this.columnChooser.setFavoriteColumns(favColumns);
    }

    public synchronized void applyData(List<Object[]> pageData) {
        if (pageData != null) {
            Vector v = this.model.getDataVector();
            v.removeAllElements();
            for (Object[] r : pageData) {
                v.add(new Vector<Object>(Arrays.asList(r)));
            }
        }
        this.gotoFirst.setEnabled(true);
        this.gotoPrevious.setEnabled(true);
        this.gotoNext.setEnabled(true);
        this.gotoLast.setEnabled(true);
        if (this.pageNum == 1 || this.pageNum == 0) {
            this.gotoFirst.setEnabled(false);
            this.gotoPrevious.setEnabled(false);
        }
        if (this.pageNum == this.getTotalNumPages() || this.pageNum == 0) {
            this.gotoNext.setEnabled(false);
            this.gotoLast.setEnabled(false);
        }
        this.pageText.setText(Integer.toString(this.getPageNumber()));
        this.pageLabel2.setText(" of " + ViewUtil.numToString(this.getTotalNumPages()));
        int start = this.getTotalNumPages() == 0 ? 0 : (this.getPageNumber() - 1) * this.getRowsPerPage() + 1;
        int end = this.getTotalNumPages() == 0 ? 0 : Math.min(start + this.getRowsPerPage() - 1, this.getTotalRowCount());
        this.amountLabel.setText("  Showing " + ViewUtil.numToString(start) + " - " + ViewUtil.numToString(end) + " of " + ViewUtil.numToString(this.getTotalRowCount()));
        this.model.fireTableDataChanged();
    }

    private void setTableModel(List<Object[]> data, String[] columnNames, Class[] columnClasses) {
        this.data = data == null ? new ArrayList<Object[]>() : data;
        this.columnNames = columnNames;
        this.columnClasses = columnClasses;
    }

    public void setNumRowsPerPage(int num) {
        this.numRowsPerPage = num;
        this.goToFirstPage();
    }

    private void strut(JPanel p) {
        p.add(Box.createHorizontalStrut(5));
    }

    private void setPageNumber(int i) {
        if (0 == this.getTotalNumPages()) {
            i = 1;
        } else if (i > this.getTotalNumPages()) {
            i = this.getTotalNumPages();
        } else if (i < 1) {
            i = 1;
        }
        this.pageNum = i;
        this.updateView(false);
    }

    public int getPageNumber() {
        return this.pageNum;
    }

    private void goToFirstPage() {
        this.setPageNumber(1);
    }

    private void goToLastPage() {
        this.setPageNumber(this.getTotalNumPages());
    }

    private void goToNextPage() {
        this.setPageNumber(this.pageNum + 1);
    }

    private void goToPreviousPage() {
        this.setPageNumber(this.pageNum - 1);
    }

    private int getTotalRowCount() {
        return this.totalNumRows;
    }

    private void setTotalRowCount(int num) {
        this.totalNumRows = num;
    }

    private int getTotalNumPages() {
        return (int)Math.ceil((double)this.getTotalRowCount() / (double)this.getRowsPerPage());
    }

    public int getRowsPerPage() {
        return this.numRowsPerPage;
    }

    private JButton niceButton() {
        JButton b = new JButton();
        b.setBorder(null);
        b.setBorderPainted(false);
        b.setOpaque(false);
        return b;
    }

    public void setSelectionMode(int selectionMode) {
        this.table.setSelectionMode(selectionMode);
    }

    public int getRetrievalLimit() {
        int limit;
        try {
            limit = Integer.parseInt(this.rowsRetrievedBox.getText());
        }
        catch (NumberFormatException ex) {
            this.rowsRetrievedBox.setText(String.valueOf(this.defaultRowsRetrieved));
            return this.defaultRowsRetrieved;
        }
        if (limit > 100000) {
            this.rowsRetrievedBox.setText(String.valueOf(100000));
            return 100000;
        }
        return limit;
    }

    public void forceRefreshData() {
        this.updateView(true);
    }

    public void setExportButtonEnabled(boolean enable) {
        this.exportButton.setEnabled(enable);
    }

    public int getActualRowAt(int row) {
        return TableModelWrapperUtils.getActualRowAt((TableModel)this.table.getModel(), (int)row);
    }

    public int getActualRowAcrossAllPages(int row) {
        return row + (this.getPageNumber() - 1) * this.rowsPerPageX;
    }

    public void setToggledRows(Set<Integer> rows) {
        this.toggledRows = rows;
        this.getTable().updateUI();
    }

    public boolean isRowToggled(int row) {
        if (this.toggledRows == null) {
            return false;
        }
        return this.toggledRows.contains(row);
    }

    public void setSelectedRows(List<Integer> rows) {
        this.selectedRows = rows;
    }

    public boolean isRowSelected(int row) {
        if (this.selectedRows == null) {
            return false;
        }
        return this.selectedRows.contains(row);
    }

    public void addSelectedRow(Integer row) {
        this.selectedRows.add(row);
    }

    public void removeSelectedRow(Integer row) {
        while (this.selectedRows.remove(row)) {
        }
    }

    public void addSelectedRows(List<Integer> rows) {
        this.selectedRows.addAll(rows);
    }

    public String getToolTip(int actualRow) {
        return null;
    }

    public void scrollSafeSelectAction(final Runnable onSelectTask) {
        final KeyTimer keyTimer = new KeyTimer(KEY_PRESS_TIMER_INTERVAL, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SearchableTablePanel.this.keydown = false;
                SearchableTablePanel.this.waitlong = false;
                SearchableTablePanel.this.resetSelectionChangedWorker(onSelectTask);
            }
        });
        keyTimer.setRepeats(false);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){
            private long lastDelta = -1L;
            private long lastTime = System.currentTimeMillis();
            private int deltaSame = 0;
            private boolean first = true;

            @Override
            public void keyPressed(KeyEvent ke) {
                super.keyPressed(ke);
                if (!ArrayUtils.contains((int[])SCROLLING_KEYS, (int)ke.getKeyCode())) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                long delta = currentTime - this.lastTime;
                this.deltaSame = Math.abs(delta - this.lastDelta) < 5L ? ++this.deltaSame : 0;
                if (this.deltaSame > 5) {
                    if (this.first || (float)(delta - (long)KEY_PRESS_TIMER_INTERVAL) > 10.0f) {
                        KEY_PRESS_TIMER_INTERVAL = (int)delta + 20;
                        LOG.info((Object)("Detected " + this.deltaSame + " keypresses with delta ~" + delta + ", setting new repeat-interval to " + KEY_PRESS_TIMER_INTERVAL));
                        this.first = false;
                    }
                    this.deltaSame = 0;
                }
                this.lastDelta = delta;
                this.lastTime = currentTime;
                SearchableTablePanel.this.keydown = true;
                SearchableTablePanel.this.stopSelectionChangedWorker();
                if (keyTimer.isRunning()) {
                    keyTimer.stop("keyPressed stop");
                    if (SearchableTablePanel.this.waitlong) {
                        SearchableTablePanel.this.waitlong = false;
                        keyTimer.setInitialDelay(1000);
                    } else {
                        keyTimer.setInitialDelay(KEY_PRESS_TIMER_INTERVAL);
                    }
                    keyTimer.restart("keyPressed restart");
                } else {
                    SearchableTablePanel.this.waitlong = false;
                    keyTimer.setInitialDelay(1000);
                    keyTimer.start("keyTimer start");
                }
            }
        });
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (!SearchableTablePanel.this.keydown && !keyTimer.isRunning()) {
                    SearchableTablePanel.this.waitlong = true;
                    keyTimer.setInitialDelay(KEY_PRESS_TIMER_INTERVAL);
                    keyTimer.start("valueChanged start");
                }
            }
        });
    }

    private synchronized void stopSelectionChangedWorker() {
        if (this.selectionChangedWorker != null && !this.selectionChangedWorker.isDone() && !this.selectionChangedWorker.isCancelled()) {
            try {
                ThreadController.getInstance().cancelWorkers("SubInspector");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void resetSelectionChangedWorker(Runnable task) {
        this.stopSelectionChangedWorker();
        this.selectionChangedWorker = new SelectionChangedWorker(task);
        this.selectionChangedWorker.execute();
    }

    private void printTime(String msg) {
        long curr = System.currentTimeMillis();
        long delta = curr - this.lastTime;
        System.out.println(msg + " curr: " + curr + " last: " + this.lastTime + " delta: " + delta);
        this.lastTime = curr;
    }

    public void setResizeOff() {
        this.table.setAutoResizeMode(0);
    }

    public void setAutoResizeMode(int mode) {
        this.table.setAutoResizeMode(mode);
    }

    public void setHelpButtonVisible(boolean enable) {
        this.helpButton.setVisible(enable);
    }

    public ColumnChooser getColumnChooser() {
        return this.columnChooser;
    }

    class SelectionChangedWorker
    extends MedSavantWorker<Object> {
        Runnable task;

        public SelectionChangedWorker(Runnable task) {
            super("SubInspector");
            this.task = task;
        }

        @Override
        protected void showSuccess(Object result) {
        }

        @Override
        protected Object doInBackground() throws Exception {
            this.task.run();
            return null;
        }
    }

    private class KeyTimer
    extends Timer {
        private long startTime;

        public KeyTimer(int interval, ActionListener al) {
            super(interval, al);
        }

        public synchronized void start(String msg) {
            super.start();
        }

        public synchronized void stop(String msg) {
            super.stop();
        }

        public synchronized void restart(String msg) {
            super.restart();
        }
    }

    private class GetDataWorker
    extends MedSavantWorker<List<Object[]>> {
        boolean update;

        protected GetDataWorker(String pageName, boolean newData) {
            super(pageName);
            this.update = newData;
        }

        @Override
        protected List<Object[]> doInBackground() throws Exception {
            if (this.update) {
                SearchableTablePanel.this.setTotalRowCount(SearchableTablePanel.this.retriever.getTotalNum());
                SearchableTablePanel.this.pageNum = 1;
            }
            List<Object[]> results = SearchableTablePanel.this.retriever.retrieve((SearchableTablePanel.this.pageNum - 1) * SearchableTablePanel.this.getRowsPerPage(), SearchableTablePanel.this.getRowsPerPage());
            return results;
        }

        @Override
        protected void showProgress(double fraction) {
        }

        @Override
        protected void showSuccess(List<Object[]> result) {
            SearchableTablePanel.this.applyData(result);
            SearchableTablePanel.this.retriever.retrievalComplete();
        }
    }

    public static enum TableSelectionType {
        DISABLED,
        CELL,
        ROW;

    }
}

