/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RoundedPanel
extends JPanel {
    private final int radius;
    private boolean dashed;
    private int dashThickness;

    public RoundedPanel(int cornerRadius) {
        this.radius = cornerRadius;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isOpaque()) {
            Color bg = this.getBackground();
            g2.setColor(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            g2.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.radius, this.radius);
        }
        g2.setColor(new Color(164, 164, 164));
        if (this.dashed) {
            BasicStroke dashedStroke = new BasicStroke(this.dashThickness, 0, 0, 10.0f, new float[]{7.0f}, 0.0f);
            g2.setStroke(dashedStroke);
            g2.draw(new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.radius, this.radius));
        } else {
            g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.radius, this.radius);
        }
    }

    public void setBorderDashed(boolean b) {
        this.dashed = b;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(400, 300);
        frame.setLocation(400, 300);
        frame.setDefaultCloseOperation(3);
        JPanel content = new JPanel();
        JPanel wl = new JPanel();
        JPanel el = new JPanel();
        JPanel sl = new JPanel();
        JPanel nl = new JPanel();
        RoundedPanel rp = new RoundedPanel(50);
        JComboBox<String> combobox = new JComboBox<String>();
        frame.setContentPane(content);
        content.setBackground(Color.red);
        content.setLayout(new BorderLayout());
        wl.add(new JButton("west"));
        el.add(new JButton("east"));
        sl.add(new JButton("south"));
        nl.add(new JButton("north"));
        content.add((Component)wl, "West");
        content.add((Component)el, "East");
        content.add((Component)nl, "North");
        content.add((Component)sl, "South");
        content.add((Component)rp, "Center");
        rp.setBackground(Color.BLACK);
        combobox.setModel(new DefaultComboBoxModel<String>(new String[]{"T\u0159\u00edda 1.B", "T\u0159\u00edda 1.C", "T\u0159\u00edda 2.C"}));
        rp.add(combobox);
        frame.setVisible(true);
    }

    public void setDashThickness(int i) {
        this.dashThickness = i;
    }
}

