/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.component;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class HoverButton
extends JButton {
    private static final Color UNSELECTED_TEXT_COLOR = Color.GRAY;
    private boolean over;
    private Font f;
    String face = "Arial";
    int size = 15;
    int style = 0;
    private int sidePadding = 2;
    private int totalWidth;
    private int topPadding = 1;
    private int totalHeight;
    private Color textColor = Color.white;

    public void setForeColor(Color c) {
        this.textColor = c;
    }

    public void setFontSize(int size) {
        this.size = size;
        this.resetFont();
    }

    public void setFontStyle(int style) {
        this.style = style;
        this.resetFont();
    }

    public HoverButton(String s) {
        super(s);
        this.resetFont();
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                HoverButton.this.over = true;
                HoverButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HoverButton.this.over = false;
                HoverButton.this.repaint();
            }
        });
        this.setCursor(new Cursor(12));
        this.resize();
    }

    private void resize() {
        String title = this.getText();
        Graphics2D g2d = (Graphics2D)this.getGraphics();
        if (g2d == null) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.f);
        int width = g2d.getFontMetrics().stringWidth(title);
        int height = g2d.getFontMetrics().getAscent();
        this.totalWidth = width + this.sidePadding * 2;
        this.totalHeight = height + this.topPadding * 2;
        this.setPreferredSize(new Dimension(this.totalWidth, this.totalHeight));
        this.setMinimumSize(new Dimension(this.totalWidth, this.totalHeight));
        this.setMaximumSize(new Dimension(this.totalWidth, this.totalHeight));
        this.invalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        String title = this.getText();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setFont(this.f);
        int height = g2d.getFontMetrics().getAscent();
        if (this.over || this.isSelected()) {
            g2d.setColor(this.textColor);
        } else {
            g2d.setColor(UNSELECTED_TEXT_COLOR);
        }
        g2d.drawString(title, 8, (this.getHeight() + height) / 2 - 2);
    }

    private void resetFont() {
        this.f = new Font(this.face, this.style, this.size);
    }

    public void setSelectedColor(Color c) {
        this.textColor = c;
        this.repaint();
    }
}

