/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.app.builtin.task.ServerJobMonitorTaskWorker;
import org.ut.biolab.medsavant.client.view.app.builtin.task.ServerLogTaskWorker;
import org.ut.biolab.medsavant.client.view.app.builtin.task.TaskWorker;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.component.StripyTable;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.list.DetailedListModel;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.list.SplitScreenView;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.GeneralLog;

public class TaskManagerApp
implements LaunchableApp,
Listener<TaskWorker> {
    private ArrayList<TaskWorker> tasks = new ArrayList();
    private SplitScreenView container;
    private TaskDetailedView detailedView;
    private boolean isShowing;

    public TaskManagerApp() {
        this.initView();
    }

    @Override
    public JPanel getView() {
        return this.container;
    }

    private void initView() {
        if (this.container == null) {
            this.detailedView = new TaskDetailedView();
            this.container = new SplitScreenView(new DetailedListModel(){

                @Override
                public Object[][] getList(int limit) throws Exception {
                    Object[][] results = new Object[TaskManagerApp.this.tasks.size() + 2][];
                    int counter = 0;
                    for (TaskWorker t : TaskManagerApp.this.tasks) {
                        results[counter++] = new Object[]{t.getTaskName(), t};
                    }
                    TaskWorker t = new ServerLogTaskWorker();
                    results[counter] = new Object[]{t.getTaskName(), t};
                    t = new ServerJobMonitorTaskWorker();
                    int n = ++counter;
                    ++counter;
                    results[n] = new Object[]{t.getTaskName(), t};
                    return results;
                }

                @Override
                public String[] getColumnNames() {
                    return new String[]{"Task name", "Task"};
                }

                @Override
                public Class[] getColumnClasses() {
                    return new Class[]{String.class, TaskWorker.class};
                }

                @Override
                public int[] getHiddenColumns() {
                    return new int[0];
                }
            }, this.detailedView);
        }
    }

    public void showMessageForTask(TaskWorker t, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogUtils.displayMessage("Task Manager", message);
            }
        });
    }

    public void showErrorForTask(final TaskWorker t, final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogUtils.displayException("Task Manager", "Error running task " + t.getTaskName(), e);
            }
        });
    }

    @Override
    public void viewWillUnload() {
    }

    @Override
    public void viewWillLoad() {
    }

    @Override
    public void viewDidUnload() {
        this.isShowing = false;
    }

    @Override
    public void viewDidLoad() {
        this.isShowing = true;
    }

    @Override
    public String getName() {
        return "Task Manager";
    }

    @Override
    public ImageIcon getIcon() {
        return IconFactory.getInstance().getIcon(IconFactory.StandardIcon.APP_TASKMANAGER);
    }

    public void submitTask(TaskWorker t) {
        this.tasks.add(t);
        t.addListener(this);
        this.container.refresh();
    }

    @Override
    public void didLogout() {
        this.tasks.removeAll(this.tasks);
        this.container.refresh();
    }

    @Override
    public void didLogin() {
    }

    @Override
    public void handleEvent(TaskWorker t) {
        if (this.detailedView.getSelectedWorker() == t && this.isShowing) {
            this.detailedView.updateView(t);
        }
    }

    class TaskDetailedView
    extends DetailedView {
        private static final int REFRESH_DELAY = 2000;
        private TaskWorker selectedWorker;
        private Timer refreshTimer;
        private StandardFixableWidthAppPanel container;
        private final JPanel logPanel;
        private final BlockingPanel blockingPanel;
        private final JPanel statusPanel;

        public TaskDetailedView() {
            super("Task Manager");
            this.refreshTimer = null;
            this.container = new StandardFixableWidthAppPanel(true, false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.container, "Center");
            this.statusPanel = this.container.addBlock();
            this.logPanel = this.container.addBlock();
            this.blockingPanel = new BlockingPanel("No item selected", this.container);
            this.add((Component)this.blockingPanel, "Center");
        }

        @Override
        public void setSelectedItem(Object[] selectedRow) {
            TaskWorker t;
            if (selectedRow.length == 0) {
                this.updateView(null);
                return;
            }
            this.selectedWorker = t = (TaskWorker)selectedRow[1];
            this.updateView(t);
        }

        public TaskWorker getSelectedWorker() {
            return this.selectedWorker;
        }

        @Override
        public void setMultipleSelections(List<Object[]> selectedRows) {
        }

        @Override
        public JPopupMenu createPopup() {
            return null;
        }

        private void updateView(final TaskWorker t) {
            if (this.refreshTimer != null) {
                this.refreshTimer.stop();
                this.refreshTimer = null;
            }
            if (t == null) {
                this.blockingPanel.block();
                this.updateUI();
                return;
            }
            this.blockingPanel.unblock();
            this.statusPanel.removeAll();
            this.logPanel.removeAll();
            MigLayout l = new MigLayout("fillx, nogrid, insets 0");
            this.logPanel.setLayout((LayoutManager)l);
            this.container.setTitle(t.getTaskName());
            if (t.getCurrentStatus() != TaskWorker.TaskStatus.PERSISTENT && t.getCurrentStatus() != TaskWorker.TaskStatus.PERSISTENT_AUTOREFRESH) {
                this.statusPanel.add(new JLabel(t.getCurrentStatus().toString()));
                if (t.getCurrentStatus() == TaskWorker.TaskStatus.INPROGRESS) {
                    this.statusPanel.add(ViewUtil.getIndeterminateProgressBar());
                }
            }
            if (t.getOwner() != null) {
                JButton appButton = new JButton(String.format("Open %s App", t.getOwner().getName()));
                appButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MedSavantFrame.getInstance().getDashboard().launchApp(t.getOwner());
                    }
                });
                this.statusPanel.add(appButton);
            }
            if (t.getCurrentStatus() == TaskWorker.TaskStatus.PERSISTENT || t.getCurrentStatus() == TaskWorker.TaskStatus.PERSISTENT_AUTOREFRESH) {
                JButton refreshButton = ViewUtil.getRefreshButton();
                ActionListener al = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TaskManagerApp.this.detailedView.updateView(t);
                    }
                };
                refreshButton.addActionListener(al);
                this.statusPanel.add(refreshButton);
                if (t.getCurrentStatus() == TaskWorker.TaskStatus.PERSISTENT_AUTOREFRESH) {
                    this.refreshTimer = new Timer(2000, al);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TaskDetailedView.this.refreshTimer.start();
                        }
                    });
                }
            }
            if (t.getCurrentStatus() == TaskWorker.TaskStatus.INPROGRESS) {
                JButton cancelButton = new JButton("Cancel");
                this.statusPanel.add(cancelButton);
                cancelButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        t.cancel();
                    }
                });
            }
            List<GeneralLog> log = t.getLog();
            Object[][] tableData = new Object[log.size()][];
            int counter = 0;
            for (GeneralLog s : log) {
                tableData[counter++] = new Object[]{(s.getTimestamp() == null ? "" : new Date(s.getTimestamp().getTime()).toLocaleString() + " - ") + s.getDescription()};
            }
            if (tableData.length > 0) {
                StripyTable table = new StripyTable(tableData, new String[]{"Log"});
                table.disableSelection();
                this.logPanel.add((Component)table, "newline 0, growx 1.0");
                table.setRowSelectionAllowed(false);
            } else {
                this.logPanel.add(ViewUtil.getGrayItalicizedLabel("No logs"));
            }
            this.updateUI();
        }
    }
}

