/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.app.builtin.task.TaskWorker;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.GeneralLog;

public abstract class BackgroundTaskWorker<T>
implements TaskWorker {
    private static final int MAX_MEDSAVANT_WORKER_THREADS = 20;
    List<GeneralLog> taskLog = new ArrayList<GeneralLog>();
    boolean preventsQuit;
    private Date startDate;
    private Date stopDate;
    private double taskProgress = -1.0;
    private TaskWorker.TaskStatus status;
    private final LaunchableApp owner;
    private String completionMessage;
    private final List<Listener<TaskWorker>> listeners;
    private SwingWorker<T, Object> worker;
    private String taskName;

    public String getStatus() {
        return this.status.toString();
    }

    public void addLog(String s) {
        this.taskLog.add(new GeneralLog(s));
        this.taskUpdated();
    }

    @Override
    public List<GeneralLog> getLog() {
        return this.taskLog;
    }

    private void taskUpdated() {
        for (Listener<TaskWorker> listener : this.listeners) {
            listener.handleEvent(this);
        }
    }

    public final void setStatus(TaskWorker.TaskStatus taskStatus) {
        this.status = taskStatus;
        this.taskUpdated();
    }

    public BackgroundTaskWorker(LaunchableApp owner, String taskName) {
        this.owner = owner;
        this.taskName = taskName;
        this.listeners = new ArrayList<Listener<TaskWorker>>();
        this.setStatus(TaskWorker.TaskStatus.UNSTARTED);
        AppDirectory.getTaskManager().submitTask(this);
    }

    public BackgroundTaskWorker(String taskName) {
        this(null, taskName);
    }

    public void start() {
        this.startDate = new Date();
        this.setStatus(TaskWorker.TaskStatus.INPROGRESS);
        final BackgroundTaskWorker instance = this;
        this.worker = new SwingWorker<T, Object>(){

            @Override
            public void done() {
                if (BackgroundTaskWorker.this.status == TaskWorker.TaskStatus.INPROGRESS) {
                    BackgroundTaskWorker.this.setStatus(TaskWorker.TaskStatus.FINISHED);
                }
                instance.done();
            }

            @Override
            protected T doInBackground() throws Exception {
                return instance.doInBackground();
            }
        };
        this.worker.execute();
    }

    @Override
    public void cancel() {
        this.stopDate = new Date();
        this.setStatus(TaskWorker.TaskStatus.CANCELLED);
        this.worker.cancel(true);
    }

    public void done() {
        try {
            if (this.worker.isCancelled()) {
                throw new InterruptedException("Task interrupted");
            }
            this.showSuccess(this.worker.get());
        }
        catch (Exception e) {
            this.showFailure(e);
        }
    }

    @Override
    public void addListener(Listener<TaskWorker> l) {
        this.listeners.add(l);
    }

    protected abstract T doInBackground() throws Exception;

    protected abstract void showSuccess(T var1);

    protected void showFailure(final Exception e) {
        final BackgroundTaskWorker t = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogUtils.displayException("Task Manager", "Error running task " + t.getTaskName(), e);
            }
        });
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public TaskWorker.TaskStatus getCurrentStatus() {
        return this.status;
    }

    @Override
    public double getTaskProgress() {
        return this.taskProgress;
    }

    public void setTaskProgress(double taskProgress) {
        this.taskProgress = taskProgress;
        this.taskUpdated();
    }

    @Override
    public LaunchableApp getOwner() {
        return this.owner;
    }

    public GeneralLog getLastLog() {
        if (this.taskLog.isEmpty()) {
            return null;
        }
        return this.getLog().get(this.getLog().size() - 1);
    }

    public Notification getNotificationForWorker() {
        final BackgroundTaskWorker instance = this;
        final Notification n = new Notification();
        n.setName(instance.getTaskName());
        n.setIcon(instance.getOwner().getIcon());
        instance.addListener(new Listener<TaskWorker>(){

            @Override
            public void handleEvent(TaskWorker event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        n.setDescription(instance.getLastLog().getDescription());
                        n.setProgress(instance.getTaskProgress());
                    }
                });
            }
        });
        return n;
    }
}

