/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.plugin.PluginEvent;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.appapi.MedSavantApp;
import org.ut.biolab.medsavant.shared.appapi.MedSavantVariantSectionApp;

public class PluginPage
extends AppSubSection {
    private static final Log LOG = LogFactory.getLog(PluginPage.class);
    private static AppController controller = AppController.getInstance();
    private MedSavantVariantSectionApp plugin;
    private final JPanel view = new JPanel();

    public PluginPage(MultiSectionApp parent, final MedSavantVariantSectionApp plugin) {
        super(parent, plugin.getTitle());
        this.view.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (plugin != null) {
            plugin.init(this.view);
        } else {
            JLabel placeholder = new JLabel(plugin.getTitle());
            placeholder.setFont(ViewUtil.getBigTitleFont());
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.view.add((Component)placeholder, gbc);
            controller.addListener(new Listener<PluginEvent>(){

                @Override
                public void handleEvent(PluginEvent event) {
                    LOG.debug((Object)String.format("PluginPage.handleEvent(%s)", new Object[]{event.getType()}));
                    switch (event.getType()) {
                        case LOADED: {
                            PluginPage.this.view.removeAll();
                            MedSavantApp plug = event.getPlugin();
                            if (!(plug instanceof MedSavantVariantSectionApp)) break;
                            plugin.init(PluginPage.this.view);
                            break;
                        }
                        case ERROR: {
                            ((JLabel)PluginPage.this.view.getComponent(0)).setText(controller.getPluginStatus(event.getID()));
                        }
                    }
                    controller.removeListener(this);
                }
            });
        }
    }

    @Override
    public JPanel getView() {
        return this.view;
    }

    @Override
    public void viewWillLoad() {
        super.viewWillLoad();
        if (this.plugin != null) {
            this.plugin.viewDidLoad();
        }
    }

    @Override
    public void viewDidUnload() {
        if (this.plugin != null) {
            this.plugin.viewDidUnload();
        }
        super.viewDidUnload();
    }
}

