/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app.builtin.settings;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.layout.GroupLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.dialog.ProgressDialog;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

public class AddRemoveDatabaseDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(AddRemoveDatabaseDialog.class);
    private final boolean removing;
    private JButton cancelButton;
    private JTextField databaseField;
    private JTextField hostField;
    private JButton okButton;
    private JPasswordField passwordField;
    private JTextField portField;
    private JTextField userField;

    public AddRemoveDatabaseDialog(String host, String port, String dbName, String user, char[] pass, boolean removing) {
        super(DialogUtils.getFrontWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.removing = removing;
        this.initComponents();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.hostField.setText(host);
        this.portField.setText(port);
        this.userField.setText(user);
        this.passwordField.setText(new String(pass));
        this.databaseField.setText(dbName);
        this.databaseField.requestFocus();
        if (removing) {
            this.okButton.setText("Remove");
            this.setTitle("Remove Database");
        }
        ClientMiscUtils.registerCancelButton(this.cancelButton);
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        JPanel detailsPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.hostField = new JTextField();
        JLabel jLabel4 = new JLabel();
        this.portField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.databaseField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.passwordField = new JPasswordField();
        JLabel jLabel7 = new JLabel();
        this.userField = new JTextField();
        this.setTitle("Create Database");
        this.setBackground(new Color(217, 222, 229));
        this.okButton.setText("Create");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddRemoveDatabaseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddRemoveDatabaseDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        detailsPanel.setBackground(this.getBackground());
        detailsPanel.setOpaque(false);
        jLabel3.setHorizontalAlignment(0);
        jLabel3.setText("SERVER ADDRESS");
        this.hostField.setFont(new Font("Lucida Grande", 0, 15));
        this.hostField.setHorizontalAlignment(0);
        jLabel4.setHorizontalAlignment(0);
        jLabel4.setText("SERVER PORT");
        this.portField.setFont(new Font("Lucida Grande", 0, 15));
        this.portField.setHorizontalAlignment(0);
        jLabel5.setHorizontalAlignment(0);
        jLabel5.setText("DATABASE NAME");
        this.databaseField.setFont(new Font("Lucida Grande", 0, 15));
        this.databaseField.setHorizontalAlignment(0);
        jLabel6.setHorizontalAlignment(0);
        jLabel6.setText("ADMIN USERNAME");
        this.passwordField.setFont(new Font("Lucida Grande", 0, 15));
        this.passwordField.setHorizontalAlignment(0);
        jLabel7.setHorizontalAlignment(0);
        jLabel7.setText("ADMIN PASSWORD");
        this.userField.setFont(new Font("Lucida Grande", 0, 15));
        this.userField.setHorizontalAlignment(0);
        GroupLayout detailsPanelLayout = new GroupLayout((Container)detailsPanel);
        detailsPanel.setLayout((LayoutManager)detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup((GroupLayout.Group)detailsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)detailsPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)detailsPanelLayout.createParallelGroup(1).add(2, (Component)jLabel3, -1, 440, Short.MAX_VALUE).add(2, (Component)this.hostField, -1, 440, Short.MAX_VALUE).add((Component)jLabel4, -1, 440, Short.MAX_VALUE).add(2, (Component)this.portField, -1, 440, Short.MAX_VALUE).add((Component)jLabel5, -1, 440, Short.MAX_VALUE).add((Component)this.databaseField, -1, 440, Short.MAX_VALUE).add((Component)jLabel6, -1, 440, Short.MAX_VALUE).add((Component)jLabel7, -1, 440, Short.MAX_VALUE).add((Component)this.passwordField, -1, 440, Short.MAX_VALUE).add(2, (Component)this.userField, -1, 440, Short.MAX_VALUE)).addContainerGap()));
        detailsPanelLayout.setVerticalGroup((GroupLayout.Group)detailsPanelLayout.createParallelGroup(1).add((GroupLayout.Group)detailsPanelLayout.createSequentialGroup().addContainerGap().add((Component)jLabel3).addPreferredGap(0).add((Component)this.hostField, -2, -1, -2).addPreferredGap(0).add((Component)jLabel4).addPreferredGap(0).add((Component)this.portField, -2, -1, -2).addPreferredGap(0).add((Component)jLabel5).addPreferredGap(0).add((Component)this.databaseField, -2, -1, -2).addPreferredGap(0).add((Component)jLabel6).addPreferredGap(0).add((Component)this.userField, -2, -1, -2).addPreferredGap(0).add((Component)jLabel7).addPreferredGap(0).add((Component)this.passwordField, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(285, Short.MAX_VALUE).add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton).addContainerGap()).add((Component)detailsPanel, -1, -1, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)detailsPanel, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)).addContainerGap()));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String dbName = this.databaseField.getText();
        if (this.removing) {
            if (DialogUtils.askYesNo("Confirm", "<html>Are you sure you want to remove <i>%s</i>?<br>This operation cannot be undone.", dbName) == 0) {
                try {
                    MedSavantClient.initializeRegistry(this.hostField.getText(), this.portField.getText());
                    MedSavantClient.SetupManager.removeDatabase(this.hostField.getText(), Integer.parseInt(this.portField.getText()), this.databaseField.getText(), this.userField.getText(), this.passwordField.getPassword());
                    this.setVisible(false);
                    DialogUtils.displayMessage("Database Removed", String.format("<html>Database <i>%s</i> successfully removed.</html>", this.databaseField.getText()));
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Database could not be removed: %s", ex);
                }
            }
        } else {
            new ProgressDialog("Creating Database", String.format("<html>Creating database <i>%s</i>. Please wait.</html>", dbName)){

                @Override
                public void run() {
                    try {
                        MedSavantClient.initializeRegistry(AddRemoveDatabaseDialog.this.hostField.getText(), AddRemoveDatabaseDialog.this.portField.getText());
                        MedSavantClient.SetupManager.createDatabase(AddRemoveDatabaseDialog.this.hostField.getText(), Integer.parseInt(AddRemoveDatabaseDialog.this.portField.getText()), AddRemoveDatabaseDialog.this.databaseField.getText(), AddRemoveDatabaseDialog.this.userField.getText(), AddRemoveDatabaseDialog.this.passwordField.getPassword());
                        AddRemoveDatabaseDialog.this.setVisible(false);
                        DialogUtils.displayMessage("Database Created", String.format("<html>Database <i>%s</i> successfully created.</html>", AddRemoveDatabaseDialog.this.databaseField.getText()));
                    }
                    catch (Throwable ex) {
                        this.setVisible(false);
                        ex.printStackTrace();
                        ClientMiscUtils.reportError("Database could not be created: %s\nPlease check the settings and try again.", ex);
                    }
                }
            }.setVisible(true);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public int getPort() {
        return Integer.parseInt(this.portField.getText());
    }

    public String getDatabase() {
        return this.databaseField.getText();
    }
}

