/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app;

import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class MultiStepProgressPanel
extends JPanel {
    private ActionListener cancelAction;
    private final ArrayList<Step> steps = new ArrayList();
    private Step currentStep;

    public MultiStepProgressPanel() {
        this.initView();
    }

    public void setCancelAction(ActionListener cancelActionListener) {
        this.cancelAction = cancelActionListener;
    }

    public void reset() {
        this.steps.removeAll(this.steps);
        this.currentStep = null;
        this.refreshView();
    }

    private void initView() {
    }

    public void stepFailed() {
        if (this.currentStep != null) {
            this.currentStep.setStatus(Step.StepStatus.FAILED);
        }
        this.refreshView();
    }

    public void stepCompleted() {
        if (this.currentStep != null) {
            this.currentStep.setStatus(Step.StepStatus.COMPLETED);
        }
        this.refreshView();
    }

    public void startNewStepWithDescription(String d) {
        Step s;
        this.currentStep = s = new Step(d);
        s.setStatus(Step.StepStatus.INPROGRESS);
        this.steps.add(s);
        this.refreshView();
    }

    private void refreshView() {
        this.removeAll();
        MigLayout l = new MigLayout("wrap 2");
        this.setLayout((LayoutManager)l);
        for (Step s : this.steps) {
            switch (s.getStatus()) {
                case UNSTARTED: {
                    this.add(new JLabel("?"));
                    break;
                }
                case INPROGRESS: {
                    this.add(ViewUtil.getIndeterminateProgressBar());
                    break;
                }
                case FAILED: {
                    this.add(new JLabel("x"));
                    break;
                }
                case COMPLETED: {
                    this.add(new JLabel("check"));
                    break;
                }
                default: {
                    this.add(ViewUtil.getClearPanel());
                }
            }
            this.add(new JLabel(s.getDescription()));
        }
    }

    static class Step {
        private String description;
        private StepStatus status;

        public Step(String description) {
            this.description = description;
            this.status = StepStatus.UNSTARTED;
        }

        public void setStatus(StepStatus s) {
            this.status = s;
        }

        public String getDescription() {
            return this.description;
        }

        public StepStatus getStatus() {
            return this.status;
        }

        public static enum StepStatus {
            UNSTARTED,
            INPROGRESS,
            FAILED,
            COMPLETED;

        }
    }
}

