/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ut.biolab.medsavant.client.view.app.AppSubSection;
import org.ut.biolab.medsavant.client.view.dashboard.LaunchableApp;
import org.ut.biolab.medsavant.client.view.util.PeekingPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class MultiSectionApp
implements LaunchableApp {
    private final String name;
    private JPanel view;
    private AppSubSection currentSubSection;

    protected MultiSectionApp(String name) {
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract AppSubSection[] getSubSections();

    public JPanel[] getPersistentPanels() {
        return null;
    }

    public Component[] getSectionMenuComponents() {
        return null;
    }

    @Override
    public abstract ImageIcon getIcon();

    @Override
    public JPanel getView() {
        if (this.view == null) {
            AppSubSection[] subsections;
            this.view = new JPanel();
            this.view.setLayout(new BorderLayout());
            final JTabbedPane tabs = ViewUtil.getMSTabedPane();
            for (AppSubSection sub : subsections = this.getSubSections()) {
                tabs.add(sub.getPageName(), sub.getView());
            }
            if (subsections.length > 0) {
                this.currentSubSection = subsections[0];
            }
            tabs.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (MultiSectionApp.this.currentSubSection != null) {
                        MultiSectionApp.this.currentSubSection.viewDidUnload();
                    }
                    MultiSectionApp.this.currentSubSection = subsections[tabs.getSelectedIndex()];
                    MultiSectionApp.this.currentSubSection.viewWillLoad();
                }
            });
            if (this.getPersistentPanels() != null && this.getPersistentPanels().length > 0) {
                PeekingPanel pp = new PeekingPanel("", "East", this.getPersistentPanels()[0], true);
                pp.setToggleBarVisible(false);
                this.view.add((Component)((Object)pp), "West");
            }
            this.view.add((Component)tabs, "Center");
        }
        return this.view;
    }

    @Override
    public void viewWillUnload() {
    }

    @Override
    public void viewWillLoad() {
    }

    @Override
    public void viewDidUnload() {
        if (this.currentSubSection != null) {
            this.currentSubSection.viewDidUnload();
        }
    }

    @Override
    public void viewDidLoad() {
        if (this.currentSubSection != null) {
            this.currentSubSection.viewWillLoad();
        }
    }

    @Override
    public void didLogout() {
        if (this.currentSubSection != null) {
            this.currentSubSection.didLogout();
        }
    }

    @Override
    public void didLogin() {
        if (this.currentSubSection != null) {
            this.currentSubSection.didLogin();
        }
    }
}

