/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.app;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.app.MultiSectionApp;

public abstract class AppSubSection {
    private final MultiSectionApp parent;
    protected final String pageName;
    protected boolean loaded;
    private boolean updateRequired = true;
    private JButton undockButton;
    private JFrame undockedFrame;
    private DockState dockState = DockState.DOCKED;

    public void focusUndockedFrame() {
        this.undockedFrame.toFront();
    }

    public DockState getDockState() {
        return this.dockState;
    }

    private void dock(JFrame undockedFrame) {
        this.undockButton.setText("Undock Genome Browser");
        undockedFrame.dispose();
        undockedFrame = null;
        this.dockState = DockState.DOCKED;
    }

    private JFrame undock() {
        this.dockState = DockState.UNDOCKING;
        this.undockButton.setText("Dock Genome Browser");
        this.undockedFrame = new JFrame("Savant Browser");
        this.undockedFrame.setDefaultCloseOperation(2);
        this.undockedFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AppSubSection.this.dock(AppSubSection.this.undockedFrame);
            }
        });
        JPanel cc = new JPanel();
        cc.setBackground(Color.white);
        cc.setLayout(new BorderLayout());
        this.undockedFrame.add(cc);
        this.undockedFrame.pack();
        this.undockedFrame.setLocationRelativeTo(null);
        this.undockedFrame.setVisible(true);
        this.undockedFrame.repaint();
        this.dockState = DockState.UNDOCKED;
        return this.undockedFrame;
    }

    protected JButton getUndockButton() {
        if (this.undockButton == null) {
            this.undockButton = new JButton("Undock Genome Browser");
            this.undockButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.undockButton.addActionListener(new ActionListener(){
                private JFrame undockedFrame;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (AppSubSection.this.dockState == DockState.DOCKED) {
                        this.undockedFrame = AppSubSection.this.undock();
                    } else if (AppSubSection.this.dockState == DockState.UNDOCKED) {
                        AppSubSection.this.dock(this.undockedFrame);
                    }
                }
            });
        }
        return this.undockButton;
    }

    public void setUpdateRequired(boolean required) {
        this.updateRequired = required;
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public AppSubSection(MultiSectionApp parent, String page) {
        this.parent = parent;
        this.pageName = page;
    }

    public JPanel getDockedView() {
        if (this.dockState != DockState.UNDOCKED) {
            return this.getView();
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(new JLabel(this.pageName + " view is undocked into a separate window..."));
        p.add(Box.createHorizontalGlue());
        return p;
    }

    public abstract JPanel getView();

    public void clearSelection() {
    }

    public Component[] getSubSectionMenuComponents() {
        return null;
    }

    public String getPageName() {
        return this.pageName;
    }

    public MultiSectionApp getParent() {
        return this.parent;
    }

    public void viewWillLoad() {
        this.loaded = true;
    }

    public void viewDidUnload() {
        this.loaded = false;
        ThreadController.getInstance().cancelWorkers(this.pageName);
    }

    public void didLogout() {
    }

    public void didLogin() {
    }

    public static enum DockState {
        UNDOCKED,
        UNDOCKING,
        DOCKED;

    }
}

