/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.animation;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ut.biolab.medsavant.client.view.animation.Animation;

public class AnimatablePanel
extends JPanel {
    private int tickTime = 30;
    private Thread animationThread;
    private List<Animation> animations = new CopyOnWriteArrayList<Animation>();

    public void setTickTime(int tt) {
        this.tickTime = tt;
    }

    public void cancel() {
        if (this.animationThread != null && this.animationThread.isAlive()) {
            this.animations.clear();
            this.repaint();
        }
    }

    public void cancel(Animation anim) {
        this.animations.remove(anim);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        for (Animation animation : this.animations) {
            Graphics2D g2d = (Graphics2D)g.create();
            animation.drawUpdate(g2d, this);
            g2d.dispose();
        }
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    public void animate(Animation anim) {
        this.animations.add(anim);
        if (this.animationThread == null || !this.animationThread.isAlive()) {
            this.animationThread = new Thread(new AnimationTask());
            this.animationThread.start();
        }
    }

    private class AnimationTask
    implements Runnable {
        private AnimationTask() {
        }

        @Override
        public void run() {
            long beforeTime;
            long startTime = beforeTime = System.currentTimeMillis();
            ArrayList<Animation> stoppedAnimations = new ArrayList<Animation>();
            while (AnimatablePanel.this.animations.iterator().hasNext()) {
                long t = System.currentTimeMillis();
                for (final Animation animation : AnimatablePanel.this.animations) {
                    long t2;
                    if (!animation.isStarted()) {
                        animation.setStartTime(startTime);
                    }
                    if (!animation.tick((t2 = System.currentTimeMillis()) - animation.getStartTime()) && t2 - animation.getStartTime() <= animation.getMaxRunTime()) continue;
                    stoppedAnimations.add(animation);
                    AnimatablePanel.this.repaint();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            animation.done();
                        }
                    });
                }
                AnimatablePanel.this.animations.removeAll(stoppedAnimations);
                stoppedAnimations.clear();
                long timeDiff = t - beforeTime;
                AnimatablePanel.this.repaint();
                long sleep = (long)AnimatablePanel.this.tickTime - timeDiff;
                if (sleep < 0L) {
                    sleep = 2L;
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                beforeTime = System.currentTimeMillis();
            }
        }
    }
}

