/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view;

import com.explodingpixels.macwidgets.MacUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.app.DashboardSectionFactory;
import org.ut.biolab.medsavant.client.view.component.StackableJPanelContainer;
import org.ut.biolab.medsavant.client.view.dashboard.AppSwitchPanel;
import org.ut.biolab.medsavant.client.view.dashboard.Dashboard;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.notify.Notification;
import org.ut.biolab.medsavant.client.view.notify.NotificationsPanel;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class MedSavantFrame
extends JFrame {
    private static Log LOG = LogFactory.getLog(MedSavantFrame.class);
    private static MedSavantFrame instance;
    private StackableJPanelContainer view;
    private Dashboard sessionDashboard;
    private static Map<String, Runnable> debugFunctions;
    private NotificationsPanel notificationPanel;

    public static void addDebugFunction(String name, Runnable r) {
        System.out.println("Adding " + name + " to debug menu");
        debugFunctions.put(name, r);
    }

    public static JMenu getDebugMenu() {
        if (debugFunctions.size() < 1) {
            return null;
        }
        JMenu menu = new JMenu("Debug");
        for (final Map.Entry<String, Runnable> e : debugFunctions.entrySet()) {
            JMenuItem debugItem = new JMenuItem(e.getKey());
            debugItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((Runnable)e.getValue()).run();
                }
            });
            menu.add(debugItem);
        }
        return menu;
    }

    public static MedSavantFrame getInstance() {
        if (instance == null) {
            instance = new MedSavantFrame();
        }
        return instance;
    }

    private MedSavantFrame() {
        super("");
        MacUtils.makeWindowLeopardStyle((JRootPane)this.getRootPane());
        UIManager.put("Panel.background", new Color(237, 237, 237));
        this.setIconImage(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.MENU_USER).getImage());
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(550, 550));
        this.view = new StackableJPanelContainer();
        this.view.setDoubleBuffered(true);
        this.view.setBackground(new Color(217, 222, 229));
        UIManager.put("ToolTip.background", Color.black);
        UIManager.put("ToolTip.foreground", Color.white);
        UIManager.put("ToolTip.border", ViewUtil.getMediumBorder());
        UIManager.put("ToolTip.font", ViewUtil.detailFontBold);
        UIManager.put("Table.gridColor", new Color(250, 250, 250));
        this.add((Component)this.view, "Center");
        LOG.info((Object)"Loading apps...");
        AppController pc = AppController.getInstance();
        pc.loadPlugins(DirectorySettings.getPluginsDirectory());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MedSavantFrame.this.requestClose();
            }
        });
    }

    public void showNotification(Notification n) {
        this.notificationPanel.addNotification(n);
    }

    public void showNotficationMessage(String notificationMsg) {
        Notification n = new Notification();
        n.setName(notificationMsg);
        this.notificationPanel.addNotification(n);
    }

    public void initializeSessionView() {
        final JPanel dashBoardContainer = ViewUtil.getClearPanel();
        this.view.push(dashBoardContainer);
        this.notificationPanel = new NotificationsPanel();
        this.view.push(this.notificationPanel);
        AppSwitchPanel switchPanel = new AppSwitchPanel(dashBoardContainer);
        this.view.push(switchPanel);
        new MedSavantWorker<Void>("MedSavantFrame"){

            @Override
            protected void showProgress(double fract) {
            }

            @Override
            protected void showSuccess(Void result) {
            }

            @Override
            protected Void doInBackground() throws Exception {
                System.out.println("Creating dashboard");
                Dashboard dash = new Dashboard();
                dash.addDashboardSection(DashboardSectionFactory.getUberSection());
                MedSavantFrame.this.sessionDashboard = dash;
                dashBoardContainer.setLayout(new BorderLayout());
                dashBoardContainer.add((Component)dash, "Center");
                dashBoardContainer.updateUI();
                return null;
            }
        }.execute();
    }

    public Dashboard getDashboard() {
        return this.sessionDashboard;
    }

    public void forceRestart() {
        this.requestRestart(false);
    }

    public void requestLogoutAndRestart() {
        this.requestRestart(true);
    }

    private void requestRestart(boolean askFirst) {
        boolean doAction;
        LOG.info((Object)"Asking to restart");
        LoginController controller = LoginController.getInstance();
        if (controller.isLoggedIn() && (doAction = askFirst ? DialogUtils.askYesNo("Sign Out", "Are you sure you want to sign out?") == 0 : true)) {
            controller.logout();
            MedSavantClient.restart();
            return;
        }
        LOG.info((Object)"Refusing to restart");
    }

    public void forceClose() {
        this.requestClose(false);
    }

    public void requestClose() {
        this.requestClose(true);
    }

    private void requestClose(boolean askFirst) {
        LOG.info((Object)"Asking to quit");
        LoginController controller = LoginController.getInstance();
        boolean doAction = askFirst ? !controller.isLoggedIn() || DialogUtils.askYesNo("Quit MedSavant", "Are you sure you want to quit?") == 0 : true;
        if (doAction) {
            controller.logout();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            LOG.info((Object)"System exiting");
            System.exit(0);
            return;
        }
        LOG.info((Object)"Refusing to quit");
    }

    public NotificationsPanel getNotificationPanel() {
        return this.notificationPanel;
    }

    static {
        debugFunctions = new HashMap<String, Runnable>();
    }
}

