/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.StandardFixableWidthAppPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

class VariantFilesDetailedView
extends DetailedView
implements BasicVariantColumns {
    private final JPanel details;
    private SimpleVariantFile[] files;
    private DetailsWorker detailsWorker;
    private final BlockingPanel blockPanel;
    private final StandardFixableWidthAppPanel canvas = new StandardFixableWidthAppPanel();

    public VariantFilesDetailedView(String page) {
        super(page);
        this.blockPanel = new BlockingPanel("No file selected", this.canvas);
        this.details = this.canvas.addBlock();
        this.blockPanel.block();
        this.setLayout(new BorderLayout());
        this.add((Component)this.blockPanel, "Center");
    }

    @Override
    public void setSelectedItem(Object[] item) {
        if (item.length == 0) {
            this.blockPanel.block();
        } else {
            this.files = new SimpleVariantFile[]{(SimpleVariantFile)item[0]};
            this.canvas.setTitle(MiscUtils.extractFileName(this.files[0].getPath()));
            this.details.removeAll();
            this.details.updateUI();
            if (this.detailsWorker != null) {
                this.detailsWorker.cancel(true);
            }
            this.detailsWorker = new DetailsWorker(this.files[0]);
            this.detailsWorker.execute();
        }
    }

    public synchronized void setFileInfoList(List<String[]> info) {
        this.details.removeAll();
        ViewUtil.setBoxYLayout(this.details);
        String[][] values = new String[info.size()][2];
        for (int i = 0; i < info.size(); ++i) {
            values[i][0] = info.get(i)[0];
            values[i][1] = info.get(i)[1];
        }
        this.details.add(ViewUtil.getKeyValuePairList(values));
        this.details.updateUI();
    }

    @Override
    public void setMultipleSelections(List<Object[]> items) {
        if (items.isEmpty()) {
            this.blockPanel.block();
        } else {
            this.files = new SimpleVariantFile[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                this.files[i] = (SimpleVariantFile)items.get(i)[0];
            }
            if (items.isEmpty()) {
                this.canvas.setTitle("");
            } else {
                this.canvas.setTitle("Multiple uploads (" + items.size() + ")");
            }
            this.details.removeAll();
            this.details.updateUI();
        }
    }

    @Override
    public JPopupMenu createPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        if (ProjectController.getInstance().getCurrentVariantTableSchema() == null) {
            popupMenu.add(new JLabel("(You must choose a variant table before filtering)"));
        } else {
            JMenuItem filter1Item = new JMenuItem("Filter by Variant File");
            filter1Item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryUtils.addQueryOnVariantFiles(VariantFilesDetailedView.this.files);
                    DialogUtils.displayMessage("Selected File has been added to query.  Click 'Variants' to review and execute search.");
                }
            });
            popupMenu.add(filter1Item);
        }
        return popupMenu;
    }

    private class DetailsWorker
    extends MedSavantWorker<List<String[]>> {
        private final SimpleVariantFile file;

        public DetailsWorker(SimpleVariantFile f) {
            super(VariantFilesDetailedView.this.getPageName());
            this.file = f;
        }

        @Override
        protected List<String[]> doInBackground() throws Exception {
            return MedSavantClient.VariantManager.getTagsForUpload(LoginController.getSessionID(), this.file.getUploadId());
        }

        @Override
        protected void showProgress(double ignored) {
        }

        @Override
        protected void showSuccess(List<String[]> result) {
            result.add(0, new String[]{"File Name", this.file.getPath()});
            result.add(1, new String[]{"Upload ID", Integer.toString(this.file.getUploadId())});
            result.add(2, new String[]{"File ID", Integer.toString(this.file.getFileId())});
            VariantFilesDetailedView.this.setFileInfoList(result);
            VariantFilesDetailedView.this.blockPanel.unblock();
        }
    }
}

