/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.variant;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ProjectWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.SimpleVariantFile;

public class RemoveVariantsWizard
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(RemoveVariantsWizard.class);
    private final int projectID = ProjectController.getInstance().getCurrentProjectID();
    private final int referenceID = ReferenceController.getInstance().getCurrentReferenceID();
    private final List<SimpleVariantFile> files;
    private JTextField emailField;
    private JCheckBox autoPublish;

    public RemoveVariantsWizard(List<SimpleVariantFile> files) {
        this.files = files;
        this.setTitle("Remove Variants Wizard");
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getWelcomePage());
        model.append((AbstractDialogPage)this.getNotificationsPage());
        model.append((AbstractDialogPage)this.getQueuePage());
        model.append((AbstractDialogPage)this.getCompletePage());
        this.setPageList(model);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private AbstractWizardPage getWelcomePage() {
        DefaultWizardPage page = new DefaultWizardPage("Remove Variants"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        String projectName = ProjectController.getInstance().getCurrentProjectName();
        String referenceName = ReferenceController.getInstance().getCurrentReferenceName();
        page.addText("This wizard will help you remove the following variant files from \nproject " + projectName + " and reference " + referenceName + ": ");
        for (SimpleVariantFile f : this.files) {
            JLabel nameLabel = new JLabel(f.getPath());
            nameLabel.setFont(ViewUtil.getMediumTitleFont());
            page.addComponent((JComponent)nameLabel);
        }
        return page;
    }

    private AbstractWizardPage getQueuePage() {
        return new DefaultWizardPage("Remove & Publish Variants"){
            private final JLabel progressLabel;
            private final JButton workButton;
            {
                this.progressLabel = new JLabel("You are now ready to remove variants.");
                this.workButton = new JButton("Remove Files");
                this.addComponent(this.progressLabel);
                this.addComponent(ViewUtil.alignRight(this.workButton));
                final JLabel j = new JLabel("<html>You may continue. The removal process will continue in the<br>background and you will be notified upon completion.</html>");
                this.addComponent(j);
                j.setVisible(false);
                this.workButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        j.setVisible(true);
                        this.fireButtonEvent(3299, "NEXT");
                        this.fireButtonEvent(3301, "NEXT");
                        workButton.setEnabled(false);
                        new ProjectWorker<Void>("Removing variants", RemoveVariantsWizard.this.autoPublish.isSelected(), LoginController.getSessionID(), RemoveVariantsWizard.this.projectID){

                            @Override
                            protected Void runInBackground() throws Exception {
                                MedSavantClient.VariantManager.removeVariants(LoginController.getSessionID(), RemoveVariantsWizard.this.projectID, RemoveVariantsWizard.this.referenceID, RemoveVariantsWizard.this.files, RemoveVariantsWizard.this.autoPublish.isSelected(), RemoveVariantsWizard.this.emailField.getText());
                                return null;
                            }
                        }.execute();
                        RemoveVariantsWizard.this.toFront();
                    }
                });
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3300, "NEXT");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCompletePage() {
        CompletionWizardPage page = new CompletionWizardPage("Complete"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
        page.addText("You have finished requesting variant file removal.");
        return page;
    }

    private AbstractWizardPage getNotificationsPage() {
        DefaultWizardPage page = new DefaultWizardPage("Notifications"){

            public void setupWizardButtons() {
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
        page.addText("Project modification may take some time. Enter your email address to be notified when the process completes.");
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(p);
        JLabel l = new JLabel("Email: ");
        this.emailField = new JTextField();
        p.add(l);
        p.add(this.emailField);
        page.addComponent((JComponent)p);
        this.autoPublish = new JCheckBox("Automatically publish data upon import completion");
        this.autoPublish.setSelected(true);
        page.addComponent((JComponent)this.autoPublish);
        page.addText("If you choose not to automatically publish, you will be prompted to publish manually upon completion. Variant publication logs all users out.");
        return page;
    }
}

