/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ut.biolab.medsavant.client.util.CacheController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.Modifier;

public class ServerModificationInvocationHandler<T>
implements InvocationHandler {
    private final T proxiedInterface;

    public ServerModificationInvocationHandler(T proxiedInterface) {
        this.proxiedInterface = proxiedInterface;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object m = method.invoke(this.proxiedInterface, args);
            if (method.isAnnotationPresent(Modifier.class)) {
                Modifier modifier = method.getAnnotation(Modifier.class);
                CacheController.getInstance().expire(modifier.type(), Thread.currentThread().getId());
            }
            return m;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getCause();
            }
            if (e instanceof SessionExpiredException) {
                SessionExpiredException see = (SessionExpiredException)e;
                MedSavantExceptionHandler.handleSessionExpiredException(see);
                return null;
            }
            throw e;
        }
    }
}

