/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.VisibleMedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;

public abstract class ProjectWorker<T>
extends VisibleMedSavantWorker<T> {
    private static final Log LOG = LogFactory.getLog(ProjectWorker.class);
    protected int notificationId;
    private boolean autoPublish;
    private String shortSuccessMessage = "Done.";
    private String longSuccessMessage;
    private String sessionID;
    private int projectID;

    public ProjectWorker(String pageName, String notificationTitle, boolean autoPublish, String sessionID, int projectID) {
        super(pageName, notificationTitle);
        this.autoPublish = autoPublish;
        this.projectID = projectID;
        this.sessionID = sessionID;
        this.setIndeterminate(true);
        this.showResultsOnFinish(false);
    }

    public ProjectWorker(String name, boolean autoPublish, String sessionID, int projectID) {
        this(name, name, autoPublish, sessionID, projectID);
    }

    public boolean isAutoPublish() {
        return this.autoPublish;
    }

    private String getLongSuccessMessage() {
        if (this.longSuccessMessage == null) {
            this.longSuccessMessage = this.autoPublish ? this.getTitle() + " was successful. MedSavant will now close." : this.getTitle() + " was successful. Changes have not yet been published.";
        }
        return this.longSuccessMessage;
    }

    @Override
    protected void jobDone() {
        this.setStatus(VisibleMedSavantWorker.JobStatus.FINISHED);
        this.setStatusMessage(this.shortSuccessMessage);
        if (this.autoPublish) {
            DialogUtils.displayMessage(this.getLongSuccessMessage());
            MedSavantFrame.getInstance().forceRestart();
        } else {
            MedSavantFrame.getInstance().showNotficationMessage(this.getLongSuccessMessage());
        }
    }
}

