/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ut.biolab.medsavant.client.util.CustomFieldConstraint;
import org.ut.biolab.medsavant.client.util.EnumConstraint;
import org.ut.biolab.medsavant.client.util.RegexpConstraint;
import org.ut.biolab.medsavant.shared.format.CustomField;

public abstract class FormController {
    private CustomField[] fields;
    private Map<String, CustomFieldConstraint> constraints = new HashMap<String, CustomFieldConstraint>();
    private Set<String> enumColumns;
    private String autoIncKey;

    public FormController(CustomField[] fields, CustomField autoIncKey) {
        this.fields = fields;
        this.autoIncKey = autoIncKey != null ? autoIncKey.getColumnName() : null;
        for (CustomField f : fields) {
            this.addDefaultConstraint(f);
        }
    }

    public final boolean isValid(CustomField cf, String val, String[] err) {
        CustomFieldConstraint cfc = this.constraints.get(cf.getColumnName());
        if (cfc != null) {
            boolean ret = cfc.isValid(val);
            if (!ret && err != null) {
                err[0] = cfc.getErrorMessage();
            }
            return ret;
        }
        return true;
    }

    public final boolean isValid(CustomField cf, String val) {
        return this.isValid(cf, val, null);
    }

    public final String[][] allowedValues(CustomField cf) {
        if (this.enumColumns != null && this.enumColumns.contains(cf.getColumnName())) {
            EnumConstraint ec = (EnumConstraint)this.constraints.get(cf.getColumnName());
            return ec.getAllowedValues();
        }
        return null;
    }

    public abstract void submitForm(List<CustomField> var1, List<String> var2);

    public CustomField[] getFields() {
        return this.fields;
    }

    public boolean isAutoInc(CustomField f) {
        return this.autoIncKey != null && this.autoIncKey.equalsIgnoreCase(f.getColumnName());
    }

    protected final void addDefaultConstraint(CustomField cf) {
        String cn = cf.getAlias();
        switch (cf.getColumnType()) {
            case BOOLEAN: {
                String errMsg = cn + " is not a valid true/false value";
                this.setConstraint(cf.getColumnName(), new EnumConstraint(new String[][]{{"1", "True"}, {"0", "False"}}, cf.getColumnLength(), errMsg));
                break;
            }
            case INTEGER: {
                String errMsg = cn + " is not a valid integer";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("^[0-9]+$", cf.getColumnLength(), errMsg));
                break;
            }
            case DATE: {
                String errMsg = cn + " is not a valid date";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("^((19|20)\\\\d\\\\d)-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01])$", cf.getColumnLength(), errMsg));
                break;
            }
            case DECIMAL: {
                String errMsg = cn + " is not a valid decimal value";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("(\\+|-)?([0-9]*(\\.[0-9]+))", cf.getColumnLength(), errMsg));
                break;
            }
            case FLOAT: {
                String errMsg = cn + " is not a valid decimal value";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("(\\+|-)?([0-9]*(\\.[0-9]+))", cf.getColumnLength(), errMsg));
                break;
            }
            case VARCHAR: {
                String errMsg = cn + " is not a valid string";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("(?s)^.*$", cf.getColumnLength(), errMsg));
                break;
            }
            case TEXT: {
                String errMsg = cn + " is not a valid string";
                this.setConstraint(cf.getColumnName(), (CustomFieldConstraint)new RegexpConstraint("(?s)^.*$", cf.getColumnLength(), errMsg));
            }
        }
    }

    protected final void setRequiredFields(CustomField[] fields) {
        for (CustomField f : fields) {
            this.setRequiredField(f);
        }
    }

    protected final void setRequiredField(CustomField cf) {
        String columnName = cf.getColumnName();
        CustomFieldConstraint cfc = this.constraints.get(columnName);
        if (cfc != null) {
            cfc.setRequired(true);
        } else {
            cfc = new CustomFieldConstraint(true, cf.getColumnLength());
        }
        this.constraints.put(columnName, cfc);
    }

    protected final void setConstraint(CustomField cf, CustomFieldConstraint cfc) {
        this.setConstraint(cf.getColumnName(), cfc);
    }

    protected final void setConstraint(CustomField cf, EnumConstraint ec) {
        this.setConstraint(cf.getColumnName(), ec);
    }

    private void setConstraint(String colName, CustomFieldConstraint cfc) {
        this.constraints.put(colName, cfc);
    }

    private void setConstraint(String colName, EnumConstraint ec) {
        this.setConstraint(colName, (CustomFieldConstraint)ec);
        if (this.enumColumns == null) {
            this.enumColumns = new HashSet<String>();
        }
        this.enumColumns.add(colName);
    }
}

