/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.db.ColumnType;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.AnnotationFormat;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class ExportVCF
implements BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(ExportVCF.class);
    private static int INTERMEDIATE_INDEX_DNA_ID = 0;
    private static int INTERMEDIATE_INDEX_GENOTYPE = 1;
    private static int INTERMEDIATE_INDEX_CHROM = 2;
    private static int INTERMEDIATE_INDEX_POSITION = 3;
    private static int INTERMEDIATE_INDEX_DBSNP = 4;
    private static int INTERMEDIATE_INDEX_REF = 5;
    private static int INTERMEDIATE_INDEX_ALT = 6;
    private static int INTERMEDIATE_INDEX_QUAL = 7;
    private static int INTERMEDIATE_INDEX_FILTER = 8;
    private static int INTERMEDIATE_INDEX_CUSTOM = 9;

    public static File exportTDF(File destFile) throws Exception {
        return ExportVCF.exportTDF(destFile, null, FilterController.getInstance().getAllFilterConditions());
    }

    public static File exportVCF(File destFile) throws Exception {
        return ExportVCF.exportVCF(destFile, null, FilterController.getInstance().getAllFilterConditions());
    }

    public static File exportTDF(File destFile, MedSavantWorker worker, Condition[][] conditions) throws Exception {
        File resultingFile;
        System.out.println("Requesting table export from server...");
        int fileID = MedSavantClient.VariantManager.exportVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditions, false, true);
        if (worker != null) {
            if (worker.isCancelled()) {
                throw new InterruptedException();
            }
            worker.showProgress(0.5);
        }
        System.out.println("Transferring export from server to " + destFile.getAbsolutePath() + " ...");
        ClientNetworkUtils.moveFileFromServer(fileID, destFile);
        System.out.println("Table transferred");
        if (IOUtils.isZipped(destFile)) {
            resultingFile = IOUtils.unzipFile(destFile, destFile.getParentFile().getAbsolutePath()).get(0);
            destFile.delete();
        } else {
            resultingFile = destFile;
        }
        if (worker != null) {
            worker.showProgress(1.0);
        }
        return resultingFile;
    }

    public static File exportVCF(File destFile, MedSavantWorker worker, Condition[][] conditions) throws Exception {
        String line;
        int fileID = MedSavantClient.VariantManager.exportVariants(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), conditions, true, false);
        if (worker != null) {
            if (worker.isCancelled()) {
                throw new InterruptedException();
            }
            worker.showProgress(0.5);
        }
        LOG.info((Object)("Copying file " + fileID + " from sever to " + destFile.getAbsolutePath()));
        ClientNetworkUtils.moveFileFromServer(fileID, destFile);
        LOG.info((Object)("Done copying file to " + destFile));
        HashMap<String, BufferedWriter> out = new HashMap<String, BufferedWriter>();
        HashMap<String, File> files = new HashMap<String, File>();
        ArrayList<String> chrs = new ArrayList<String>();
        HashSet<String> dnaIds = new HashSet<String>();
        TableSchema table = ProjectController.getInstance().getCurrentVariantTableSchema();
        String[] customColumnNames = new String[table.getNumFields() - 16 - 1];
        List<DbColumn> allColumns = table.getColumns();
        for (int i = 17; i < table.getNumFields(); ++i) {
            customColumnNames[i - 1 - 16] = allColumns.get(i).getColumnNameSQL().toUpperCase();
        }
        int infoMin = 17;
        int infoMax = table.getNumFields();
        BufferedReader in = new BufferedReader(new FileReader(destFile));
        double numSteps = ReferenceController.getInstance().getChromosomes().length * 6;
        while ((line = in.readLine()) != null) {
            String[] record = line.split("\t");
            String row = "";
            String dnaId = ExportVCF.cleanField(record[3]);
            row = row + dnaId + "\t";
            dnaIds.add(dnaId);
            row = row + ExportVCF.cleanField(record[15]) + "\t";
            row = row + ExportVCF.cleanField(record[4]) + "\t" + ExportVCF.cleanField(record[5]) + "\t" + ExportVCF.parseMandatoryField(ExportVCF.cleanField(record[7])) + "\t" + ExportVCF.parseMandatoryField(ExportVCF.cleanField(record[8])) + "\t" + ExportVCF.parseMandatoryField(ExportVCF.cleanField(record[9])) + "\t" + ExportVCF.parseMandatoryField(ExportVCF.cleanField(record[11])) + "\t" + ExportVCF.parseMandatoryField(ExportVCF.cleanField(record[12])) + "\t";
            for (int j = infoMin; j < infoMax; ++j) {
                if (j < record.length) {
                    row = row + ExportVCF.cleanField(record[j]);
                }
                if (j == infoMax - 1) continue;
                row = row + "\t";
            }
            BufferedWriter writer = (BufferedWriter)out.get(ExportVCF.cleanField(record[4]));
            if (writer == null) {
                String chrom = ExportVCF.cleanField(record[4]);
                File f = new File(DirectorySettings.getTmpDirectory() + File.separator + destFile.getName() + chrom);
                writer = new BufferedWriter(new FileWriter(f, false));
                out.put(chrom, writer);
                chrs.add(chrom);
                files.put(chrom, f);
                if (worker != null) {
                    worker.showProgress((double)files.size() / numSteps + 0.5);
                }
            }
            writer.write(row + "\n");
            if (worker == null || !worker.isCancelled()) continue;
            throw new InterruptedException();
        }
        for (String key : out.keySet()) {
            ((BufferedWriter)out.get(key)).close();
        }
        Collections.sort(chrs, new ChromosomeComparator());
        File temp1 = new File(DirectorySettings.getTmpDirectory() + File.separator + destFile.getName() + "_complete");
        for (int i = 0; i < files.size(); ++i) {
            ExportVCF.copyFile((File)files.get(chrs.get(i)), temp1, i != 0);
            if (worker == null) continue;
            if (worker.isCancelled()) {
                throw new InterruptedException();
            }
            worker.showProgress((double)(i + files.size()) / numSteps + 0.5);
        }
        ExportVCF.mergeVCF(temp1, destFile, dnaIds, customColumnNames);
        if (worker != null) {
            worker.showProgress(1.0);
        }
        return destFile;
    }

    private static String parseMandatoryField(String s) {
        return s == null || s.length() == 0 ? "." : s;
    }

    private static String cleanField(String s) {
        if (s.startsWith("\"") && s.length() >= 2) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static void copyFile(File sourceFile, File destFile, boolean append) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(sourceFile);
        FileOutputStream out = new FileOutputStream(destFile, append);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private static void mergeVCF(File inFile, File outFile, Set<String> dnaIdsSet, String[] customColumnNames) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile, false));
        Object[] dnaIds = dnaIdsSet.toArray();
        HashMap<String, Integer> idToPosition = new HashMap<String, Integer>();
        Integer i = 0;
        while (i < dnaIds.length) {
            idToPosition.put((String)dnaIds[i], i);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        Boolean[] flagColumns = new Boolean[customColumnNames.length];
        ExportVCF.clearArray(flagColumns, false);
        int pos = 0;
        AnnotationFormat[] formats = ProjectController.getInstance().getCurrentAnnotationFormats();
        for (int i2 = 1; i2 < formats.length; ++i2) {
            for (CustomField f : formats[i2].getCustomFields()) {
                if (f.getColumnType() == ColumnType.BOOLEAN) {
                    flagColumns[pos] = true;
                }
                ++pos;
            }
        }
        out.write(ExportVCF.createHeader(dnaIds));
        String lastChr = "";
        String lastPos = "";
        Boolean[] dnaMatches = new Boolean[dnaIds.length];
        Boolean[] columnMatches = new Boolean[2 + customColumnNames.length];
        String[][] records = new String[dnaIds.length][];
        String[] record = null;
        Boolean[] availableIds = new Boolean[dnaIds.length];
        ExportVCF.clearArray(records);
        ExportVCF.clearArray(availableIds, false);
        while (true) {
            String line;
            if ((line = in.readLine()) != null) {
                record = line.split("\t");
            }
            if (line == null || !lastPos.equals(record[INTERMEDIATE_INDEX_POSITION]) || !lastChr.equals(record[INTERMEDIATE_INDEX_CHROM])) {
                for (int i3 = 0; i3 < dnaIds.length; ++i3) {
                    int col;
                    ExportVCF.clearArray(dnaMatches, false);
                    ExportVCF.clearArray(columnMatches, true);
                    String[] row1 = records[i3];
                    if (!availableIds[i3].booleanValue() || row1 == null) continue;
                    dnaMatches[i3] = true;
                    for (int j = i3 + 1; j < dnaIds.length; ++j) {
                        String[] row2 = records[j];
                        if (!availableIds[j].booleanValue() || row2 == null || !ExportVCF.compareRows(row1, row2)) continue;
                        dnaMatches[j] = true;
                        ExportVCF.determineMatches(columnMatches, row1, row2);
                        availableIds[j] = false;
                    }
                    String output = "";
                    for (col = INTERMEDIATE_INDEX_CHROM; col < INTERMEDIATE_INDEX_QUAL; ++col) {
                        output = output + row1[col] + "\t";
                    }
                    for (col = INTERMEDIATE_INDEX_QUAL; col < INTERMEDIATE_INDEX_CUSTOM; ++col) {
                        output = columnMatches[col - INTERMEDIATE_INDEX_QUAL] != false ? output + row1[col] : output + ".";
                        output = output + "\t";
                    }
                    for (col = INTERMEDIATE_INDEX_CUSTOM; col < row1.length; ++col) {
                        if (!columnMatches[col - INTERMEDIATE_INDEX_QUAL].booleanValue() || row1[col].equals("")) continue;
                        if (flagColumns[col - INTERMEDIATE_INDEX_CUSTOM].booleanValue() && row1[col].equals("1")) {
                            output = output + customColumnNames[col - INTERMEDIATE_INDEX_CUSTOM] + ";";
                            continue;
                        }
                        if (flagColumns[col - INTERMEDIATE_INDEX_CUSTOM].booleanValue()) continue;
                        output = output + customColumnNames[col - INTERMEDIATE_INDEX_CUSTOM] + "=" + row1[col] + ";";
                    }
                    output = output + "\t";
                    output = output + "GT\t";
                    for (int id = 0; id < dnaIds.length; ++id) {
                        output = dnaMatches[id] != false ? output + records[id][INTERMEDIATE_INDEX_GENOTYPE] : output + ".";
                        if (id == dnaIds.length - 1) continue;
                        output = output + "\t";
                    }
                    out.write(output + "\n");
                }
                ExportVCF.clearArray(records);
                ExportVCF.clearArray(availableIds, false);
            }
            if (line == null) break;
            String dnaId = record[INTERMEDIATE_INDEX_DNA_ID];
            records[((Integer)idToPosition.get((Object)dnaId)).intValue()] = record;
            availableIds[((Integer)idToPosition.get((Object)dnaId)).intValue()] = true;
            lastChr = record[INTERMEDIATE_INDEX_CHROM];
            lastPos = record[INTERMEDIATE_INDEX_POSITION];
        }
        in.close();
        out.close();
    }

    private static boolean compareRows(String[] row1, String[] row2) {
        if (row1.length != row2.length) {
            return false;
        }
        for (int i = INTERMEDIATE_INDEX_DBSNP; i < INTERMEDIATE_INDEX_QUAL; ++i) {
            if (row1[i].equals(row2[i])) continue;
            return false;
        }
        return true;
    }

    private static void clearArray(String[][] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    private static void clearArray(Boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = value;
        }
    }

    private static void determineMatches(Boolean[] matches, String[] row1, String[] row2) {
        for (int i = INTERMEDIATE_INDEX_DBSNP; i < row1.length; ++i) {
            if (row1[i].equals(row2[i])) continue;
            matches[i - ExportVCF.INTERMEDIATE_INDEX_QUAL] = false;
        }
    }

    private static String createHeader(Object[] dnaIds) throws Exception {
        int i;
        String header = "";
        header = header + "##fileformat=VCFv4.0\n";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        header = header + "##fileDate=" + sdf.format(cal.getTime()) + "\n";
        header = header + "##reference=" + ReferenceController.getInstance().getCurrentReferenceName() + "\n";
        AnnotationFormat[] annotationFormats = ProjectController.getInstance().getCurrentAnnotationFormats();
        for (i = 1; i < annotationFormats.length; ++i) {
            AnnotationFormat af = annotationFormats[i];
            for (CustomField field : af.getCustomFields()) {
                header = header + "##INFO=<ID=" + field.getColumnName().toUpperCase() + ",";
                switch (field.getColumnType()) {
                    case INTEGER: {
                        header = header + "Number=1,Type=Integer";
                        break;
                    }
                    case FLOAT: {
                        header = header + "Number=1,Type=Float";
                        break;
                    }
                    case BOOLEAN: {
                        header = header + "Number=0,Type=Flag";
                        break;
                    }
                    default: {
                        header = header + "Number=1,Type=String";
                    }
                }
                header = header + ",Description=\"" + field.getDescription() + "\">\n";
            }
        }
        header = header + "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">\n";
        header = header + "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT\t";
        for (i = 0; i < dnaIds.length; ++i) {
            header = header + (String)dnaIds[i];
            if (i == dnaIds.length - 1) continue;
            header = header + "\t";
        }
        header = header + "\n";
        return header;
    }
}

