/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.util;

import org.ut.biolab.medsavant.client.util.CustomFieldConstraint;

public class EnumConstraint
extends CustomFieldConstraint {
    private String[][] allowedValues;

    public EnumConstraint(String[][] allowedValues, int maxlength, String errorMessage) {
        super(true, maxlength, errorMessage);
        this.allowedValues = allowedValues;
    }

    public EnumConstraint(String[][] allowedValues, int maxlength) {
        this(allowedValues, maxlength, null);
    }

    public String[][] getAllowedValues() {
        return this.allowedValues;
    }

    @Override
    public boolean isValid(String val) {
        if (super.isValid(val)) {
            for (String[] allowed : this.allowedValues) {
                if (!val.equalsIgnoreCase(allowed[0])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setRequired(boolean required) {
    }
}

