/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.user;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.user.UserController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.component.field.editable.EditableFieldValidator;
import org.ut.biolab.medsavant.component.field.editable.EnumEditableField;
import org.ut.biolab.medsavant.component.field.editable.PasswordEditableField;
import org.ut.biolab.medsavant.component.field.editable.StringEditableField;
import org.ut.biolab.medsavant.component.field.validator.NonEmptyStringValidator;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;

public class CreateUserDialog
extends JDialog {
    private static final Log LOG = LogFactory.getLog(CreateUserDialog.class);

    public CreateUserDialog() {
        super(DialogUtils.getFrontWindow(), "Create User", Dialog.ModalityType.APPLICATION_MODAL);
        this.setLocationRelativeTo(MedSavantFrame.getInstance());
        this.initComponents();
    }

    private void initComponents() {
        KeyValuePairPanel userKVP = new KeyValuePairPanel(1);
        final StringEditableField usernameField = new StringEditableField();
        usernameField.setValidator((EditableFieldValidator)new NonEmptyStringValidator());
        final PasswordEditableField passwordField = new PasswordEditableField();
        passwordField.setValidator((EditableFieldValidator)new NonEmptyStringValidator("password"));
        final EnumEditableField userlevelField = new EnumEditableField((Object[])new UserLevel[]{UserLevel.GUEST, UserLevel.USER, UserLevel.ADMIN});
        userlevelField.setValue((Object)UserLevel.USER);
        JButton userLevelButton = ViewUtil.getHelpButton("User Levels", "<html><b>Guests</b> have read-only access<br/><br/><b>Users</b> may upload variants and edit patients<br/><br/><b>Administrators</b> may upload variants, edit patients, manage users, and configure projects</html>", true);
        userKVP.addKeyWithValue("Username", (JComponent)usernameField);
        userKVP.addKeyWithValue("Password", (JComponent)passwordField);
        userKVP.addKeyWithValue("User Level", (JComponent)userlevelField);
        this.setBackground(ViewUtil.getDefaultBackgroundColor());
        JPanel padded = ViewUtil.getClearPanel();
        padded.setLayout((LayoutManager)new MigLayout("filly, fillx"));
        padded.add((Component)userKVP, "growx 1.0, growy 1.0");
        this.setLayout(new BorderLayout());
        this.add((Component)padded, "North");
        JPanel bottom = ViewUtil.getClearPanel();
        bottom.setBorder(ViewUtil.getTopLineBorder());
        this.add((Component)bottom, "South");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setFocusable(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateUserDialog.this.dispose();
            }
        });
        JButton createButton = new JButton("Create");
        createButton.setFocusable(false);
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (usernameField.validateCurrentValue() && passwordField.validateCurrentValue()) {
                    try {
                        if (MedSavantClient.UserManager.userExists(LoginController.getSessionID(), (String)usernameField.getValue())) {
                            DialogUtils.displayMessage("User already exists.");
                        } else {
                            UserController.getInstance().addUser((String)usernameField.getValue(), ((String)passwordField.getValue()).toCharArray(), (UserLevel)((Object)userlevelField.getValue()));
                            DialogUtils.displayMessage("User Added", String.format("<html>Added user <i>%s</i></html>", usernameField.getValue()));
                            CreateUserDialog.this.dispose();
                        }
                    }
                    catch (SessionExpiredException ex) {
                        MedSavantExceptionHandler.handleSessionExpiredException(ex);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        DialogUtils.displayException("Error adding user", "", ex);
                    }
                }
            }
        });
        bottom.setLayout((LayoutManager)new MigLayout("insets 0, fillx, nogrid"));
        bottom.add((Component)cancelButton, "right");
        bottom.add((Component)createButton, "right");
        this.setSize(new Dimension(360, 200));
    }

    public static void main(String[] argv) {
        CreateUserDialog cug = new CreateUserDialog();
        cug.setVisible(true);
    }
}

