/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.settings;

import java.io.File;
import java.util.GregorianCalendar;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;

public class DirectorySettings {
    private static final String CACHE_DIR_KEY = "CacheDir";
    private static final String TMP_DIR_KEY = "TmpDir";
    private static final String PLUGINS_DIR_KEY = "PluginsDir";
    private static final String FILTERS_DIR_KEY = "FiltersDir";
    private static final String GENEMANIA_DIR_KEY = "GeneManiaDir";
    public static final String GENEMANIA_CHECK_FILE = "gmdataOK.txt";
    private static File medSavantDir;
    private static SettingsController settings;

    public static boolean isGeneManiaInstalled() {
        return new File(DirectorySettings.getGeneManiaDirectory(), GENEMANIA_CHECK_FILE).exists();
    }

    public static File getMedSavantDirectory() {
        if (medSavantDir == null) {
            File f = new File(System.getProperty("user.home"), ClientMiscUtils.WINDOWS ? "medsavant" : ".medsavant");
            if (!f.exists()) {
                f.mkdir();
            }
            medSavantDir = f;
        }
        return medSavantDir;
    }

    private static File getDirectory(String key, String dirName) {
        File result = settings.getFile(key);
        if (result == null) {
            result = new File(DirectorySettings.getMedSavantDirectory(), dirName);
        }
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private static void setDirectory(String key, File value) {
        if (!value.exists()) {
            value.mkdirs();
        }
        settings.setFile(key, value);
    }

    public static File getGeneManiaDirectory() {
        return DirectorySettings.getDirectory(GENEMANIA_DIR_KEY, "cache" + File.separator + "gmdata");
    }

    public static File getPluginsDirectory() {
        return DirectorySettings.getDirectory(PLUGINS_DIR_KEY, "plugins");
    }

    public static File getTmpDirectory() {
        return DirectorySettings.getDirectory(TMP_DIR_KEY, "tmp");
    }

    public static File getCacheDirectory() {
        return DirectorySettings.getDirectory(CACHE_DIR_KEY, "cache");
    }

    public static File getFiltersDirectory() {
        return DirectorySettings.getDirectory(FILTERS_DIR_KEY, "filters");
    }

    public static File generateDateStampDirectory(File parent) {
        GregorianCalendar today = new GregorianCalendar();
        String dateStamp = today.get(1) + "-" + today.get(2) + "-" + today.get(5) + "-" + today.get(11) + "-" + today.get(12);
        File dir = new File(parent, dateStamp);
        dir.mkdirs();
        return dir;
    }

    public static File getDirectoryForPlugin(String pluginName) {
        File dir = new File(DirectorySettings.getMedSavantDirectory(), pluginName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    static {
        settings = SettingsController.getInstance();
    }
}

