/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.region;

import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.region.AdHocRegionSet;
import org.ut.biolab.medsavant.client.region.RegionEvent;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.importing.FileFormat;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.RegionSet;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class RegionController
extends Controller<RegionEvent> {
    private static RegionController instance;
    public static final String AD_HOC_REGION_SET_NAME = "Selected Regions";
    private List<AdHocRegionSet> localRegionSets = new ArrayList<AdHocRegionSet>();

    public static RegionController getInstance() {
        if (instance == null) {
            instance = new RegionController();
        }
        return instance;
    }

    public void addRegionSet(String regionSetName, char delim, FileFormat fileFormat, int numHeaderLines, int fileID) throws IOException, SQLException, RemoteException {
        try {
            MedSavantClient.RegionSetManager.addRegionSet(LoginController.getSessionID(), regionSetName, ReferenceController.getInstance().getCurrentReferenceID(), delim, fileFormat, numHeaderLines, fileID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new RegionEvent(RegionEvent.Type.ADDED));
    }

    public void removeSet(int setID) throws SQLException, RemoteException {
        try {
            MedSavantClient.RegionSetManager.removeRegionSet(LoginController.getSessionID(), setID);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new RegionEvent(RegionEvent.Type.REMOVED));
    }

    public List<RegionSet> getRegionSets() throws SQLException, RemoteException {
        ArrayList<RegionSet> result = new ArrayList<RegionSet>();
        try {
            result.addAll(MedSavantClient.RegionSetManager.getRegionSets(LoginController.getSessionID()));
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
        result.addAll(this.localRegionSets);
        return result;
    }

    public List<GenomicRegion> getRegionsInSet(RegionSet set) throws SQLException, RemoteException {
        if (set instanceof AdHocRegionSet) {
            return ((AdHocRegionSet)set).regions;
        }
        try {
            return MedSavantClient.RegionSetManager.getRegionsInSet(LoginController.getSessionID(), set);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return null;
        }
    }

    public List<GenomicRegion> getRegionsInSets(Collection<RegionSet> sets) throws SQLException, RemoteException {
        HashSet<RegionSet> setsSet = new HashSet<RegionSet>();
        setsSet.addAll(sets);
        ArrayList<GenomicRegion> result = new ArrayList<GenomicRegion>();
        for (AdHocRegionSet r : this.localRegionSets) {
            if (!setsSet.contains(r)) continue;
            result.addAll(r.regions);
            setsSet.remove(r);
        }
        if (!setsSet.isEmpty()) {
            try {
                result.addAll(MedSavantClient.RegionSetManager.getRegionsInSets(LoginController.getSessionID(), setsSet));
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }
        return result;
    }

    public void addToRegionSet(RegionSet set, String chrom, int start, int end, String desc) throws SQLException, RemoteException {
        try {
            MedSavantClient.RegionSetManager.addToRegionSet(LoginController.getSessionID(), set, ReferenceController.getInstance().getCurrentReferenceID(), chrom, start, end, desc);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return;
        }
        this.fireEvent(new RegionEvent(RegionEvent.Type.ADDED));
    }

    public RegionSet createAdHocRegionSet(String name, List<GenomicRegion> r) {
        this.localRegionSets.clear();
        AdHocRegionSet result = new AdHocRegionSet(name, r);
        this.localRegionSets.add(result);
        this.fireEvent(new RegionEvent(RegionEvent.Type.ADDED));
        return result;
    }
}

