/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.reference;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.serverapi.ReferenceManagerAdapter;

public class NewReferenceDialog
extends JDialog {
    private final ReferenceManagerAdapter manager = MedSavantClient.ReferenceManager;
    private DefaultTableModel model;
    private JLabel addRowButton;
    private JButton cancelButton;
    private JLabel clearButton;
    private JTextField nameField;
    private JButton okButton;
    private JTable table;
    private JTextField urlField;

    public NewReferenceDialog() {
        super(DialogUtils.getFrontWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Create a Reference");
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.okButton);
        ClientMiscUtils.registerCancelButton(this.cancelButton);
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        this.model.addColumn("Contig Name");
        this.model.addColumn("Length");
        this.model.addColumn("Centromere Position");
        for (Chromosome c : Chromosome.getHG19Chromosomes()) {
            this.model.addRow(new Object[]{c.getName(), c.getLength(), c.getCentromerePos()});
        }
        this.table.setModel(this.model);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.addRowButton.setCursor(new Cursor(12));
        this.addRowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewReferenceDialog.this.addRow();
            }
        });
        this.clearButton.setCursor(new Cursor(12));
        this.clearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NewReferenceDialog.this.clearTable();
            }
        });
    }

    private void addRow() {
        this.model.addRow(new Object[3]);
        this.table.setModel(this.model);
    }

    private void clearTable() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int j = 0; j < this.model.getColumnCount(); ++j) {
                this.model.setValueAt(null, i, j);
            }
        }
        this.table.setModel(this.model);
    }

    private Chromosome[] getChroms() throws NumberFormatException, Exception {
        ArrayList<Chromosome> result = new ArrayList<Chromosome>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            String name = (String)this.model.getValueAt(i, 0);
            if (name == null || name.equals("")) continue;
            if (names.contains(name)) {
                throw new Exception();
            }
            int length = Integer.parseInt(this.model.getValueAt(i, 1).toString());
            int centromere = Integer.parseInt(this.model.getValueAt(i, 2).toString());
            if (centromere > length) {
                throw new Exception();
            }
            names.add(name);
            result.add(new Chromosome(name, centromere, length));
        }
        return result.toArray(new Chromosome[0]);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        JSeparator jSeparator1 = new JSeparator();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        JLabel jLabel2 = new JLabel();
        this.clearButton = new JLabel();
        this.addRowButton = new JLabel();
        JLabel jLabel3 = new JLabel();
        this.urlField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        jLabel1.setText("Reference Name: ");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewReferenceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewReferenceDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane1.setViewportView(this.table);
        jLabel2.setText("Contig Information:");
        this.clearButton.setFont(new Font("Tahoma", 1, 11));
        this.clearButton.setHorizontalAlignment(4);
        this.clearButton.setText("clear");
        this.addRowButton.setFont(new Font("Tahoma", 1, 11));
        this.addRowButton.setHorizontalAlignment(4);
        this.addRowButton.setText("add row");
        jLabel3.setText("Sequence URL (optional):");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.nameField, -1, 332, Short.MAX_VALUE).add((Component)jLabel1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.okButton).addPreferredGap(1).add((Component)this.cancelButton)).add((Component)jLabel3, -2, 272, -2).add((Component)this.urlField, -1, 332, Short.MAX_VALUE).add((Component)jScrollPane1, -1, 332, Short.MAX_VALUE).add((Component)jSeparator1, -1, 332, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)jLabel2, -2, 166, -2).addPreferredGap(0, 57, Short.MAX_VALUE).add((Component)this.addRowButton, -2, 64, -2).addPreferredGap(0).add((Component)this.clearButton, -2, 37, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)jLabel1).addPreferredGap(0).add((Component)this.nameField, -2, -1, -2).addPreferredGap(0).add((Component)jLabel3).addPreferredGap(0).add((Component)this.urlField, -2, -1, -2).addPreferredGap(1).add((Component)jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)jLabel2).add((Component)this.clearButton).add((Component)this.addRowButton)).addPreferredGap(0).add((Component)jScrollPane1, -2, 338, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            String referenceName = this.nameField.getText();
            String referenceURL = this.urlField.getText();
            Chromosome[] chroms = this.getChroms();
            if (referenceName == null || referenceName.equals("")) {
                DialogUtils.displayMessage("Reference name required");
            } else if (this.manager.containsReference(LoginController.getSessionID(), referenceName)) {
                DialogUtils.displayMessage("Reference already exists");
            } else {
                ReferenceController.getInstance().addReference(referenceName, chroms, referenceURL);
                this.dispose();
            }
        }
        catch (Exception ex) {
            DialogUtils.displayException("Error Creating References", "<HTML>There was a problem reading your contig values.<BR>Make sure there are no duplicate names, length and centromere contain only numbers, <BR>and centromere &lt; length.</HTML>", ex);
        }
    }
}

