/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.value.NumberConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.NumericConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.SearchConditionEditorView;
import org.ut.biolab.medsavant.client.view.component.DecimalRangeSlider;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Range;

public class NumberSearchConditionEditorView
extends SearchConditionEditorView {
    private static final int FROM_TO_WIDTH = 150;
    private static final Log LOG = LogFactory.getLog(NumberSearchConditionEditorView.class);
    private final NumberConditionValueGenerator generator;
    boolean isAdjustingSlider = false;

    public NumberSearchConditionEditorView(SearchConditionItem i, NumberConditionValueGenerator g) {
        super(i);
        this.generator = g;
    }

    @Override
    public void loadViewFromSearchConditionParameters(String encoding) throws SearchConditionEditorView.ConditionRestorationException {
        if (encoding == null) {
            Object selectedValues = null;
        } else {
            double[] selectedValues = NumericConditionEncoder.unencodeConditions(encoding);
        }
        final double[] extremeValues = this.generator.getExtremeNumericValues();
        this.removeAll();
        if (extremeValues == null || extremeValues[0] == 0.0 && extremeValues[1] == 0.0) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(Box.createHorizontalGlue());
            p.add(new JLabel("<html>All values are blank for this condition.</html>"));
            p.add(Box.createHorizontalGlue());
            this.add(p);
            return;
        }
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(p);
        JPanel labelPanel = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(labelPanel);
        labelPanel.add(Box.createHorizontalGlue());
        labelPanel.add(new JLabel("Filtering variants where " + this.item.getName() + ": "));
        labelPanel.add(Box.createHorizontalGlue());
        ButtonGroup group = new ButtonGroup();
        final JCheckBox nullButton = new JCheckBox("include missing values");
        JPanel bp = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(bp);
        p.add(labelPanel);
        p.add(bp);
        this.add(p);
        final DecimalRangeSlider slider = new DecimalRangeSlider();
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        final JTextField fromBox = new JTextField();
        final JTextField toBox = new JTextField();
        nullButton.setSelected(NumericConditionEncoder.encodesNull(encoding));
        nullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                NumberSearchConditionEditorView.this.encodeValue(ViewUtil.parseDoubleFromFormattedString(fromBox.getText()), ViewUtil.parseDoubleFromFormattedString(toBox.getText()), extremeValues[0], extremeValues[1], nullButton.isSelected());
            }
        });
        fromBox.setMaximumSize(new Dimension(10000, 24));
        toBox.setMaximumSize(new Dimension(10000, 24));
        fromBox.setPreferredSize(new Dimension(150, 24));
        toBox.setPreferredSize(new Dimension(150, 24));
        fromBox.setMinimumSize(new Dimension(150, 24));
        toBox.setMinimumSize(new Dimension(150, 24));
        fromBox.setHorizontalAlignment(4);
        toBox.setHorizontalAlignment(4);
        JLabel fromLabel = new JLabel();
        JLabel toLabel = new JLabel();
        ViewUtil.makeMini(fromLabel);
        ViewUtil.makeMini(toLabel);
        JPanel fromToContainer = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(fromToContainer);
        fromToContainer.add(Box.createHorizontalGlue());
        fromToContainer.add(fromBox);
        fromToContainer.add(new JLabel(" - "));
        fromToContainer.add(toBox);
        fromToContainer.add(Box.createHorizontalGlue());
        JPanel minMaxContainer = ViewUtil.getClearPanel();
        minMaxContainer.setLayout(new BoxLayout(minMaxContainer, 0));
        JPanel sliderContainer = ViewUtil.getClearPanel();
        sliderContainer.setLayout(new BoxLayout(sliderContainer, 1));
        sliderContainer.add((Component)((Object)slider));
        JPanel nullValueContainer = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(nullValueContainer);
        nullValueContainer.add(Box.createHorizontalGlue());
        nullValueContainer.add(nullButton);
        nullButton.setBackground(nullValueContainer.getBackground());
        nullValueContainer.add(Box.createHorizontalGlue());
        JPanel labelContainer = ViewUtil.getClearPanel();
        labelContainer.setLayout(new BoxLayout(labelContainer, 0));
        labelContainer.add(fromLabel);
        labelContainer.add(Box.createHorizontalGlue());
        labelContainer.add(toLabel);
        sliderContainer.add(labelContainer);
        minMaxContainer.add(Box.createHorizontalGlue());
        minMaxContainer.add(sliderContainer);
        minMaxContainer.add(Box.createHorizontalGlue());
        this.add(fromToContainer);
        this.add(minMaxContainer);
        this.add(nullValueContainer);
        this.add(Box.createVerticalBox());
        slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (slider.isEnabled()) {
                    fromBox.setText(ViewUtil.numToString(slider.getLow()));
                    toBox.setText(ViewUtil.numToString(slider.getHigh()));
                    NumberSearchConditionEditorView.this.encodeValue(ViewUtil.parseDoubleFromFormattedString(fromBox.getText()), ViewUtil.parseDoubleFromFormattedString(toBox.getText()), extremeValues[0], extremeValues[1], nullButton.isSelected());
                }
            }
        });
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    Range selectedRage = new Range(this.getNumber(fromBox.getText()), this.getNumber(toBox.getText()));
                    NumberSearchConditionEditorView.this.setSelectedValues(slider, fromBox, toBox, selectedRage);
                }
            }

            private double getNumber(String s) {
                try {
                    return Double.parseDouble(s.replaceAll(",", ""));
                }
                catch (NumberFormatException ignored) {
                    return 0.0;
                }
            }
        };
        CaretListener caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                if (!NumberSearchConditionEditorView.this.isAdjustingSlider) {
                    try {
                        NumberSearchConditionEditorView.this.encodeValue(ViewUtil.parseDoubleFromFormattedString(fromBox.getText()), ViewUtil.parseDoubleFromFormattedString(toBox.getText()), extremeValues[0], extremeValues[1], nullButton.isSelected());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        fromBox.addKeyListener(keyListener);
        toBox.addKeyListener(keyListener);
        fromBox.addCaretListener(caretListener);
        toBox.addCaretListener(caretListener);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumberSearchConditionEditorView.this.isAdjustingSlider = true;
                fromBox.setText(ViewUtil.numToString(slider.getLow()));
                toBox.setText(ViewUtil.numToString(slider.getHigh()));
                NumberSearchConditionEditorView.this.isAdjustingSlider = false;
            }
        });
        JPanel bottomContainer = new JPanel();
        bottomContainer.setLayout(new BoxLayout(bottomContainer, 0));
        bottomContainer.add(Box.createHorizontalGlue());
        this.add(bottomContainer);
        this.setExtremeValues(slider, fromLabel, toLabel, fromBox, toBox, 0, new Range(extremeValues[0], extremeValues[1]));
        if (encoding != null) {
            double[] d = NumericConditionEncoder.unencodeConditions(encoding);
            this.setSelectedValues(slider, fromBox, toBox, new Range(d[0], d[1]));
        }
    }

    private void encodeValue(double low, double high, double min, double max, boolean includeNull) {
        String s = NumericConditionEncoder.encodeConditions(low, high, includeNull);
        this.saveSearchConditionParameters(s);
        String d = NumericConditionEncoder.getDescription(low, high, min, max, includeNull);
        this.item.setDescription(d);
    }

    private void setExtremeValues(DecimalRangeSlider slider, JLabel fromLabel, JLabel toLabel, JTextField fromBox, JTextField toBox, int precision, Range extremeValues) {
        int overallMin = (int)Math.floor(extremeValues.getMin());
        int overallMax = (int)Math.ceil(extremeValues.getMax());
        if (overallMax - overallMin <= 1) {
            precision = 2;
        } else if (overallMax - overallMin <= 10) {
            precision = 1;
        }
        slider.setPrecision(precision);
        slider.setMinimum(overallMin);
        slider.setMaximum(overallMax);
        slider.setLow(overallMin);
        slider.setHigh(overallMax);
        slider.updateUI();
        fromBox.setText(ViewUtil.numToString(overallMin));
        toBox.setText(ViewUtil.numToString(overallMax));
        fromLabel.setText(ViewUtil.numToString(overallMin));
        toLabel.setText(ViewUtil.numToString(overallMax));
    }

    private void setSelectedValues(DecimalRangeSlider slider, JTextField fromBox, JTextField toBox, Range selectedValues) {
        slider.setLow(selectedValues.getMin());
        slider.setHigh(selectedValues.getMax());
        fromBox.setText(ViewUtil.numToString(selectedValues.getMin()));
        toBox.setText(ViewUtil.numToString(selectedValues.getMax()));
        slider.updateUI();
    }

    public static void main(String[] args) {
        Double.parseDouble("1,456,094");
    }
}

