/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.value.encode;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class NumericConditionEncoder {
    private static final Log LOG = LogFactory.getLog(NumericConditionEncoder.class);
    public static String ENCODING_NULL = "<NULL>";
    public static String ENCODING_NOTNULL = "<NOTNULL>";
    static DecimalFormat format;
    static DecimalFormatSymbols symbols;
    static char sep;
    private static String DELIM;

    public static double[] unencodeConditions(String s) {
        String[] arr = s.split(DELIM);
        double[] values = new double[2];
        for (int i = 0; i < 2; ++i) {
            values[i] = Double.parseDouble(arr[i]);
        }
        return values;
    }

    public static boolean encodesNull(String encoding) {
        if (encoding == null) {
            return false;
        }
        String[] arr = encoding.split(DELIM);
        boolean includeNull = Boolean.parseBoolean(arr[2]);
        return includeNull;
    }

    public static String encodeConditions(double low, double high, boolean includeNull) {
        String lowString = Double.toString(low);
        String highString = Double.toString(high);
        return lowString + DELIM + highString + DELIM + includeNull;
    }

    public static String getDescription(double[] ds) {
        double low = ds[0];
        double high = ds[1];
        String s = low == high ? ViewUtil.numToString(low) : ViewUtil.numToString(low) + " - " + ViewUtil.numToString(high);
        return s;
    }

    public static String getDescription(double low, double high, double min, double max, boolean includeNull) {
        String s = low == min && high == max ? "anything" : (low == min && high != max ? "&#60; " + ViewUtil.numToString(high) : (low != min && high == max ? "&#62; " + ViewUtil.numToString(low) : (low == high ? ViewUtil.numToString(low) : ViewUtil.numToString(low) + " - " + ViewUtil.numToString(high))));
        if (includeNull) {
            s = s + " or is missing";
        }
        return s;
    }

    static {
        DecimalFormat f = (DecimalFormat)DecimalFormat.getInstance();
        symbols = f.getDecimalFormatSymbols();
        sep = symbols.getDecimalSeparator();
        format = new DecimalFormat("#" + sep + "##");
        DELIM = ";";
    }
}

