/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.SearchConditionItem;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantConditionViewGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantDatabaseNumberConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.MedSavantDatabaseStringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ComprehensiveConditionGenerator;
import org.ut.biolab.medsavant.client.query.medsavant.complex.ConditionUtils;
import org.ut.biolab.medsavant.client.query.value.StringConditionValueGenerator;
import org.ut.biolab.medsavant.client.query.value.encode.StringConditionEncoder;
import org.ut.biolab.medsavant.client.query.view.NumberSearchConditionEditorView;
import org.ut.biolab.medsavant.client.query.view.SearchConditionItemView;
import org.ut.biolab.medsavant.client.query.view.StringSearchConditionEditorView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.format.CustomField;

public class PatientConditionGenerator
implements ComprehensiveConditionGenerator {
    boolean allowInexactMatch;
    private final String columnName;
    private final String alias;
    private final CustomField field;
    private final HashMap<String, Map> columnNameToRemapMap;
    private static final WhichTable whichTable = WhichTable.PATIENT;

    public PatientConditionGenerator(CustomField field) {
        this.columnName = field.getColumnName();
        this.alias = field.getAlias();
        this.allowInexactMatch = this.columnName.equals(BasicPatientColumns.PHENOTYPES.getColumnName());
        this.columnNameToRemapMap = new HashMap();
        TreeMap<String, String> genderRemap = new TreeMap<String, String>();
        genderRemap.put("Male", "1");
        genderRemap.put("Female", "0");
        genderRemap.put("Unspecified", "2");
        this.columnNameToRemapMap.put(BasicPatientColumns.GENDER.getColumnName(), genderRemap);
        TreeMap<String, String> affectedRemap = new TreeMap<String, String>();
        affectedRemap.put("Yes", "1");
        affectedRemap.put("No", "0");
        this.columnNameToRemapMap.put(BasicPatientColumns.AFFECTED.getColumnName(), affectedRemap);
        this.field = field;
    }

    @Override
    public String getName() {
        return this.alias;
    }

    @Override
    public String category() {
        return "Patients";
    }

    @Override
    public Condition getConditionsFromEncoding(String encoding) throws Exception {
        List<String> appliedValues = StringConditionEncoder.unencodeConditions(encoding);
        if (this.columnNameToRemapMap.containsKey(this.columnName)) {
            appliedValues = this.remapValues(appliedValues, this.columnNameToRemapMap.get(this.columnName));
        }
        if (appliedValues.isEmpty()) {
            return ConditionUtils.FALSE_CONDITION;
        }
        return ConditionUtils.getConditionsMatchingDNAIDs(MedSavantClient.PatientManager.getDNAIDsForStringList(LoginController.getSessionID(), ProjectController.getInstance().getCurrentPatientTableSchema(), appliedValues, this.columnName, this.allowInexactMatch));
    }

    @Override
    public StringSearchConditionEditorView getViewGeneratorForItem(SearchConditionItem item) {
        return this.generateViewFromDatabaseField(item);
    }

    private StringSearchConditionEditorView generateViewFromDatabaseField(SearchConditionItem item) {
        if (this.columnNameToRemapMap.containsKey(this.columnName)) {
            return this.generateStringViewWithPresetValues(item, this.columnNameToRemapMap.get(this.columnName).keySet());
        }
        return this.generateStringViewFromDatabaseField(item);
    }

    private StringSearchConditionEditorView generateStringViewFromDatabaseField(SearchConditionItem item) {
        String colName = this.field.getColumnName();
        Object valueGenerator = colName.equals(BasicVariantColumns.ALT.getColumnName()) || colName.equals(BasicVariantColumns.REF.getColumnName()) || colName.equals(BasicVariantColumns.AA.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return Arrays.asList("A", "C", "G", "T");
            }
        } : (colName.equals(BasicVariantColumns.VARIANT_TYPE.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return Arrays.asList("SNP", "Deletion", "Insertion", "Unknown", "Multiple");
            }
        } : (colName.equals(BasicVariantColumns.ZYGOSITY.getColumnName()) ? new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return Arrays.asList("Homozygous Reference", "Homozygous Alternate", "Heterozygous", "Heterozygous (Triallelic)", "Missing");
            }
        } : (colName.equals(BasicVariantColumns.DBSNP_ID.getColumnName()) ? null : new MedSavantDatabaseStringConditionValueGenerator(this.field, whichTable))));
        StringSearchConditionEditorView editor = new StringSearchConditionEditorView(item, (StringConditionValueGenerator)valueGenerator);
        return editor;
    }

    private SearchConditionItemView generateFloatViewFromDatabaseField(SearchConditionItem item) {
        NumberSearchConditionEditorView editor = new NumberSearchConditionEditorView(item, new MedSavantDatabaseNumberConditionValueGenerator(this.field, whichTable));
        SearchConditionItemView view = new SearchConditionItemView(item, editor);
        return view;
    }

    private Condition generateStringConditionForVariantDatabaseField(MedSavantConditionViewGenerator.DatabaseFieldStruct s, String encoding) {
        List<String> selected = StringConditionEncoder.unencodeConditions(encoding);
        if (selected.isEmpty()) {
            return BinaryCondition.equalTo(1, 0);
        }
        DbColumn col = ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(this.field.getColumnName());
        Condition[] conditions = new Condition[selected.size()];
        int i = 0;
        for (String select : selected) {
            conditions[i++] = BinaryCondition.equalTo(col, select);
        }
        return ComboCondition.or(conditions);
    }

    private StringSearchConditionEditorView generateStringViewWithPresetValues(SearchConditionItem item, final Set<String> values) {
        StringConditionValueGenerator vg = new StringConditionValueGenerator(){

            @Override
            public List<String> getStringValues() {
                return new ArrayList<String>(values);
            }
        };
        StringSearchConditionEditorView editor = new StringSearchConditionEditorView(item, vg);
        return editor;
    }

    private List<String> remapValues(List<String> appliedValues, Map<String, String> remap) {
        ArrayList<String> remappedAppliedValues = new ArrayList<String>();
        for (String s : appliedValues) {
            System.out.println("Remapping " + s + " to " + remap.get(s));
            remappedAppliedValues.add(remap.get(s));
        }
        return remappedAppliedValues;
    }
}

