/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.query.medsavant.complex;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.GenomicRegion;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class ConditionUtils {
    public static BinaryCondition TRUE_CONDITION = BinaryCondition.equalTo(1, 1);
    public static BinaryCondition FALSE_CONDITION = BinaryCondition.equalTo(1, 0);

    public static Condition getConditionsMatchingGenomicRegions(Collection<GenomicRegion> regions) throws SQLException, RemoteException {
        Condition[] results;
        Map<String, List<Range>> rangeMap = GenomicRegion.mergeGenomicRegions(regions);
        if (rangeMap.size() > 0) {
            results = new Condition[rangeMap.size()];
            int i = 0;
            for (String chrom : rangeMap.keySet()) {
                Condition[] tmp = new Condition[2];
                tmp[0] = BinaryConditionMS.equalTo(ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.CHROM), chrom);
                List<Range> ranges = rangeMap.get(chrom);
                Condition[] rangeConditions = new Condition[ranges.size()];
                for (int j = 0; j < ranges.size(); ++j) {
                    rangeConditions[j] = MiscUtils.getIntersectCondition((int)ranges.get(j).getMin(), (int)ranges.get(j).getMax(), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.START_POSITION), ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.END_POSITION));
                }
                tmp[1] = ComboCondition.or(rangeConditions);
                results[i] = ComboCondition.and(tmp);
                ++i;
            }
        } else {
            return FALSE_CONDITION;
        }
        return ComboCondition.or(results);
    }

    public static Condition getConditionsMatchingDNAIDs(Collection<String> dnaIDs) {
        if (dnaIDs.size() > 0) {
            if (dnaIDs.size() == 1) {
                return ComboCondition.or(BinaryConditionMS.equalTo(ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.DNA_ID), dnaIDs.iterator().next()));
            }
            return ComboCondition.or(new InCondition((Object)ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(BasicVariantColumns.DNA_ID), dnaIDs));
        }
        return FALSE_CONDITION;
    }
}

