/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.plugin;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.plugin.AppController;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.plugin.PluginEvent;

public class PluginBrowser
extends HierarchicalTable {
    private ProgramTableModel tableModel;
    private AppController pluginController = AppController.getInstance();

    public PluginBrowser() {
        this.tableModel = new ProgramTableModel();
        this.pluginController.addListener(this.tableModel);
        this.setModel(this.tableModel);
        this.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.setHierarchicalColumn(-1);
        this.setSingleExpansion(true);
        this.setName("Program Table");
        this.setShowGrid(false);
        this.setRowHeight(24);
        this.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.getColumnModel().getColumn(0).setPreferredWidth(500);
        this.setSelectionMode(0);
        HierarchicalTableComponentFactory factory = new HierarchicalTableComponentFactory(){

            public Component createChildComponent(HierarchicalTable table, Object value, int row) {
                if (value instanceof AppDescriptor) {
                    return new ProgramPanel((AppDescriptor)value);
                }
                return null;
            }

            public void destroyChildComponent(HierarchicalTable table, Component component, int row) {
            }
        };
        this.setComponentFactory(factory);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = PluginBrowser.this.getSelectedRow();
                if (row != -1) {
                    PluginBrowser.this.expandRow(row);
                }
            }
        });
    }

    class ProgramTableModel
    extends AbstractTableModel
    implements HierarchicalTableModel,
    Listener<PluginEvent> {
        List<AppDescriptor> descriptors;

        ProgramTableModel() {
            this.descriptors = PluginBrowser.this.pluginController.getDescriptors();
        }

        @Override
        public int getRowCount() {
            return this.descriptors.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.descriptors.get(rowIndex).getName();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean hasChild(int row) {
            return true;
        }

        public boolean isExpandable(int row) {
            return true;
        }

        public boolean isHierarchical(int row) {
            return false;
        }

        public Object getChildValueAt(int row) {
            return this.descriptors.get(row);
        }

        @Override
        public void handleEvent(PluginEvent event) {
            this.descriptors = PluginBrowser.this.pluginController.getDescriptors();
            this.fireTableDataChanged();
        }
    }

    class ProgramPanel
    extends JPanel {
        AppDescriptor program;

        public ProgramPanel(AppDescriptor program) {
            this.program = program;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = new Insets(3, 3, 3, 3);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridheight = 2;
            this.add((Component)new JLabel(program.getName()), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            this.add((Component)new JLabel("Version: " + program.getVersion()), gbc);
            gbc.gridy = 1;
            final JLabel statusLabel = new JLabel("Status: " + PluginBrowser.this.pluginController.getPluginStatus(program.getID()));
            this.add((Component)statusLabel, gbc);
            JButton removeButton = new JButton("Uninstall");
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).setEnabled(false);
                    PluginBrowser.this.pluginController.queuePluginForRemoval(ProgramPanel.this.program.getID());
                    statusLabel.setText("Status: " + PluginBrowser.this.pluginController.getPluginStatus(ProgramPanel.this.program.getID()));
                }
            });
            if (PluginBrowser.this.pluginController.isPluginQueuedForRemoval(program.getID())) {
                removeButton.setEnabled(false);
            }
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridheight = 2;
            this.add((Component)removeButton, gbc);
        }
    }
}

