/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.plugin;

import com.apple.eio.FileManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.plugin.AppDescriptor;
import org.ut.biolab.medsavant.client.plugin.PluginEvent;
import org.ut.biolab.medsavant.client.plugin.PluginIndex;
import org.ut.biolab.medsavant.client.plugin.PluginVersionException;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.ClientNetworkUtils;
import org.ut.biolab.medsavant.client.util.Controller;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.shared.appapi.MedSavantApp;
import org.ut.biolab.medsavant.shared.util.IOUtils;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class AppController
extends Controller {
    private static final Log LOG = LogFactory.getLog(AppController.class);
    private static final String UNINSTALL_FILENAME = ".uninstall_apps";
    private static AppController instance;
    private File uninstallFile;
    private List<String> pluginsToRemove = new ArrayList<String>();
    private Map<String, AppDescriptor> knownPlugins = new HashMap<String, AppDescriptor>();
    private Map<String, MedSavantApp> loadedPlugins = new ConcurrentHashMap<String, MedSavantApp>();
    private Map<String, String> pluginErrors = new LinkedHashMap<String, String>();
    private PluginLoader pluginLoader;
    private PluginIndex repositoryIndex = null;

    public static synchronized AppController getInstance() {
        if (instance == null) {
            instance = new AppController();
        }
        return instance;
    }

    private AppController() {
        try {
            this.uninstallFile = new File(DirectorySettings.getMedSavantDirectory(), UNINSTALL_FILENAME);
            LOG.debug((Object)String.format("Uninstall list %s.", UNINSTALL_FILENAME));
            if (this.uninstallFile.exists()) {
                this.deleteFileList(this.uninstallFile);
            }
            this.copyBuiltInPlugins();
        }
        catch (Exception ex) {
            LOG.error((Object)"Error loading plugins.", (Throwable)ex);
        }
    }

    public void loadPlugins(File pluginsDir) {
        File[] files;
        LOG.info((Object)("Loading plugins in " + pluginsDir.getAbsolutePath()));
        for (File f : files = pluginsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        })) {
            try {
                this.addPlugin(f);
            }
            catch (PluginVersionException x) {
                LOG.warn((Object)String.format("No compatible plugins found in %s.", f));
            }
        }
        if (this.pluginErrors.size() > 0) {
            ArrayList<String> updated = new ArrayList<String>();
            for (String s : this.pluginErrors.keySet()) {
                if (!this.checkForPluginUpdate(s)) continue;
                updated.add(s);
            }
            if (updated.size() > 0) {
                DialogUtils.displayMessage("Plugins Updated", String.format("<html>The following plugins were updated to be compatible with MedSavant %s:<br><br><i>%s</i></html>", VersionSettings.getVersionString(), ClientMiscUtils.join(updated, ", ")));
                for (String s : updated) {
                    this.pluginErrors.remove(s);
                }
            }
            if (this.pluginErrors.size() > 0) {
                StringBuilder errorStr = null;
                for (String s : this.pluginErrors.keySet()) {
                    if (errorStr == null) {
                        errorStr = new StringBuilder();
                    } else {
                        errorStr.append("<br>");
                    }
                    errorStr.append(s);
                    errorStr.append(" \u2013 ");
                    errorStr.append(this.pluginErrors.get(s));
                }
                if (errorStr != null) {
                    DialogUtils.displayMessage("Apps Not Loaded", String.format("<html>The following Apps could not be loaded:<br><br><i>%s</i><br><br>They will not be available to MedSavant.</html>", errorStr));
                }
            }
        }
        HashSet<URL> jarURLs = new HashSet<URL>();
        for (AppDescriptor desc : this.knownPlugins.values()) {
            try {
                if (this.pluginErrors.containsKey(desc.getID())) continue;
                jarURLs.add(desc.getFile().toURI().toURL());
            }
            catch (MalformedURLException ignored) {}
        }
        if (jarURLs.size() > 0) {
            this.pluginLoader = new PluginLoader(jarURLs.toArray(new URL[0]), this.getClass().getClassLoader());
            final Semaphore waitSem = new Semaphore(-this.knownPlugins.size() + 1);
            for (final AppDescriptor desc : this.knownPlugins.values()) {
                if (!this.pluginErrors.containsKey(desc.getID())) {
                    new Thread("PluginLoader-" + desc){

                        @Override
                        public void run() {
                            try {
                                AppController.this.loadPlugin(desc);
                                waitSem.release();
                            }
                            catch (Throwable x) {
                                LOG.error((Object)String.format("Unable to load %s.", desc.getName()), x);
                                AppController.this.pluginErrors.put(desc.getID(), x.getClass().getName());
                                AppController.this.fireEvent(new PluginEvent(PluginEvent.Type.ERROR, desc.getID()));
                            }
                        }
                    }.start();
                    continue;
                }
                waitSem.release();
            }
            LOG.info((Object)"Waiting for Apps to load...");
            try {
                waitSem.acquire();
            }
            catch (InterruptedException ie) {
                LOG.error((Object)"Interrupted while waiting for apps to load");
            }
            LOG.info((Object)"All Apps loaded.");
            waitSem.release();
        }
    }

    public List<AppDescriptor> getDescriptors() {
        ArrayList<AppDescriptor> result = new ArrayList<AppDescriptor>();
        result.addAll(this.knownPlugins.values());
        Collections.sort(result);
        return result;
    }

    public void getGeneManiaData() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String directoryPath = DirectorySettings.getCacheDirectory().getAbsolutePath();
                if (!new File(directoryPath + "/done.txt").exists()) {
                    URL pathToGMData = WebResources.GENEMANIA_DATA_URL;
                    System.out.println("Downloding GeneMania data from " + pathToGMData.toString());
                    try {
                        throw new IOException("Temporarily preventing gm data from downloading. Because it's so large it should only be downloaded once and on demand");
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AppController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    private static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public MedSavantApp getPlugin(String id) {
        return this.loadedPlugins.get(id);
    }

    public List<MedSavantApp> getPluginsOfClass(Class c) {
        ArrayList<MedSavantApp> results = new ArrayList<MedSavantApp>();
        for (AppDescriptor ad : this.getDescriptors()) {
            try {
                MedSavantApp appInstance = this.getPlugin(ad.getID());
                if (!c.isInstance(appInstance)) continue;
                results.add(appInstance);
            }
            catch (Exception e) {
                LOG.error((Object)"Problem loading App", (Throwable)e);
            }
        }
        LOG.info((Object)(results.size() + " apps of class " + c.getSimpleName()));
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queuePluginForRemoval(String id) {
        OutputStreamWriter fstream = null;
        boolean success = false;
        try {
            AppDescriptor info = this.knownPlugins.get(id);
            LOG.info((Object)String.format("Adding plugin %s to uninstall list %s.", info.getFile().getAbsolutePath(), this.uninstallFile.getPath()));
            if (!this.uninstallFile.exists()) {
                this.uninstallFile.createNewFile();
            }
            fstream = new FileWriter(this.uninstallFile, true);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(info.getFile().getAbsolutePath() + "\n");
            out.close();
            this.pluginsToRemove.add(id);
            this.fireEvent(new PluginEvent(PluginEvent.Type.QUEUED_FOR_REMOVAL, id));
            success = true;
        }
        catch (IOException ex) {
            LOG.error((Object)String.format("Error uninstalling plugin: %s.", this.uninstallFile), (Throwable)ex);
        }
        finally {
            try {
                fstream.close();
            }
            catch (IOException ignored) {}
        }
        return success;
    }

    public boolean isPluginQueuedForRemoval(String id) {
        return this.pluginsToRemove.contains(id);
    }

    public String getPluginStatus(String id) {
        if (this.pluginsToRemove.contains(id)) {
            return "Queued for removal";
        }
        if (this.loadedPlugins.get(id) != null) {
            return "Loaded";
        }
        String err = this.pluginErrors.get(id);
        if (err != null) {
            return err;
        }
        if (this.knownPlugins.get(id) != null) {
            return "Loading";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileList(File fileListFile) {
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(new FileReader(fileListFile));
            while ((line = br.readLine()) != null) {
                LOG.info((Object)String.format("Uninstalling %s.", line));
                if (new File(line).delete()) continue;
                throw new IOException("Delete of " + line + " failed");
            }
        }
        catch (IOException ex) {
            LOG.error((Object)String.format("Problem uninstalling %s.", line), (Throwable)ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        fileListFile.delete();
    }

    private void copyBuiltInPlugins() {
        File destDir = DirectorySettings.getPluginsDirectory();
        File srcDir = null;
        if (ClientMiscUtils.MAC && (srcDir = new File(FileManager.getPathToApplicationBundle() + "/Contents/Plugins")).exists()) {
            try {
                IOUtils.copyDir(srcDir, destDir);
                return;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        try {
            srcDir = new File("plugins");
            IOUtils.copyDir(srcDir, destDir);
        }
        catch (Exception x) {
            LOG.error((Object)String.format("Unable to copy builtin plugins from %s to %s.", srcDir.getAbsolutePath(), destDir), (Throwable)x);
        }
    }

    private void loadPlugin(AppDescriptor desc) throws Throwable {
        LOG.debug((Object)String.format("loadPlugin(\"%s\")", desc.getID()));
        try {
            Class<?> pluginClass = this.pluginLoader.loadClass(desc.getClassName());
            MedSavantApp plugin = (MedSavantApp)pluginClass.newInstance();
            this.loadedPlugins.put(desc.getID(), plugin);
            LOG.debug((Object)String.format("Firing LOADED event to %s listeners.", this.listeners.size()));
            this.fireEvent(new PluginEvent(PluginEvent.Type.LOADED, desc.getID()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public AppDescriptor addPlugin(File f) throws PluginVersionException {
        LOG.info((Object)String.format("Loading plugin from %s", f.getAbsolutePath()));
        AppDescriptor desc = this.getDescriptorFromFile(f);
        if (desc != null) {
            boolean isCompatible;
            LOG.debug((Object)String.format("Found usable %s in %s.", desc, f.getName()));
            AppDescriptor existingDesc = this.knownPlugins.get(desc.getID());
            if (existingDesc != null && existingDesc.getVersion().compareTo(desc.getVersion()) >= 0) {
                LOG.debug((Object)String.format("   Ignored %s due to presence of existing %s.", desc, existingDesc));
                return null;
            }
            this.knownPlugins.put(desc.getID(), desc);
            try {
                isCompatible = VersionSettings.isAppSDKCompatibleWithClient(desc.getSDKVersion(), VersionSettings.getVersionString());
            }
            catch (Exception ex) {
                throw new PluginVersionException("Could not determine compatibility between " + desc.getSDKVersion() + " and " + VersionSettings.getVersionString());
            }
            if (isCompatible) {
                if (existingDesc != null) {
                    LOG.debug((Object)String.format("   Replaced %s.", existingDesc));
                    this.pluginErrors.remove(desc.getID());
                }
            } else {
                LOG.info((Object)String.format("Found incompatible %s (SDK version %s) in %s.", desc, desc.getSDKVersion(), f.getName()));
                this.pluginErrors.put(desc.getID(), "Invalid SDK version (" + desc.getSDKVersion() + " vs " + VersionSettings.getVersionString() + ")");
                throw new PluginVersionException("Invalid SDK version (" + desc.getSDKVersion() + " vs " + VersionSettings.getVersionString() + ")");
            }
        }
        return desc;
    }

    public void installPlugin(File selectedFile) throws Throwable {
        File pluginFile = new File(DirectorySettings.getPluginsDirectory(), selectedFile.getName());
        LOG.info((Object)("Copying file " + selectedFile.getAbsolutePath() + " to " + pluginFile.getAbsolutePath()));
        IOUtils.copyFile(selectedFile, pluginFile);
        LOG.info((Object)"Getting plugin information...");
    }

    private boolean checkForPluginUpdate(String id) {
        try {
            URL updateURL;
            if (this.repositoryIndex == null) {
                this.repositoryIndex = new PluginIndex(NetworkUtils.getKnownGoodURL(WebResources.PLUGIN_REPOSITORY_URLS[0]));
            }
            if ((updateURL = this.repositoryIndex.getPluginURL(id)) != null) {
                LOG.debug((Object)String.format("Downloading updated version of %s from %s.", id, updateURL));
                this.addPlugin(ClientNetworkUtils.downloadFile(updateURL, DirectorySettings.getPluginsDirectory(), null));
                return true;
            }
        }
        catch (IOException x) {
            LOG.error((Object)String.format("Unable to install update for %s.", id), (Throwable)x);
        }
        catch (PluginVersionException x) {
            LOG.error((Object)String.format("Update for %s not loaded.", id));
        }
        return false;
    }

    public AppDescriptor getDescriptorFromFile(File f) throws PluginVersionException {
        try {
            JarFile jar = new JarFile(f);
            ZipEntry entry = jar.getEntry("plugin.xml");
            if (entry != null) {
                InputStream entryStream = jar.getInputStream(entry);
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(entryStream);
                String className = null;
                Object id = null;
                String version = null;
                String sdkVersion = null;
                String name = null;
                String category = AppDescriptor.Category.UTILITY.toString();
                String currentElement = null;
                String currentText = "";
                block14: do {
                    switch (reader.next()) {
                        case 1: {
                            switch (AppController.readElement(reader)) {
                                case PLUGIN: {
                                    className = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.CLASS);
                                    category = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.CATEGORY);
                                    break;
                                }
                                case ATTRIBUTE: {
                                    if (!"sdk-version".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.ID))) break;
                                    sdkVersion = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE);
                                    break;
                                }
                                case PARAMETER: {
                                    if (!"name".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.ID))) break;
                                    name = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE);
                                    break;
                                }
                                case PROPERTY: {
                                    if ("name".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.NAME)) && (name = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE)) == null) {
                                        currentElement = "name";
                                    }
                                    if ("version".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.NAME)) && (version = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE)) == null) {
                                        currentElement = "version";
                                    }
                                    if ("sdk-version".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.NAME)) && (sdkVersion = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE)) == null) {
                                        currentElement = "sdk-version";
                                    }
                                    if (!"category".equals(AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.NAME)) || (category = AppController.readAttribute(reader, AppDescriptor.PluginXMLAttribute.VALUE)) != null) break;
                                    currentElement = "category";
                                }
                            }
                            continue block14;
                        }
                        case 4: {
                            if (reader.isWhiteSpace() || currentElement == null) continue block14;
                            currentText = currentText + reader.getText().trim().replace("\t", "");
                            break;
                        }
                        case 2: {
                            if (AppController.readElement(reader) != AppDescriptor.PluginXMLElement.PROPERTY) break;
                            if (currentElement != null && currentText.length() > 0) {
                                if (currentElement.equals("name")) {
                                    name = currentText;
                                } else if (currentElement.equals("sdk-version")) {
                                    sdkVersion = currentText;
                                } else if (currentElement.equals("category")) {
                                    category = currentText;
                                } else if (currentElement.equals("version")) {
                                    version = currentText;
                                }
                            }
                            currentText = "";
                            currentElement = null;
                            break;
                        }
                        case 8: {
                            reader.close();
                            reader = null;
                        }
                    }
                } while (reader != null);
                System.out.println(className + " " + name + " " + version);
                if (className != null && name != null && version != null) {
                    return new AppDescriptor(className, version, name, sdkVersion, category, f);
                }
            }
        }
        catch (Exception x) {
            LOG.error((Object)("Error parsing plugin.xml from " + f.getAbsolutePath() + ": " + x));
        }
        throw new PluginVersionException(f.getName() + " did not contain a valid plugin");
    }

    private static AppDescriptor.PluginXMLElement readElement(XMLStreamReader reader) {
        try {
            String elemName = reader.getLocalName().toUpperCase();
            return Enum.valueOf(AppDescriptor.PluginXMLElement.class, elemName);
        }
        catch (IllegalArgumentException ignored) {
            return AppDescriptor.PluginXMLElement.IGNORED;
        }
    }

    private static String readAttribute(XMLStreamReader reader, AppDescriptor.PluginXMLAttribute attr) {
        return reader.getAttributeValue(null, attr.toString().toLowerCase());
    }

    static /* synthetic */ void access$300(InputStream x0, OutputStream x1) throws IOException {
        AppController.copyInputStream(x0, x1);
    }

    class PluginLoader
    extends URLClassLoader {
        PluginLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        void addJar(File f) {
            try {
                this.addURL(f.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }
}

