/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class Patient {
    private int ID;
    private String hospitalID;
    private String motherHospitalID;
    private String fatherHospitalID;
    private String familyID;
    private String dnaID;
    private String sex;
    private Boolean affected;
    private String bamURL;
    private String phenotypes;

    public Patient(String hospitalID) {
        this.hospitalID = hospitalID;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public String getHospitalID() {
        return this.hospitalID;
    }

    void setHospitalID(String hospitalID) {
        this.hospitalID = hospitalID;
    }

    public String getMotherHospitalID() {
        return this.motherHospitalID;
    }

    public void setMotherHospitalID(String motherHospitalID) {
        this.motherHospitalID = motherHospitalID;
    }

    public String getFatherHospitalID() {
        return this.fatherHospitalID;
    }

    public void setFatherHospitalID(String fatherHospitalID) {
        this.fatherHospitalID = fatherHospitalID;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public void setFamilyID(String familyID) {
        this.familyID = familyID;
    }

    public String getDnaID() {
        return this.dnaID;
    }

    public void setDnaID(String dnaID) {
        this.dnaID = dnaID;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public boolean isAffected() {
        return this.affected;
    }

    public void setAffected(Boolean affected) {
        this.affected = affected == null ? false : affected;
    }

    public String getBamURL() {
        return this.bamURL;
    }

    public void setBamURL(String bamURL) {
        this.bamURL = bamURL;
    }

    public String getPhenotypes() {
        return this.phenotypes;
    }

    public void setPhenotypes(String phenotypes) {
        this.phenotypes = phenotypes;
    }

    public String toString() {
        return "Patient{hospitalID=" + this.hospitalID + ", motherHospitalID=" + this.motherHospitalID + ", fatherHospitalID=" + this.fatherHospitalID + ", familyID=" + this.familyID + ", dnaID=" + this.dnaID + ", sex=" + this.sex + ", affected=" + this.affected + ", bamURL=" + this.bamURL + ", phenotypes=" + this.phenotypes + '}';
    }

    void saveToDatabase() {
        try {
            CustomField[] fieldArray = MedSavantClient.PatientManager.getPatientFields(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID());
            boolean idIndex = false;
            int hospitalIDIndex = 2;
            int biomomIndex = 3;
            int biodadIndex = 4;
            int familyIDIndex = 1;
            int bamURLIndex = 8;
            int dnaIDIndex = 7;
            int phenotypesIndex = 9;
            int genderIndex = 5;
            int affectedIndex = 6;
            ArrayList<CustomField> fields = new ArrayList<CustomField>();
            ArrayList<String> values = new ArrayList<String>();
            fields.add(fieldArray[hospitalIDIndex]);
            values.add(this.getHospitalID());
            fields.add(fieldArray[biomomIndex]);
            values.add(this.getMotherHospitalID());
            fields.add(fieldArray[biodadIndex]);
            values.add(this.getFatherHospitalID());
            fields.add(fieldArray[familyIDIndex]);
            values.add(this.getFamilyID());
            fields.add(fieldArray[bamURLIndex]);
            values.add(this.getBamURL());
            fields.add(fieldArray[dnaIDIndex]);
            values.add(this.getDnaID());
            fields.add(fieldArray[phenotypesIndex]);
            values.add(this.getPhenotypes());
            fields.add(fieldArray[genderIndex]);
            values.add(ClientMiscUtils.stringToGender(this.getSex()) + "");
            fields.add(fieldArray[affectedIndex]);
            values.add((this.isAffected() ? 1 : 0) + "");
            MedSavantClient.PatientManager.updatePatient(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.getID(), fields, values);
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
        catch (Exception ex) {
            Logger.getLogger(Patient.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

