/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.patient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.patient.Patient;
import org.ut.biolab.medsavant.client.patient.PatientView;
import org.ut.biolab.medsavant.client.patient.pedigree.PedigreeFields;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.BlockingPanel;
import org.ut.biolab.medsavant.client.view.list.DetailedView;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class IndividualDetailedView
extends DetailedView
implements PedigreeFields {
    private final BlockingPanel blockPanel;
    private final PatientView patientView = new PatientView();
    private DetailsWorker detailsWorker;

    public IndividualDetailedView(String page) throws RemoteException, SQLException {
        super(page);
        this.blockPanel = new BlockingPanel("No individual selected", this.patientView);
        this.setLayout(new BorderLayout());
        this.add((Component)this.blockPanel, "Center");
    }

    public synchronized void setPatient(Patient patient) {
        this.patientView.setPatient(patient);
    }

    @Override
    public void setSelectedItem(Object[] item) {
        if (item.length == 0) {
            this.blockPanel.block();
        } else {
            int patientId = (Integer)item[0];
            String hospitalId = (String)item[2];
            this.setSelectedItem(patientId, hospitalId);
        }
    }

    public void setSelectedItem(int patientId, String hospitalId) {
        if (this.detailsWorker != null) {
            this.detailsWorker.cancel(true);
        }
        this.detailsWorker = new DetailsWorker(patientId);
        this.detailsWorker.execute();
    }

    @Override
    public void setMultipleSelections(List<Object[]> items) {
        if (items.isEmpty()) {
            this.blockPanel.block();
        }
    }

    private class DetailsWorker
    extends MedSavantWorker<Object[]> {
        private final int patientID;

        private DetailsWorker(int patID) {
            super(IndividualDetailedView.this.getPageName());
            this.patientID = patID;
        }

        @Override
        protected Object[] doInBackground() throws RemoteException, SQLException {
            try {
                return MedSavantClient.PatientManager.getPatientRecord(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), this.patientID);
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }

        @Override
        protected void showProgress(double ignored) {
        }

        @Override
        protected void showSuccess(Object[] result) {
            Integer patientIDInteger = (Integer)result[0];
            Patient patient = new Patient(result[2].toString());
            patient.setID(patientIDInteger);
            patient.setFamilyID(this.toStringProtected(result[1]));
            patient.setMotherHospitalID(this.toStringProtected(result[3]));
            patient.setFatherHospitalID(this.toStringProtected(result[4]));
            Integer genderInteger = (Integer)result[5];
            if (genderInteger != null) {
                patient.setSex(this.toStringProtected(ClientMiscUtils.genderToString(genderInteger)));
            } else {
                patient.setSex("Undesignated");
            }
            patient.setAffected((Boolean)result[6]);
            patient.setBamURL(this.toStringProtected(result[8]));
            patient.setDnaID(this.toStringProtected(result[7]));
            patient.setPhenotypes(this.toStringProtected(result[9]));
            IndividualDetailedView.this.setPatient(patient);
            IndividualDetailedView.this.blockPanel.unblock();
        }

        private String toStringProtected(Object object) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    }
}

