/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.ontology;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.PageList;
import com.jidesoft.wizard.AbstractWizardPage;
import com.jidesoft.wizard.CompletionWizardPage;
import com.jidesoft.wizard.DefaultWizardPage;
import com.jidesoft.wizard.WizardDialog;
import com.jidesoft.wizard.WizardStyle;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.ontology.OntologyListItem;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Ontology;
import org.ut.biolab.medsavant.shared.model.OntologyType;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class OntologyWizard
extends WizardDialog {
    private static final Log LOG = LogFactory.getLog(OntologyWizard.class);
    private static final String PAGENAME_NAME = "Ontology Name";
    private static final String PAGENAME_SOURCE = "Choose Source";
    private static final String PAGENAME_CREATE = "Create";
    private static final String PAGENAME_COMPLETE = "Complete";
    private String name;
    private OntologyType type;
    private JTextField oboField = new JTextField();
    private JTextField mappingField = new JTextField();

    public OntologyWizard() throws SQLException, RemoteException {
        super((Frame)DialogUtils.getFrontWindow(), "Ontology Wizard", true);
        WizardStyle.setStyle((int)3);
        PageList model = new PageList();
        model.append((AbstractDialogPage)this.getNamePage());
        model.append((AbstractDialogPage)this.getSourcePage());
        model.append((AbstractDialogPage)this.getCreationPage());
        model.append((AbstractDialogPage)this.getCompletionPage());
        this.setPageList(model);
        this.setNextAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pageName = OntologyWizard.this.getCurrentPage().getTitle();
                if (pageName.equals(OntologyWizard.PAGENAME_NAME) && OntologyWizard.this.validateName()) {
                    OntologyWizard.this.setCurrentPage(OntologyWizard.PAGENAME_SOURCE);
                } else if (pageName.equals(OntologyWizard.PAGENAME_SOURCE)) {
                    OntologyWizard.this.setCurrentPage(OntologyWizard.PAGENAME_CREATE);
                } else if (pageName.equals(OntologyWizard.PAGENAME_CREATE)) {
                    OntologyWizard.this.setCurrentPage(OntologyWizard.PAGENAME_COMPLETE);
                }
            }
        });
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(DialogUtils.getFrontWindow());
    }

    private AbstractWizardPage getNamePage() {
        return new DefaultWizardPage(PAGENAME_NAME){
            private JTextField nameField;
            private JComboBox typeCombo;
            {
                this.nameField = new JTextField();
                this.typeCombo = new JComboBox<OntologyListItem>(OntologyListItem.DEFAULT_ITEMS);
                this.addText("Choose a name for the ontology.\nThe name cannot already be in use. ");
                this.addComponent(this.nameField);
                this.nameField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (StringUtils.isNotEmpty((String)nameField.getText())) {
                            OntologyWizard.this.name = nameField.getText();
                            this.fireButtonEvent(3301, "NEXT");
                        } else {
                            this.fireButtonEvent(3302, "NEXT");
                        }
                    }
                });
                this.addText("Indicate the type of ontology data:");
                this.addComponent(this.typeCombo);
                this.typeCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        OntologyWizard.this.type = ((OntologyListItem)typeCombo.getSelectedItem()).getType();
                        switch (OntologyWizard.this.type) {
                            case GO: {
                                OntologyWizard.this.oboField.setText(WebResources.GO_OBO_URL.toString());
                                OntologyWizard.this.mappingField.setText(WebResources.GO_TO_GENES_URL.toString());
                                break;
                            }
                            case HPO: {
                                OntologyWizard.this.oboField.setText(WebResources.HPO_OBO_URL.toString());
                                OntologyWizard.this.mappingField.setText(WebResources.HPO_TO_GENES_URL.toString());
                                break;
                            }
                            case OMIM: {
                                OntologyWizard.this.oboField.setText(WebResources.OMIM_OBO_URL.toString());
                                OntologyWizard.this.mappingField.setText(WebResources.OMIM_TO_HPO_URL.toString());
                            }
                        }
                    }
                });
                this.typeCombo.setSelectedIndex(0);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                if (OntologyWizard.this.name == null || OntologyWizard.this.name.equals("")) {
                    this.fireButtonEvent(3302, "NEXT");
                } else {
                    this.fireButtonEvent(3301, "NEXT");
                }
            }
        };
    }

    private AbstractWizardPage getSourcePage() {
        return new DefaultWizardPage(PAGENAME_SOURCE){
            {
                KeyAdapter listener = new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (StringUtils.isNotEmpty((String)OntologyWizard.this.oboField.getText()) && StringUtils.isNotEmpty((String)OntologyWizard.this.mappingField.getText())) {
                            this.fireButtonEvent(3301, "NEXT");
                        } else {
                            this.fireButtonEvent(3302, "NEXT");
                        }
                    }
                };
                this.addText("URL for the OBO file containing the ontology data:");
                this.addComponent(OntologyWizard.this.oboField);
                OntologyWizard.this.oboField.addKeyListener(listener);
                this.addText("URL for the file definining the mapping between genes\nand ontology terms:");
                this.addComponent(OntologyWizard.this.mappingField);
                OntologyWizard.this.mappingField.addKeyListener(listener);
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                this.fireButtonEvent(3301, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCreationPage() {
        return new DefaultWizardPage(PAGENAME_CREATE){
            private JProgressBar progressBar;
            private JButton startButton;
            {
                this.addText("You are now ready to create this ontology.");
                this.progressBar = new JProgressBar();
                this.addComponent(this.progressBar);
                this.startButton = new JButton("Create Ontology");
                this.startButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        startButton.setEnabled(false);
                        this.fireButtonEvent(3302, "BACK");
                        progressBar.setIndeterminate(true);
                        new MedSavantWorker<Void>("Ontologies"){

                            @Override
                            public Void doInBackground() throws Exception {
                                OntologyWizard.this.create();
                                return null;
                            }

                            @Override
                            protected void showProgress(double fraction) {
                            }

                            @Override
                            protected void showSuccess(Void result) {
                                ((CompletionWizardPage)OntologyWizard.this.getPageByTitle(OntologyWizard.PAGENAME_COMPLETE)).addText("Ontology " + OntologyWizard.this.name + " has been successfully created.");
                                OntologyWizard.this.setCurrentPage(OntologyWizard.PAGENAME_COMPLETE);
                            }

                            @Override
                            protected void showFailure(Throwable t) {
                                OntologyWizard.this.setVisible(false);
                                LOG.error((Object)"Error creating ontology.", t);
                                DialogUtils.displayException("Error", "There was an error while trying to create your ontology. ", t);
                            }
                        }.execute();
                    }
                });
                this.addComponent(ViewUtil.alignRight(this.startButton));
            }

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "FINISH");
                this.fireButtonEvent(3299, "BACK");
                this.fireButtonEvent(3299, "NEXT");
                this.fireButtonEvent(3302, "NEXT");
            }
        };
    }

    private AbstractWizardPage getCompletionPage() {
        return new CompletionWizardPage(PAGENAME_COMPLETE){

            public void setupWizardButtons() {
                this.fireButtonEvent(3300, "BACK");
                this.fireButtonEvent(3301, "FINISH");
                this.fireButtonEvent(3300, "NEXT");
            }
        };
    }

    private boolean validateName() {
        try {
            for (Ontology ont : MedSavantClient.OntologyManager.getOntologies(LoginController.getSessionID())) {
                if (!ont.getName().equals(this.name)) continue;
                DialogUtils.displayError("Error", "Ontology name already in use.");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching ontology list: %s", ex);
            return false;
        }
    }

    private void create() throws InterruptedException, SQLException, IOException {
        try {
            MedSavantClient.OntologyManager.addOntology(LoginController.getSessionID(), this.name, this.type, new URL(this.oboField.getText()), new URL(this.mappingField.getText()));
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
        }
    }
}

