/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.geneset;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.GeneSet;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.GeneSetManagerAdapter;

public class GeneSetController {
    private GeneSet currentSet;
    private Map<String, Gene> genes;
    private static GeneSetController instance;
    private GeneSetManagerAdapter manager = MedSavantClient.GeneSetManager;

    private GeneSetController() {
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    GeneSetController.this.currentSet = null;
                    GeneSetController.this.genes = null;
                }
            }
        });
    }

    public static GeneSetController getInstance() {
        if (instance == null) {
            instance = new GeneSetController();
        }
        return instance;
    }

    public GeneSet getCurrentGeneSet() throws SQLException, RemoteException {
        if (this.currentSet == null) {
            try {
                this.currentSet = this.manager.getGeneSet(LoginController.getSessionID(), ReferenceController.getInstance().getCurrentReferenceName());
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
        }
        return this.currentSet;
    }

    public Collection<Gene> getCurrentGenes() throws SQLException, RemoteException {
        if (this.genes == null) {
            Gene[] rawGenes;
            this.genes = new HashMap<String, Gene>();
            try {
                rawGenes = this.manager.getGenes(LoginController.getSessionID(), this.getCurrentGeneSet());
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
            for (Gene g : rawGenes) {
                this.genes.put(g.getName().toUpperCase(), g);
            }
        }
        return this.genes.values();
    }

    public Gene getGene(String name) throws SQLException, RemoteException {
        this.getCurrentGenes();
        return this.genes.get(name.toUpperCase());
    }
}

