/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.FilterView;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.VariantTag;

public class TagFilterView
extends FilterView {
    private static final Log LOG = LogFactory.getLog(TagFilterView.class);
    public static final String FILTER_NAME = "Tag Filter";
    public static final String FILTER_ID = "tag_filter";
    private List<VariantTag> variantTags;
    private List<VariantTag> appliedTags;
    private ActionListener al;
    private JTextArea ta;
    private final JButton clear;
    private final JButton applyButton;

    public TagFilterView(FilterState state, int queryID) {
        this(queryID);
        List<String> values = state.getValues("value");
        if (values != null) {
            this.applyFilter(this.unwrapValues(values));
        }
    }

    public TagFilterView(int queryID) {
        super(FILTER_NAME, queryID);
        this.setLayout(new BorderLayout());
        this.setBorder(ViewUtil.getBigBorder());
        this.setMaximumSize(new Dimension(200, 80));
        JPanel cp = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        cp.setLayout(gbl);
        this.variantTags = new ArrayList<VariantTag>();
        this.appliedTags = new ArrayList<VariantTag>();
        this.clear = new JButton("Clear");
        this.applyButton = new JButton("Apply");
        try {
            final JComboBox<String> tagNameCB = new JComboBox<String>();
            final JComboBox tagValueCB = new JComboBox();
            JPanel bottomContainer = new JPanel();
            ViewUtil.applyHorizontalBoxLayout(bottomContainer);
            List<String> tagNames = MedSavantClient.VariantManager.getDistinctTagNames(LoginController.getSessionID());
            for (String tag : tagNames) {
                tagNameCB.addItem(tag);
            }
            this.ta = new JTextArea();
            this.ta.setRows(10);
            this.ta.setCursor(Cursor.getPredefinedCursor(0));
            this.ta.setEditable(false);
            this.applyButton.setEnabled(false);
            JLabel addButton = ViewUtil.createIconButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.ADD));
            addButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (tagNameCB.getSelectedItem() == null || tagValueCB.getSelectedItem() == null) {
                        return;
                    }
                    VariantTag tag = new VariantTag((String)tagNameCB.getSelectedItem(), (String)tagValueCB.getSelectedItem());
                    if (TagFilterView.this.variantTags.isEmpty()) {
                        TagFilterView.this.ta.append(tag.toString() + "\n");
                    } else {
                        TagFilterView.this.ta.append("AND " + tag.toString() + "\n");
                    }
                    TagFilterView.this.variantTags.add(tag);
                    TagFilterView.this.applyButton.setEnabled(true);
                }
            });
            this.clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TagFilterView.this.variantTags.clear();
                    TagFilterView.this.ta.setText("");
                    TagFilterView.this.applyButton.setEnabled(true);
                }
            });
            int width = 150;
            this.ta.setPreferredSize(new Dimension(width, width));
            this.ta.setMaximumSize(new Dimension(width, width));
            tagNameCB.setPreferredSize(new Dimension(width, 25));
            tagValueCB.setPreferredSize(new Dimension(width, 25));
            tagNameCB.setMaximumSize(new Dimension(width, 25));
            tagValueCB.setMaximumSize(new Dimension(width, 25));
            cp.add((Component)new JLabel("Name"), c);
            ++c.gridx;
            cp.add(tagNameCB, c);
            ++c.gridx;
            c.gridx = 0;
            ++c.gridy;
            cp.add((Component)new JLabel("Value"), c);
            ++c.gridx;
            cp.add(tagValueCB, c);
            ++c.gridx;
            cp.add((Component)addButton, c);
            tagNameCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    TagFilterView.updateTagValues((String)tagNameCB.getSelectedItem(), tagValueCB);
                }
            });
            if (tagNameCB.getItemCount() > 0) {
                tagNameCB.setSelectedIndex(0);
                TagFilterView.updateTagValues((String)tagNameCB.getSelectedItem(), tagValueCB);
            }
            this.al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagFilterView.this.applyButton.setEnabled(false);
                    TagFilterView.this.appliedTags = new ArrayList(TagFilterView.this.variantTags);
                    Filter f = new Filter(){

                        @Override
                        public Condition[] getConditions() {
                            try {
                                List<Integer> uploadIDs = MedSavantClient.VariantManager.getUploadIDsMatchingVariantTags(LoginController.getSessionID(), TagFilterView.tagsToStringArray(TagFilterView.this.variantTags));
                                Condition[] uploadIDConditions = new Condition[uploadIDs.size()];
                                TableSchema table = MedSavantClient.CustomTablesManager.getCustomTableSchema(LoginController.getSessionID(), MedSavantClient.ProjectManager.getVariantTableName(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), true));
                                for (int i = 0; i < uploadIDs.size(); ++i) {
                                    uploadIDConditions[i] = BinaryCondition.equalTo(table.getDBColumn(BasicVariantColumns.UPLOAD_ID), uploadIDs.get(i));
                                }
                                return new Condition[]{ComboCondition.or(uploadIDConditions)};
                            }
                            catch (Exception ex) {
                                ClientMiscUtils.reportError("Error getting upload IDs: %s", ex);
                                return new Condition[0];
                            }
                        }

                        @Override
                        public String getName() {
                            return TagFilterView.FILTER_NAME;
                        }

                        @Override
                        public String getID() {
                            return TagFilterView.FILTER_ID;
                        }
                    };
                    FilterController.getInstance().addFilter(f, TagFilterView.this.queryID);
                }
            };
            this.applyButton.addActionListener(this.al);
            bottomContainer.add(Box.createHorizontalGlue());
            bottomContainer.add(this.clear);
            bottomContainer.add(this.applyButton);
            this.add((Component)ViewUtil.getClearBorderedScrollPane(this.ta), "Center");
            this.add((Component)bottomContainer, "South");
        }
        catch (Exception ex) {
            ClientMiscUtils.checkSQLException(ex);
        }
        this.add((Component)cp, "North");
        this.showViewCard();
    }

    public final void applyFilter(List<VariantTag> tags) {
        this.variantTags = tags;
        this.ta.setText("");
        for (int i = 0; i < this.variantTags.size(); ++i) {
            VariantTag tag = this.variantTags.get(i);
            if (i == 0) {
                this.ta.append(tag.toString() + "\n");
                continue;
            }
            this.ta.append("AND " + tag.toString() + "\n");
        }
        this.al.actionPerformed(null);
    }

    private static void updateTagValues(String tagName, JComboBox tagValueCB) {
        tagValueCB.removeAllItems();
        if (tagName != null) {
            try {
                List<String> values = MedSavantClient.VariantManager.getValuesForTagName(LoginController.getSessionID(), tagName);
                for (String val : values) {
                    tagValueCB.addItem(val);
                }
            }
            catch (Exception ex) {
                ClientMiscUtils.reportError("Error updating tag values: %s", ex);
            }
        }
        tagValueCB.updateUI();
    }

    private static String[][] tagsToStringArray(List<VariantTag> variantTags) {
        String[][] result = new String[variantTags.size()][2];
        int row = 0;
        for (VariantTag t : variantTags) {
            result[row][0] = t.key;
            result[row][1] = t.value;
            ++row;
        }
        return result;
    }

    public static FilterStateAdapter wrapState(List<VariantTag> applied) {
        FilterState state = new FilterState(Filter.Type.TAG, FILTER_NAME, FILTER_ID);
        state.putValues("value", TagFilterView.wrapValues(applied));
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return TagFilterView.wrapState(this.appliedTags);
    }

    private List<VariantTag> unwrapValues(List<String> strings) {
        ArrayList<VariantTag> tags = new ArrayList<VariantTag>(strings.size());
        for (String s : strings) {
            tags.add(VariantTag.fromString(s));
        }
        return tags;
    }
}

