/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.jidesoft.list.FilterableCheckBoxList;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.swing.SearchableUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.filter.FilterView;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public abstract class TabularFilterView<T>
extends FilterView {
    private static final Log LOG = LogFactory.getLog(TabularFilterView.class);
    private static final int FIELD_WIDTH = 260;
    final Object contentInitializedSemaphore = new Object();
    private List<T> availableValues;
    protected List<T> appliedValues;
    private QuickListFilterField field;
    protected FilterableCheckBoxList filterableList;
    protected JButton applyButton;
    private JButton selectAll;
    private boolean contentInitialized;

    protected TabularFilterView(String name, int queryID) {
        super(name, queryID);
    }

    public List<T> getAvailableValues() {
        return this.availableValues;
    }

    public boolean areAvailableValuesSet() {
        return this.getAvailableValues() == null;
    }

    public void setAvailableValues(List<T> vals) {
        this.availableValues = vals;
    }

    protected final void initContentPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.availableValues == null) {
            JTextArea label = new JTextArea("There are too many unique values to generate this list. You will not be able to filter on this column. ");
            label.setOpaque(false);
            label.setLineWrap(true);
            label.setWrapStyleWord(true);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = new Insets(3, 3, 3, 3);
            this.add((Component)label, gbc);
            this.showViewCard();
            return;
        }
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(false);
        SimpleListModel model = new SimpleListModel();
        this.field = new QuickListFilterField((ListModel)model);
        this.field.setHintText("Type here to filter options");
        this.field.setPreferredSize(new Dimension(260, 22));
        this.filterableList = new FilterableCheckBoxList((ListModel)this.field.getDisplayListModel()){

            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                return -1;
            }

            public boolean isCheckBoxEnabled(int index) {
                return true;
            }
        };
        this.filterableList.getCheckBoxListSelectionModel().setSelectionMode(2);
        if (model.getSize() > 0) {
            this.filterableList.setPrototypeCellValue(model.getElementAt(0));
        }
        SearchableUtils.installSearchable((JList)this.filterableList);
        this.filterableList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TabularFilterView.this.applyButton.setEnabled(true);
                }
            }
        });
        this.setAllSelected(true);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularFilterView.this.applyFilter();
            }
        });
        JScrollPane jsp = new JScrollPane((Component)this.filterableList){

            @Override
            public Dimension getPreferredSize() {
                Dimension result = super.getPreferredSize();
                result = new Dimension(Math.min(result.width, TabularFilterView.this.getWidth() - 20), result.height);
                return result;
            }
        };
        this.selectAll = ViewUtil.createHyperLinkButton("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularFilterView.this.setAllSelected(true);
                TabularFilterView.this.applyButton.setEnabled(true);
            }
        });
        JButton selectNone = ViewUtil.createHyperLinkButton("Select None");
        selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabularFilterView.this.setAllSelected(false);
                TabularFilterView.this.applyButton.setEnabled(true);
            }
        });
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(3, 15, 3, 15);
        this.add((Component)this.field, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jsp, gbc);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.add((Component)this.selectAll, gbc);
        this.add((Component)selectNone, gbc);
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        this.add((Component)this.applyButton, gbc);
        this.showViewCard();
    }

    public final void setFilterValues(Collection<String> list) {
        this.waitForFilterValuesToBeReady();
        int[] selectedIndices = new int[list.size()];
        int i = 0;
        for (String s : list) {
            int j = 0;
            for (T t : this.availableValues) {
                System.out.println("\t" + t + " looking for " + s);
                if (t.toString().equals(s)) break;
                ++j;
            }
            selectedIndices[i++] = j;
        }
        ClientMiscUtils.selectOnlyTheseIndicies(this.filterableList, selectedIndices);
        this.applyFilter();
    }

    protected abstract void applyFilter();

    protected void preapplyFilter() {
        int[] indices;
        this.applyButton.setEnabled(false);
        this.appliedValues = new ArrayList<T>();
        for (int i : indices = this.filterableList.getCheckBoxListSelectedIndices()) {
            this.appliedValues.add(this.availableValues.get(i));
        }
    }

    private void setAllSelected(boolean b) {
        if (b) {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.addCheckBoxListSelectedIndex(i);
            }
        } else {
            for (int i = 0; i < this.filterableList.getModel().getSize(); ++i) {
                this.filterableList.removeCheckBoxListSelectedIndex(i);
            }
        }
    }

    protected void updateModel() {
        this.field.setListModel((ListModel)new SimpleListModel());
        this.filterableList.setModel((ListModel)this.field.getDisplayListModel());
        LOG.info((Object)("Model updated, " + this.field.getDisplayListModel().getSize() + " of " + this.field.getListModel().getSize() + "(" + this.availableValues.size() + ") rows visible."));
    }

    protected class SimpleListModel
    extends AbstractListModel {
        protected SimpleListModel() {
        }

        @Override
        public int getSize() {
            return TabularFilterView.this.availableValues.size();
        }

        @Override
        public Object getElementAt(int i) {
            Object val = TabularFilterView.this.availableValues.get(i);
            if (val instanceof String && ((String)val).length() == 0) {
                return "(null)";
            }
            return val;
        }
    }
}

