/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.TabularFilterView;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class StringListFilterView
extends TabularFilterView<String>
implements BasicPatientColumns,
BasicVariantColumns {
    private final WhichTable whichTable;
    private final String columnName;
    private final String alias;
    private final boolean allowInexactMatch;

    public StringListFilterView(FilterState state, int queryID) throws Exception {
        this(WhichTable.valueOf(state.getOneValue("table")), state.getFilterID(), queryID, state.getName());
        List<String> values = state.getValues("value");
        if (values != null) {
            this.setFilterValues(values);
        }
    }

    public StringListFilterView(WhichTable t, String colName, int queryID, String alias) throws Exception {
        this(t, colName, queryID, alias, false);
    }

    protected StringListFilterView(WhichTable t, String colName, int queryID, String alias, boolean bool) throws Exception {
        super(alias, queryID);
        this.whichTable = t;
        this.columnName = colName;
        this.alias = alias;
        this.allowInexactMatch = t == WhichTable.PATIENT;
        final boolean useCache = t == WhichTable.VARIANT;
        boolean needsWorker = false;
        if (bool) {
            this.setAvailableValues(Arrays.asList("True", "False"));
        } else if (colName.equals(AC.getColumnName())) {
            this.setAvailableValues(Arrays.asList("1", "2"));
        } else if (colName.equals(AF.getColumnName())) {
            this.setAvailableValues(Arrays.asList("0.50", "1.00"));
        } else if (colName.equals(REF.getColumnName()) || colName.equals(ALT.getColumnName())) {
            this.setAvailableValues(Arrays.asList("A", "C", "G", "T"));
        } else if (colName.equals(VARIANT_TYPE.getColumnName())) {
            this.setAvailableValues(Arrays.asList(VariantRecord.VariantType.SNP.toString(), VariantRecord.VariantType.Insertion.toString(), VariantRecord.VariantType.Deletion.toString(), VariantRecord.VariantType.Various.toString(), VariantRecord.VariantType.Unknown.toString()));
        } else if (colName.equals(ZYGOSITY.getColumnName())) {
            this.setAvailableValues(Arrays.asList(VariantRecord.Zygosity.HomoRef.toString(), VariantRecord.Zygosity.HomoAlt.toString(), VariantRecord.Zygosity.Hetero.toString(), VariantRecord.Zygosity.HeteroTriallelic.toString(), VariantRecord.Zygosity.Missing.toString()));
        } else if (colName.equals(GENDER.getColumnName())) {
            this.setAvailableValues(Arrays.asList("Male", "Female", "Undesignated"));
        } else {
            needsWorker = true;
            new MedSavantWorker<Void>("FilterView"){

                @Override
                protected void showProgress(double fract) {
                }

                @Override
                protected void showSuccess(Void result) {
                    StringListFilterView.this.initContentPanel();
                }

                @Override
                protected Void doInBackground() throws Exception {
                    StringListFilterView.this.setAvailableValues(MedSavantClient.DBUtils.getDistinctValuesForColumn(LoginController.getSessionID(), StringListFilterView.this.whichTable.getName(), StringListFilterView.this.columnName, StringListFilterView.this.allowInexactMatch, useCache));
                    if (StringListFilterView.this.columnName.equals(BasicVariantColumns.CHROM.getColumnName())) {
                        Collections.sort(StringListFilterView.this.getAvailableValues(), new ChromosomeComparator());
                    }
                    return null;
                }
            }.execute();
        }
        if (!needsWorker) {
            this.initContentPanel();
        }
    }

    public static FilterState wrapState(WhichTable t, String colName, String alias, Collection<String> applied) {
        FilterState state = new FilterState(Filter.Type.STRING, alias, colName);
        state.putOneValue("table", (Object)t);
        state.putValues("value", StringListFilterView.wrapValues(applied));
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return StringListFilterView.wrapState(this.whichTable, this.columnName, this.alias, this.appliedValues);
    }

    @Override
    protected void applyFilter() {
        int[] indices;
        this.applyButton.setEnabled(false);
        this.appliedValues = new ArrayList();
        for (int i : indices = this.filterableList.getCheckBoxListSelectedIndices()) {
            if (this.columnName.equals(GENDER.getColumnName())) {
                this.appliedValues.add(Integer.toString(ClientMiscUtils.stringToGender((String)this.getAvailableValues().get(i))));
                continue;
            }
            this.appliedValues.add(this.getAvailableValues().get(i));
        }
        if (this.appliedValues.size() == this.getAvailableValues().size()) {
            FilterController.getInstance().removeFilter(this.columnName, this.queryID);
            return;
        }
        FilterController.getInstance().addFilter(new StringListFilter(), this.queryID);
    }

    private class StringListFilter
    extends Filter {
        private StringListFilter() {
        }

        @Override
        public String getName() {
            return StringListFilterView.this.alias;
        }

        @Override
        public String getID() {
            return StringListFilterView.this.columnName;
        }

        @Override
        public Condition[] getConditions() throws SQLException, RemoteException {
            if (StringListFilterView.this.appliedValues.size() > 0) {
                if (StringListFilterView.this.whichTable == WhichTable.VARIANT) {
                    if (StringListFilterView.this.appliedValues.size() == 1) {
                        return new Condition[]{BinaryConditionMS.equalTo(ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(StringListFilterView.this.columnName), StringListFilterView.this.appliedValues.get(0))};
                    }
                    return new Condition[]{new InCondition((Object)ProjectController.getInstance().getCurrentVariantTableSchema().getDBColumn(StringListFilterView.this.columnName), StringListFilterView.this.appliedValues)};
                }
                if (StringListFilterView.this.whichTable == WhichTable.PATIENT) {
                    try {
                        return this.getDNAIDCondition(MedSavantClient.PatientManager.getDNAIDsForStringList(LoginController.getSessionID(), ProjectController.getInstance().getCurrentPatientTableSchema(), StringListFilterView.this.appliedValues, StringListFilterView.this.columnName, StringListFilterView.this.allowInexactMatch));
                    }
                    catch (SessionExpiredException ex) {
                        MedSavantExceptionHandler.handleSessionExpiredException(ex);
                        return null;
                    }
                }
            }
            return FALSE_CONDITION;
        }
    }
}

