/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.UnaryCondition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterState;
import org.ut.biolab.medsavant.client.filter.FilterView;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.DecimalRangeSlider;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.model.RangeCondition;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class NumericFilterView
extends FilterView {
    private final String columnName;
    private final String alias;
    private final WhichTable whichTable;
    private final boolean isDecimal;
    private Range appliedRange;
    private int overallMin;
    private int overallMax;
    private JTextField fromBox;
    private JTextField toBox;
    private DecimalRangeSlider slider;
    private JButton applyButton;
    private final KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10) {
                Range acceptableRange = new Range(NumericFilterView.getNumber(NumericFilterView.this.fromBox.getText()), NumericFilterView.getNumber(NumericFilterView.this.toBox.getText()));
                acceptableRange.bound(NumericFilterView.this.overallMin, NumericFilterView.this.overallMax, false);
                NumericFilterView.this.fromBox.setText(ViewUtil.numToString(acceptableRange.getMin()));
                NumericFilterView.this.toBox.setText(ViewUtil.numToString(acceptableRange.getMax()));
                NumericFilterView.this.slider.setLow(acceptableRange.getMin());
                NumericFilterView.this.slider.setHigh(acceptableRange.getMax());
                NumericFilterView.this.applyButton.setEnabled(true);
            }
        }
    };
    private JButton selectAll;
    private JLabel toLabel;
    private JLabel fromLabel;

    public NumericFilterView(FilterState state, int queryID) throws SQLException, RemoteException {
        this(WhichTable.valueOf(state.getOneValue("table")), state.getFilterID(), queryID, state.getName(), Boolean.valueOf(state.getOneValue("isDecimal")));
        String minString = state.getOneValue("min");
        String maxString = state.getOneValue("max");
        if (minString != null && maxString != null) {
            this.applyFilter(Double.parseDouble(minString), Double.parseDouble(maxString));
        }
    }

    public NumericFilterView(WhichTable t, String col, int queryID, String alias, boolean isDecimal) throws SQLException, RemoteException {
        super(alias, queryID);
        this.whichTable = t;
        this.columnName = col;
        this.alias = alias;
        this.isDecimal = isDecimal;
        this.initUI();
        if (col.equals("position")) {
            this.setExtremeValues(new Range(1.0, 2.5E8));
        } else if (col.equals("sb")) {
            this.setExtremeValues(new Range(-100.0, 100.0));
        } else {
            new MedSavantWorker<Void>("FilterView"){

                @Override
                protected void showProgress(double fract) {
                }

                @Override
                protected void showSuccess(Void result) {
                }

                @Override
                protected Void doInBackground() throws Exception {
                    NumericFilterView.this.setExtremeValues(MedSavantClient.DBUtils.getExtremeValuesForColumn(LoginController.getSessionID(), NumericFilterView.this.whichTable.getName(), NumericFilterView.this.columnName));
                    return null;
                }
            }.execute();
        }
    }

    private void setExtremeValues(Range extremeValues) {
        if (this.columnName.equals("dp")) {
            extremeValues = new Range(Math.min(0.0, extremeValues.getMin()), extremeValues.getMax());
        }
        this.overallMin = (int)Math.floor(extremeValues.getMin());
        this.overallMax = (int)Math.ceil(extremeValues.getMax());
        int precision = 0;
        if (this.isDecimal && this.overallMax - this.overallMin <= 1) {
            precision = 2;
        } else if (this.isDecimal && this.overallMax - this.overallMin <= 10) {
            precision = 1;
        }
        this.slider.setPrecision(precision);
        this.slider.setMinimum(this.overallMin);
        this.slider.setMaximum(this.overallMax);
        this.slider.setLow(this.overallMin);
        this.slider.setHigh(this.overallMax);
        this.slider.updateUI();
        this.fromBox.setText(ViewUtil.numToString(this.overallMin));
        this.toBox.setText(ViewUtil.numToString(this.overallMax));
        this.fromLabel.setText(ViewUtil.numToString(this.overallMin));
        this.toLabel.setText(ViewUtil.numToString(this.overallMax));
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.slider = new DecimalRangeSlider();
        this.slider.setMajorTickSpacing(5);
        this.slider.setMinorTickSpacing(1);
        this.fromBox = new JTextField();
        this.toBox = new JTextField();
        this.fromBox.setMaximumSize(new Dimension(10000, 24));
        this.toBox.setMaximumSize(new Dimension(10000, 24));
        this.fromLabel = new JLabel();
        this.toLabel = new JLabel();
        JPanel fromToContainer = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(fromToContainer);
        fromToContainer.add(this.fromBox);
        fromToContainer.add(new JLabel(" - "));
        fromToContainer.add(this.toBox);
        JPanel minMaxContainer = ViewUtil.getClearPanel();
        ViewUtil.applyHorizontalBoxLayout(minMaxContainer);
        minMaxContainer.add(this.fromLabel);
        minMaxContainer.add((Component)((Object)this.slider));
        minMaxContainer.add(this.toLabel);
        this.add(fromToContainer);
        this.add(minMaxContainer);
        this.add(Box.createVerticalBox());
        this.applyButton = new JButton("Apply");
        this.applyButton.setEnabled(false);
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                NumericFilterView.this.fromBox.setText(ViewUtil.numToString(NumericFilterView.this.slider.getLow()));
                NumericFilterView.this.toBox.setText(ViewUtil.numToString(NumericFilterView.this.slider.getHigh()));
            }
        });
        this.fromBox.addKeyListener(this.keyListener);
        this.toBox.addKeyListener(this.keyListener);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumericFilterView.this.applyButton.setEnabled(false);
                NumericFilterView.this.appliedRange = new Range(NumericFilterView.getNumber(NumericFilterView.this.fromBox.getText()), NumericFilterView.getNumber(NumericFilterView.this.toBox.getText()));
                NumericFilterView.this.appliedRange.bound(NumericFilterView.this.overallMin, NumericFilterView.this.overallMax, true);
                NumericFilterView.this.fromBox.setText(ViewUtil.numToString(NumericFilterView.this.appliedRange.getMin()));
                NumericFilterView.this.toBox.setText(ViewUtil.numToString(NumericFilterView.this.appliedRange.getMax()));
                NumericFilterView.this.slider.setLow(NumericFilterView.this.appliedRange.getMin());
                NumericFilterView.this.slider.setHigh(NumericFilterView.this.appliedRange.getMax());
                Filter f = new Filter(){

                    @Override
                    public Condition[] getConditions() throws SQLException, RemoteException {
                        TableSchema variantSchema = ProjectController.getInstance().getCurrentVariantTableSchema();
                        if (NumericFilterView.this.whichTable == WhichTable.VARIANT) {
                            double min = NumericFilterView.this.appliedRange.getMin();
                            double max = NumericFilterView.this.appliedRange.getMax();
                            if (NumericFilterView.this.isDecimal) {
                                if ((double)NumericFilterView.this.overallMin == min) {
                                    return new Condition[]{UnaryCondition.isNull(variantSchema.getDBColumn(NumericFilterView.this.columnName)), new RangeCondition(variantSchema.getDBColumn(NumericFilterView.this.columnName), min, max)};
                                }
                                return new Condition[]{new RangeCondition(variantSchema.getDBColumn(NumericFilterView.this.columnName), min, max)};
                            }
                            if ((double)NumericFilterView.this.overallMin == min) {
                                return new Condition[]{UnaryCondition.isNull(variantSchema.getDBColumn(NumericFilterView.this.columnName)), new RangeCondition(variantSchema.getDBColumn(NumericFilterView.this.columnName), (int)Math.floor(min), (int)Math.ceil(max))};
                            }
                            return new Condition[]{new RangeCondition(variantSchema.getDBColumn(NumericFilterView.this.columnName), (int)Math.floor(min), (int)Math.ceil(max))};
                        }
                        try {
                            return this.getDNAIDCondition(MedSavantClient.PatientManager.getDNAIDsWithValuesInRange(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), NumericFilterView.this.columnName, NumericFilterView.this.appliedRange));
                        }
                        catch (SessionExpiredException ex) {
                            MedSavantExceptionHandler.handleSessionExpiredException(ex);
                            return null;
                        }
                    }

                    @Override
                    public String getName() {
                        return NumericFilterView.this.alias;
                    }

                    @Override
                    public String getID() {
                        return NumericFilterView.this.columnName;
                    }
                };
                FilterController.getInstance().addFilter(f, NumericFilterView.this.queryID);
            }
        };
        this.applyButton.addActionListener(al);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                NumericFilterView.this.applyButton.setEnabled(true);
            }
        });
        this.selectAll = ViewUtil.createHyperLinkButton("Select All");
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumericFilterView.this.slider.setLowValue(NumericFilterView.this.overallMin);
                NumericFilterView.this.slider.setHighValue(NumericFilterView.this.overallMax);
                NumericFilterView.this.fromBox.setText(ViewUtil.numToString(NumericFilterView.this.overallMin));
                NumericFilterView.this.toBox.setText(ViewUtil.numToString(NumericFilterView.this.overallMax));
                NumericFilterView.this.applyButton.setEnabled(true);
            }
        });
        JPanel bottomContainer = ViewUtil.getClearPanel();
        bottomContainer.setLayout(new BoxLayout(bottomContainer, 0));
        bottomContainer.add(this.selectAll);
        bottomContainer.add(Box.createHorizontalGlue());
        bottomContainer.add(this.applyButton);
        this.add(bottomContainer);
        this.showViewCard();
    }

    public void applyFilter(int low, int high) {
        this.applyFilter((double)low, (double)high);
    }

    public final void applyFilter(double low, double high) {
        this.applyFilterSilently(low, high);
        this.applyButton.doClick();
    }

    public final void applyFilterSilently(double low, double high) {
        this.fromBox.setText(Double.toString(low));
        this.toBox.setText(Double.toString(high));
        this.slider.setLow(low);
        this.slider.setHigh(high);
    }

    private static double getNumber(String s) {
        try {
            return Double.parseDouble(s.replaceAll(",", ""));
        }
        catch (NumberFormatException ignored) {
            return 0.0;
        }
    }

    public static FilterState wrapState(WhichTable t, String colName, String alias, Range r, boolean dec) {
        FilterState state = new FilterState(Filter.Type.NUMERIC, alias, colName);
        state.putOneValue("table", (Object)t);
        state.putOneValue("isDecimal", dec);
        if (r != null) {
            state.putOneValue("min", r.getMin());
            state.putOneValue("max", r.getMax());
        }
        return state;
    }

    @Override
    public FilterStateAdapter saveState() {
        return NumericFilterView.wrapState(this.whichTable, this.columnName, this.alias, this.appliedRange, this.isDecimal);
    }
}

