/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;

public abstract class FilterView
extends JPanel {
    private final String title;
    protected final int queryID;
    protected final JPanel viewCard;
    protected final JPanel waitCard;
    private boolean initialized = false;
    private boolean filterValuesReady;
    public final Object filterValuesReadySemaphore = new Object();

    public FilterView(String title, int queryID) {
        this.viewCard = new JPanel();
        this.waitCard = new JPanel();
        this.waitCard.setLayout(new BorderLayout());
        JProgressBar idpb = new JProgressBar();
        idpb.setIndeterminate(true);
        this.waitCard.add((Component)idpb, "Center");
        super.setLayout(new BorderLayout());
        super.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        super.add((Component)this.viewCard, "Center");
        this.initialized = true;
        this.title = title;
        this.queryID = queryID;
        this.showWaitCard();
    }

    public String getTitle() {
        return this.title;
    }

    public abstract FilterStateAdapter saveState();

    public void cleanup() {
    }

    public static List<String> wrapValues(Collection applied) {
        ArrayList<String> result = new ArrayList<String>();
        if (applied != null && !applied.isEmpty()) {
            for (Object val : applied) {
                result.add(val.toString());
            }
        }
        return result;
    }

    public final synchronized void showWaitCard() {
        super.removeAll();
        super.setLayout(new BorderLayout());
        super.add((Component)this.waitCard, "Center");
        super.updateUI();
    }

    public final synchronized void showViewCard() {
        this.setFilterValuesReady(true);
        super.removeAll();
        super.setLayout(new BorderLayout());
        super.add((Component)this.viewCard, "Center");
        super.updateUI();
    }

    @Override
    public Component add(Component c) {
        if (this.initialized) {
            return this.viewCard.add(c);
        }
        return super.add(c);
    }

    @Override
    public void add(Component c, Object o) {
        if (this.initialized) {
            this.viewCard.add(c, o);
        } else {
            super.add(c, o);
        }
    }

    @Override
    public Component add(Component c, int i) {
        if (this.initialized) {
            return this.viewCard.add(c, i);
        }
        return super.add(c, i);
    }

    @Override
    public void setLayout(LayoutManager lm) {
        if (this.initialized) {
            if (lm instanceof BoxLayout) {
                BoxLayout bl = (BoxLayout)lm;
                lm = new BoxLayout(this.viewCard, bl.getAxis());
            }
            this.viewCard.setLayout(lm);
        } else {
            super.setLayout(lm);
        }
    }

    @Override
    public void setBorder(Border b) {
        if (this.initialized) {
            this.viewCard.setBorder(b);
        } else {
            super.setBorder(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilterValuesReady(boolean b) {
        this.filterValuesReady = true;
        Object object = this.filterValuesReadySemaphore;
        synchronized (object) {
            this.filterValuesReadySemaphore.notify();
        }
    }

    public boolean areFilterValuesReady() {
        return this.filterValuesReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFilterValuesToBeReady() {
        if (!this.areFilterValuesReady()) {
            Object object = this.filterValuesReadySemaphore;
            synchronized (object) {
                try {
                    this.filterValuesReadySemaphore.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

