/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.ut.biolab.medsavant.client.api.FilterStateAdapter;
import org.ut.biolab.medsavant.client.filter.Filter;

public class FilterState
implements FilterStateAdapter {
    public static final String ROOT_ELEMENT = "filters";
    public static final String SET_ELEMENT = "set";
    public static final String FILTER_ELEMENT = "filter";
    public static final String TABLE_ELEMENT = "table";
    public static final String VALUE_ELEMENT = "value";
    private final Filter.Type type;
    private final String name;
    private final String filterID;
    private final Map<String, List<String>> values = new HashMap<String, List<String>>();

    public FilterState(Filter.Type type, String name, String id) {
        this.type = type;
        this.name = name;
        this.filterID = id;
    }

    public String getName() {
        return this.name;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public Filter.Type getType() {
        return this.type;
    }

    @Override
    public String getOneValue(String key) {
        List<String> keyValues = this.values.get(key);
        if (keyValues != null && keyValues.size() > 0) {
            return keyValues.get(0);
        }
        return null;
    }

    @Override
    public void putOneValue(String key, Object val) {
        this.values.put(key, Arrays.asList(val.toString()));
    }

    @Override
    public List<String> getValues(String key) {
        return this.values.get(key);
    }

    @Override
    public void putValues(String key, List<String> vals) {
        this.values.put(key, vals);
    }

    public String getTable() {
        return this.getOneValue(TABLE_ELEMENT);
    }

    @Override
    public String generateXML() {
        StringBuilder sb = new StringBuilder("\t\t<filter name=\"" + this.name + "\" id=\"" + this.filterID + "\" type=\"" + (Object)((Object)this.type) + "\" >\n");
        for (String key : this.values.keySet()) {
            List<String> keyVals = this.values.get(key);
            for (String val : keyVals) {
                sb.append("\t\t\t<").append(key).append(">").append(val).append("</").append(key).append(">\n");
            }
        }
        sb.append("\t\t</filter>");
        return sb.toString();
    }

    public static List<List<FilterState>> loadFiltersFromFiles(Collection<File> files) throws XMLStreamException, FileNotFoundException {
        ArrayList<List<FilterState>> states = new ArrayList<List<FilterState>>();
        for (File f : files) {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(f));
            boolean done = false;
            ArrayList<FilterState> curSet = null;
            FilterState curFilter = null;
            do {
                switch (reader.next()) {
                    case 1: {
                        String elem = reader.getLocalName();
                        if (elem.equals(SET_ELEMENT)) {
                            curSet = new ArrayList<FilterState>();
                            break;
                        }
                        if (elem.equals(FILTER_ELEMENT)) {
                            if (curSet == null) {
                                throw new XMLStreamException("XML error: <filter> found outside of <set> element.");
                            }
                            String name = reader.getAttributeValue(null, "name");
                            String id = reader.getAttributeValue(null, "id");
                            Filter.Type type = Filter.Type.valueOf(reader.getAttributeValue(null, "type"));
                            curFilter = new FilterState(type, name, id);
                            break;
                        }
                        if (elem.equals(ROOT_ELEMENT)) break;
                        if (curFilter == null) {
                            throw new XMLStreamException("XML error: <" + elem + "> found outside of <filter> element.");
                        }
                        List<String> existingValues = curFilter.values.get(elem);
                        if (existingValues == null) {
                            existingValues = new ArrayList<String>();
                            curFilter.values.put(elem, existingValues);
                        }
                        existingValues.add(reader.getElementText());
                        break;
                    }
                    case 2: {
                        String elem = reader.getLocalName();
                        if (elem.equals(SET_ELEMENT)) {
                            states.add(curSet);
                            curSet = null;
                            break;
                        }
                        if (!elem.equals(FILTER_ELEMENT)) break;
                        curSet.add(curFilter);
                        curFilter = null;
                        break;
                    }
                    case 8: {
                        reader.close();
                        done = true;
                    }
                }
            } while (!done);
        }
        return states;
    }
}

