/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.filter.Filter;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class FilterHistoryPanel
extends JPanel {
    private static final Log LOG = LogFactory.getLog(FilterHistoryPanel.class);
    private int maxRecords = 0;
    private JTable table;
    private ProgressTableModel model;
    private Mode mode = Mode.GLOBAL;
    private Color TOTAL_COLOR = new Color(225, 244, 254);
    private Color REMAINING_COLOR = new Color(72, 181, 249);
    private Color PREVIOUS_COLOR = new Color(179, 255, 217);
    private Color NEW_COLOR = new Color(0, 153, 77);

    public FilterHistoryPanel() {
        FilterController.getInstance().addListener(new Listener<FilterEvent>(){

            @Override
            public void handleEvent(final FilterEvent event) {
                new MedSavantWorker<Void>("FilterHistoryPanel"){

                    @Override
                    protected void showProgress(double fraction) {
                    }

                    @Override
                    protected void showSuccess(Void result) {
                    }

                    @Override
                    protected Void doInBackground() throws Exception {
                        int numLeft = ResultController.getInstance().getFilteredVariantCount();
                        FilterHistoryPanel.this.addFilterSet(event.getFilter(), event.getType(), numLeft);
                        return null;
                    }
                }.execute();
            }
        });
        ReferenceController.getInstance().addListener(new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    FilterHistoryPanel.this.reset();
                }
            }
        });
        this.setBorder(ViewUtil.getMediumBorder());
        this.setMinimumSize(new Dimension(200, 300));
        this.setPreferredSize(new Dimension(200, 300));
        this.setName("History");
        this.setLayout(new BorderLayout());
        this.table = new JTable(){

            @Override
            public TableCellRenderer getCellRenderer(int row, int column) {
                if (FilterHistoryPanel.this.model.getColumnClass(column).equals(JPanel.class)) {
                    return new JPanelRenderer();
                }
                return super.getCellRenderer(row, column);
            }
        };
        this.model = new ProgressTableModel();
        this.table.setModel(this.model);
        JPanel modePanel = ViewUtil.getClearPanel();
        ButtonGroup group = new ButtonGroup();
        JRadioButton globalButton = new JRadioButton("Global");
        ViewUtil.makeSmall(globalButton);
        globalButton.setSelected(true);
        globalButton.setOpaque(false);
        JRadioButton relativeButton = new JRadioButton("Relative to previous change");
        ViewUtil.makeSmall(relativeButton);
        relativeButton.setOpaque(false);
        globalButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                FilterHistoryPanel.this.changeMode(Mode.GLOBAL);
            }
        });
        relativeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                FilterHistoryPanel.this.changeMode(Mode.RELATIVE);
            }
        });
        group.add(globalButton);
        group.add(relativeButton);
        modePanel.add(globalButton);
        modePanel.add(relativeButton);
        this.add((Component)modePanel, "North");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.table);
        this.add((Component)scrollPane, "Center");
        this.reset();
    }

    public final void reset() {
        this.model.clear();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    FilterHistoryPanel.this.maxRecords = ResultController.getInstance().getFilteredVariantCount();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error getting num filtered variants.", (Throwable)ex);
                }
                if (FilterHistoryPanel.this.maxRecords != -1) {
                    FilterHistoryPanel.this.model.addRow("Total", "", FilterHistoryPanel.this.maxRecords);
                }
                FilterHistoryPanel.this.table.repaint();
            }
        };
        t.start();
    }

    private synchronized void changeMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.model.setMode(mode);
        this.table.getColumnModel().getColumn(3).setHeaderValue(this.model.getColumnName(3));
        this.table.getTableHeader().resizeAndRepaint();
        this.table.repaint();
    }

    private void addFilterSet(Filter filter, FilterEvent.Type action, int numLeft) {
        this.model.addRow(filter.getName(), action.toString(), numLeft);
        this.table.updateUI();
        this.repaint();
    }

    private class JPanelRenderer
    implements TableCellRenderer {
        private JPanelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)value;
        }
    }

    private class ProgressTableModel
    extends AbstractTableModel {
        private Mode mode = Mode.GLOBAL;
        private String[] globalColumnNames = new String[]{"Filter Name", "Action", "Records", "% of Total"};
        private String[] relativeColumnNames = new String[]{"Filter Name", "Action", "Records", "Change"};
        private Class[] columnClasses = new Class[]{String.class, String.class, String.class, JPanel.class};
        List<String> names = new ArrayList<String>();
        List<String> actions = new ArrayList<String>();
        List<Integer> records = new ArrayList<Integer>();

        private ProgressTableModel() {
        }

        public void addRow(String name, String action, int numRecords) {
            this.names.add(name);
            this.actions.add(action);
            this.records.add(numRecords);
        }

        public void clear() {
            this.names.clear();
            this.actions.clear();
            this.records.clear();
        }

        public void setMode(Mode mode) {
            this.mode = mode;
        }

        @Override
        public String getColumnName(int column) {
            if (this.mode == Mode.GLOBAL) {
                return this.globalColumnNames[column];
            }
            return this.relativeColumnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            if (this.mode == Mode.GLOBAL) {
                return this.globalColumnNames.length;
            }
            return this.relativeColumnNames.length;
        }

        public Class getColumnClass(int column) {
            return this.columnClasses[column];
        }

        @Override
        public Object getValueAt(final int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.names.get(rowIndex);
                }
                case 1: {
                    return this.actions.get(rowIndex);
                }
                case 2: {
                    return MiscUtils.numToString(this.records.get(rowIndex).intValue());
                }
                case 3: {
                    JPanel p;
                    if (this.mode == Mode.GLOBAL) {
                        p = new JPanel(){

                            @Override
                            protected void paintComponent(Graphics g) {
                                super.paintComponent(g);
                                Dimension dim = this.getSize();
                                g.setColor(FilterHistoryPanel.this.REMAINING_COLOR);
                                g.fillRect(0, 0, (int)((double)dim.width * ((double)ProgressTableModel.this.records.get(rowIndex).intValue() / (double)ProgressTableModel.this.records.get(0).intValue())), dim.height);
                            }
                        };
                        p.setBackground(FilterHistoryPanel.this.TOTAL_COLOR);
                    } else {
                        p = new JPanel(){

                            @Override
                            protected void paintComponent(Graphics g) {
                                super.paintComponent(g);
                                if (rowIndex == 0) {
                                    return;
                                }
                                Dimension dim = this.getSize();
                                double ratio = (double)ProgressTableModel.this.records.get(rowIndex).intValue() / (double)ProgressTableModel.this.records.get(rowIndex - 1).intValue();
                                if (ratio > 1.0) {
                                    ratio = 1.0 / ratio;
                                    g.setColor(FilterHistoryPanel.this.NEW_COLOR);
                                    g.fillRect(0, 0, dim.width, dim.height);
                                    g.setColor(FilterHistoryPanel.this.PREVIOUS_COLOR);
                                    g.fillRect(0, 0, (int)((double)dim.width * ratio), dim.height);
                                } else {
                                    g.setColor(FilterHistoryPanel.this.PREVIOUS_COLOR);
                                    g.fillRect(0, 0, dim.width, dim.height);
                                    g.setColor(FilterHistoryPanel.this.NEW_COLOR);
                                    g.fillRect(0, 0, (int)((double)dim.width * ratio), dim.height);
                                }
                            }
                        };
                    }
                    return p;
                }
            }
            return null;
        }
    }

    private static enum Mode {
        GLOBAL,
        RELATIVE;

    }
}

