/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.concurrent.Semaphore;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ResultController;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.FilterEvent;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.reference.ReferenceEvent;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class FilterEffectivenessPanel
extends JLayeredPane {
    private static final Log LOG = LogFactory.getLog(FilterEffectivenessPanel.class);
    int numLeft = 1;
    int numTotal = 1;
    private int waitCounter = 0;
    private final JLabel labelVariantsRemaining;
    private WaitPanel waitPanel;
    private JPanel panel;
    private static Listener<FilterEvent> filterEventListener = null;
    private static Listener<ReferenceEvent> referenceEventListener = null;
    private Semaphore updateSem = new Semaphore(1);

    public FilterEffectivenessPanel() {
        this(Color.black);
    }

    public FilterEffectivenessPanel(Color foregroundColor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.setPreferredSize(new Dimension(280, 80));
        this.setMaximumSize(new Dimension(280, 80));
        this.setLayout(new GridBagLayout());
        this.waitPanel = new WaitPanel("Applying Filters");
        this.waitPanel.setVisible(false);
        this.add(this.waitPanel, gbc, JLayeredPane.DRAG_LAYER);
        this.panel = ViewUtil.getClearPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(ViewUtil.getMediumBorder());
        this.add(this.panel, gbc, JLayeredPane.DEFAULT_LAYER);
        this.labelVariantsRemaining = ViewUtil.getDetailTitleLabel("");
        this.labelVariantsRemaining.setForeground(foregroundColor);
        JPanel infoPanel = ViewUtil.getClearPanel();
        ViewUtil.applyVerticalBoxLayout(infoPanel);
        final JLabel a = new JLabel("");
        a.setForeground(foregroundColor);
        ViewUtil.makeSmall(a);
        infoPanel.add(ViewUtil.centerHorizontally(a));
        Listener<FilterEvent> fe = new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                try {
                    if (MedSavantClient.VariantManager.willApproximateCountsForConditions(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions())) {
                        a.setText("approximately");
                    } else {
                        a.setText("");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        fe.handleEvent(null);
        FilterController.getInstance().addListener(fe);
        infoPanel.add(ViewUtil.centerHorizontally(this.labelVariantsRemaining));
        JLabel l = new JLabel("of all variants pass search conditions");
        l.setForeground(foregroundColor);
        ViewUtil.makeSmall(l);
        infoPanel.add(ViewUtil.centerHorizontally(l));
        infoPanel.setBorder(ViewUtil.getMediumTopHeavyBorder());
        this.panel.add((Component)infoPanel, "North");
        this.initListeners();
    }

    private synchronized void initListeners() {
        if (filterEventListener != null) {
            FilterController.getInstance().removeListener(filterEventListener);
        }
        if (referenceEventListener != null) {
            ReferenceController.getInstance().removeListener(referenceEventListener);
        }
        this.setMaxValues();
        this.updateNumRemaining();
        filterEventListener = new Listener<FilterEvent>(){

            @Override
            public void handleEvent(FilterEvent event) {
                FilterEffectivenessPanel.this.updateNumRemaining();
            }
        };
        FilterController.getInstance().addListener(filterEventListener);
        referenceEventListener = new Listener<ReferenceEvent>(){

            @Override
            public void handleEvent(ReferenceEvent event) {
                if (event.getType() == ReferenceEvent.Type.CHANGED) {
                    FilterEffectivenessPanel.this.setMaxValues();
                }
            }
        };
        ReferenceController.getInstance().addListener(referenceEventListener);
    }

    public final void updateNumRemaining() {
        this.showWaitCard();
        new MedSavantWorker<Integer>("Filters"){

            @Override
            protected Integer doInBackground() throws Exception {
                FilterEffectivenessPanel.this.updateSem.acquire();
                return ResultController.getInstance().getFilteredVariantCount();
            }

            @Override
            protected void showProgress(double fraction) {
            }

            @Override
            protected void showSuccess(Integer result) {
                FilterEffectivenessPanel.this.showShowCard();
                FilterEffectivenessPanel.this.setNumLeft(result);
                FilterEffectivenessPanel.this.updateSem.release();
            }

            @Override
            protected void showFailure(Throwable ex) {
                FilterEffectivenessPanel.this.showShowCard();
                LOG.error((Object)"Error getting filtered variant count.", ex);
                FilterEffectivenessPanel.this.updateSem.release();
            }
        }.execute();
    }

    private void setNumLeft(int num) {
        this.numLeft = num;
        this.refreshProgressLabel();
    }

    private void setMaxValues() {
        this.labelVariantsRemaining.setText("Calculating...");
        new MedSavantWorker<Integer>("Filters"){

            @Override
            protected void showFailure(Throwable ex) {
                FilterEffectivenessPanel.this.showShowCard();
                LOG.error((Object)"Error getting total variant count.", ex);
                FilterEffectivenessPanel.this.updateSem.release();
            }

            @Override
            protected void showProgress(double fraction) {
            }

            @Override
            protected void showSuccess(Integer result) {
                FilterEffectivenessPanel.this.numTotal = result;
                FilterEffectivenessPanel.this.setNumLeft(FilterEffectivenessPanel.this.numTotal);
                FilterEffectivenessPanel.this.updateSem.release();
            }

            @Override
            protected Integer doInBackground() throws Exception {
                FilterEffectivenessPanel.this.updateSem.acquire();
                return ResultController.getInstance().getTotalVariantCount();
            }
        }.execute();
    }

    public synchronized void showWaitCard() {
        ++this.waitCounter;
        this.waitPanel.setVisible(true);
        this.setLayer(this.waitPanel, JLayeredPane.DRAG_LAYER);
        this.waitPanel.repaint();
    }

    public synchronized void showShowCard() {
        --this.waitCounter;
        if (this.waitCounter <= 0) {
            this.waitPanel.setVisible(false);
            this.waitCounter = 0;
        }
    }

    private void refreshProgressLabel() {
        double percent = 100.0;
        if (this.numTotal > 0) {
            percent = (double)this.numLeft * 100.0 / (double)this.numTotal;
        }
        this.labelVariantsRemaining.setText(String.format("%,d (%.1f%%)", this.numLeft, percent));
        this.panel.revalidate();
        this.panel.repaint();
    }
}

